/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.procaddress;

import com.jogamp.gluegen.JavaConfiguration;
import java.io.File;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;

public class ProcAddressConfiguration
extends JavaConfiguration {
    private boolean emitProcAddressTable = false;
    private boolean forceProcAddressGen4All = false;
    private String tableClassPackage;
    private String tableClassName = "ProcAddressTable";
    private String getProcAddressTableExpr;
    private String localProcAddressCallingConvention4All = null;
    private ConvNode procAddressNameConverter;
    private final Set<String> skipProcAddressGen = new HashSet<String>();
    private final List<String> forceProcAddressGen = new ArrayList<String>();
    private final Set<String> forceProcAddressGenSet = new HashSet<String>();
    private Map<String, String> localProcAddressCallingConventionMap = new HashMap<String, String>();

    @Override
    protected void dispatch(String string, StringTokenizer stringTokenizer, File file, String string2, int n) throws IOException {
        if (string.equalsIgnoreCase("EmitProcAddressTable")) {
            this.emitProcAddressTable = this.readBoolean("EmitProcAddressTable", stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("ProcAddressTablePackage")) {
            this.tableClassPackage = this.readString("ProcAddressTablePackage", stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("ProcAddressTableClassName")) {
            this.tableClassName = this.readString("ProcAddressTableClassName", stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("SkipProcAddressGen")) {
            String string3 = this.readString("SkipProcAddressGen", stringTokenizer, string2, n);
            this.skipProcAddressGen.add(string3);
        } else if (string.equalsIgnoreCase("ForceProcAddressGen")) {
            String string4 = this.readString("ForceProcAddressGen", stringTokenizer, string2, n);
            if (string4.equals("__ALL__")) {
                this.forceProcAddressGen4All = true;
            } else {
                this.addForceProcAddressGen(string4);
            }
        } else if (string.equalsIgnoreCase("GetProcAddressTableExpr")) {
            this.getProcAddressTableExpr = this.readGetProcAddressTableExpr(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("ProcAddressNameExpr")) {
            this.readProcAddressNameExpr(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("LocalProcAddressCallingConvention")) {
            this.readLocalProcAddressCallingConvention(stringTokenizer, string2, n);
        } else {
            super.dispatch(string, stringTokenizer, file, string2, n);
        }
    }

    protected String readGetProcAddressTableExpr(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken("\n\r\f");
            return string2.trim();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"GetProcAddressTableExpr\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void setProcAddressNameExpr(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "$()", true);
            while (stringTokenizer2.hasMoreTokens()) {
                arrayList.add(stringTokenizer2.nextToken());
            }
        }
        this.procAddressNameConverter = ProcAddressConfiguration.makeConverter(arrayList.iterator());
        if (this.procAddressNameConverter == null) {
            throw new NoSuchElementException("Error creating converter from string");
        }
    }

    protected void readProcAddressNameExpr(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken("\n\r\f");
            string2 = string2.trim();
            this.setProcAddressNameExpr(string2);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"ProcAddressNameExpr\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void readLocalProcAddressCallingConvention(StringTokenizer stringTokenizer, String string, int n) throws IOException {
        try {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            if (string2.equals("__ALL__")) {
                this.localProcAddressCallingConvention4All = string3;
            } else {
                this.localProcAddressCallingConventionMap.put(string2, string3);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"LocalProcAddressCallingConvention\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    private static ConvNode makeConverter(Iterator<String> iterator) {
        ArrayList<ConvNode> arrayList = new ArrayList<ConvNode>();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.equals("$")) {
                String string2 = iterator.next();
                String string3 = iterator.next();
                if (!string3.equals("(")) {
                    throw new NoSuchElementException("Expected \"(\"");
                }
                boolean bl = false;
                if (string2.equalsIgnoreCase("UPPERCASE")) {
                    bl = true;
                } else if (!string2.equalsIgnoreCase("LOWERCASE")) {
                    throw new NoSuchElementException("Unknown ProcAddressNameExpr command \"" + string2 + "\"");
                }
                arrayList.add(new CaseNode(bl, ProcAddressConfiguration.makeConverter(iterator)));
                continue;
            }
            if (string.equals(")")) continue;
            if (string.indexOf(123) >= 0) {
                arrayList.add(new FormatNode(string));
                continue;
            }
            arrayList.add(new ConstStringNode(string));
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (ConvNode)arrayList.get(0);
        }
        return new ConcatNode(arrayList);
    }

    public boolean emitProcAddressTable() {
        return this.emitProcAddressTable;
    }

    public String tableClassPackage() {
        return this.tableClassPackage;
    }

    public String tableClassName() {
        return this.tableClassName;
    }

    public boolean skipProcAddressGen(String string) {
        return this.skipProcAddressGen.contains(string);
    }

    public boolean isForceProcAddressGen4All() {
        return this.forceProcAddressGen4All;
    }

    public List<String> getForceProcAddressGen() {
        return this.forceProcAddressGen;
    }

    public String getProcAddressTableExpr() {
        if (this.getProcAddressTableExpr == null) {
            throw new RuntimeException("GetProcAddressTableExpr was not defined in .cfg file");
        }
        return this.getProcAddressTableExpr;
    }

    public String convertToFunctionPointerName(String string) {
        if (this.procAddressNameConverter == null) {
            throw new RuntimeException("ProcAddressNameExpr was not defined in .cfg file");
        }
        return this.procAddressNameConverter.convert(string);
    }

    public boolean forceProcAddressGen(String string) {
        return this.forceProcAddressGen4All || this.forceProcAddressGenSet.contains(string);
    }

    public void addForceProcAddressGen(String string) {
        this.forceProcAddressGen.add(string);
        this.forceProcAddressGenSet.add(string);
    }

    public void addLocalProcAddressCallingConvention(String string, String string2) {
        this.localProcAddressCallingConventionMap.put(string, string2);
    }

    public String getLocalProcAddressCallingConvention(String string) {
        if (this.isLocalProcAddressCallingConvention4All()) {
            return this.getLocalProcAddressCallingConvention4All();
        }
        return this.localProcAddressCallingConventionMap.get(string);
    }

    public boolean isLocalProcAddressCallingConvention4All() {
        return this.localProcAddressCallingConvention4All != null;
    }

    public String getLocalProcAddressCallingConvention4All() {
        return this.localProcAddressCallingConvention4All;
    }

    static class CaseNode
    extends ConvNode {
        private boolean upperCase;
        private ConvNode child;

        CaseNode(boolean bl, ConvNode convNode) {
            this.upperCase = bl;
            this.child = convNode;
        }

        @Override
        public String convert(String string) {
            if (this.upperCase) {
                return this.child.convert(string).toUpperCase();
            }
            return this.child.convert(string).toLowerCase();
        }
    }

    static class ConcatNode
    extends ConvNode {
        private List<ConvNode> children;

        ConcatNode(List<ConvNode> list) {
            this.children = list;
        }

        @Override
        String convert(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ConvNode convNode : this.children) {
                stringBuilder.append(convNode.convert(string));
            }
            return stringBuilder.toString();
        }
    }

    static class ConstStringNode
    extends ConvNode {
        private String str;

        ConstStringNode(String string) {
            this.str = string;
        }

        @Override
        String convert(String string) {
            return this.str;
        }
    }

    static class FormatNode
    extends ConvNode {
        private MessageFormat msgFmt;

        FormatNode(String string) {
            this.msgFmt = new MessageFormat(string);
        }

        @Override
        String convert(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            this.msgFmt.format(new Object[]{string}, stringBuffer, (FieldPosition)null);
            return stringBuffer.toString();
        }
    }

    static abstract class ConvNode {
        ConvNode() {
        }

        abstract String convert(String var1);
    }
}

