/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.procaddress;

import com.jogamp.gluegen.CMethodBindingEmitter;
import com.jogamp.gluegen.CodeGenUtils;
import com.jogamp.gluegen.FunctionEmitter;
import com.jogamp.gluegen.JavaConfiguration;
import com.jogamp.gluegen.JavaEmitter;
import com.jogamp.gluegen.JavaMethodBindingEmitter;
import com.jogamp.gluegen.MethodBinding;
import com.jogamp.gluegen.cgram.types.FunctionSymbol;
import com.jogamp.gluegen.cgram.types.FunctionType;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.cgram.types.TypeDictionary;
import com.jogamp.gluegen.procaddress.ProcAddressCMethodBindingEmitter;
import com.jogamp.gluegen.procaddress.ProcAddressConfiguration;
import com.jogamp.gluegen.procaddress.ProcAddressJavaMethodBindingEmitter;
import com.jogamp.gluegen.runtime.FunctionAddressResolver;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import java.io.File;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProcAddressEmitter
extends JavaEmitter {
    public static final String PROCADDRESS_VAR_PREFIX = "_addressof_";
    protected static final String WRAP_PREFIX = "dispatch_";
    private TypeDictionary typedefDictionary;
    protected PrintWriter tableWriter;
    protected Set<String> emittedTableEntries;
    protected String tableClassPackage;
    protected String tableClassName;

    @Override
    public void beginFunctions(TypeDictionary typeDictionary, TypeDictionary typeDictionary2, Map<Type, Type> map) throws Exception {
        this.typedefDictionary = typeDictionary;
        if (this.getProcAddressConfig().emitProcAddressTable()) {
            this.beginProcAddressTable();
        }
        super.beginFunctions(typeDictionary, typeDictionary2, map);
    }

    @Override
    public void endFunctions() throws Exception {
        if (this.getProcAddressConfig().emitProcAddressTable()) {
            this.endProcAddressTable();
        }
        super.endFunctions();
    }

    @Override
    public void beginStructs(TypeDictionary typeDictionary, TypeDictionary typeDictionary2, Map<Type, Type> map) throws Exception {
        super.beginStructs(typeDictionary, typeDictionary2, map);
    }

    public String runtimeExceptionType() {
        return this.getConfig().runtimeExceptionType();
    }

    public String unsupportedExceptionType() {
        return this.getConfig().unsupportedExceptionType();
    }

    @Override
    protected JavaConfiguration createConfig() {
        return new ProcAddressConfiguration();
    }

    @Override
    protected List<? extends FunctionEmitter> generateMethodBindingEmitters(Set<MethodBinding> set, FunctionSymbol functionSymbol) throws Exception {
        return this.generateMethodBindingEmittersImpl(set, functionSymbol);
    }

    protected boolean needsModifiedEmitters(FunctionSymbol functionSymbol) {
        return this.needsProcAddressWrapper(functionSymbol) && !this.getConfig().isUnimplemented(this.getAliasedSymName(functionSymbol));
    }

    private List<? extends FunctionEmitter> generateMethodBindingEmittersImpl(Set<MethodBinding> set, FunctionSymbol functionSymbol) throws Exception {
        List<? extends FunctionEmitter> list = super.generateMethodBindingEmitters(set, functionSymbol);
        if (list.isEmpty()) {
            return list;
        }
        if (!this.needsModifiedEmitters(functionSymbol)) {
            return list;
        }
        ArrayList<FunctionEmitter> arrayList = new ArrayList<FunctionEmitter>(list.size());
        if (this.needsProcAddressWrapper(functionSymbol) && this.getProcAddressConfig().emitProcAddressTable()) {
            this.emitProcAddressTableEntryForString(this.getAliasedSymName(functionSymbol));
        }
        for (FunctionEmitter functionEmitter : list) {
            if (functionEmitter instanceof JavaMethodBindingEmitter) {
                this.generateModifiedEmitters((JavaMethodBindingEmitter)functionEmitter, arrayList);
                continue;
            }
            if (functionEmitter instanceof CMethodBindingEmitter) {
                this.generateModifiedEmitters((CMethodBindingEmitter)functionEmitter, arrayList);
                continue;
            }
            throw new RuntimeException("Unexpected emitter type: " + functionEmitter.getClass().getName());
        }
        return arrayList;
    }

    protected String getFunctionPointerTypedefName(FunctionSymbol functionSymbol) {
        return this.getProcAddressConfig().convertToFunctionPointerName(functionSymbol.getName());
    }

    protected void generateModifiedEmitters(JavaMethodBindingEmitter javaMethodBindingEmitter, List<FunctionEmitter> list) {
        if (this.getConfig().manuallyImplement(javaMethodBindingEmitter.getName())) {
            list.add(javaMethodBindingEmitter);
            return;
        }
        boolean bl = this.needsProcAddressWrapper(javaMethodBindingEmitter.getBinding().getCSymbol());
        ProcAddressJavaMethodBindingEmitter procAddressJavaMethodBindingEmitter = new ProcAddressJavaMethodBindingEmitter(javaMethodBindingEmitter, bl, this.getProcAddressConfig().getProcAddressTableExpr(), javaMethodBindingEmitter.isForImplementingMethodCall(), this);
        list.add(procAddressJavaMethodBindingEmitter);
        if (javaMethodBindingEmitter.signatureOnly() && !javaMethodBindingEmitter.hasModifier(JavaMethodBindingEmitter.PRIVATE) && javaMethodBindingEmitter.hasModifier(JavaMethodBindingEmitter.NATIVE) && bl) {
            procAddressJavaMethodBindingEmitter.setEmitBody(true);
            procAddressJavaMethodBindingEmitter.removeModifier(JavaMethodBindingEmitter.NATIVE);
            procAddressJavaMethodBindingEmitter = new ProcAddressJavaMethodBindingEmitter(javaMethodBindingEmitter, bl, this.getProcAddressConfig().getProcAddressTableExpr(), true, this);
            procAddressJavaMethodBindingEmitter.setForImplementingMethodCall(true);
            list.add(procAddressJavaMethodBindingEmitter);
        }
    }

    protected void generateModifiedEmitters(CMethodBindingEmitter cMethodBindingEmitter, List<FunctionEmitter> list) {
        FunctionSymbol functionSymbol = cMethodBindingEmitter.getBinding().getCSymbol();
        boolean bl = this.needsProcAddressWrapper(functionSymbol);
        boolean bl2 = this.getProcAddressConfig().forceProcAddressGen(functionSymbol.getName());
        String string = null;
        if (bl2) {
            string = this.getProcAddressConfig().getLocalProcAddressCallingConvention(functionSymbol.getName());
        }
        ProcAddressCMethodBindingEmitter procAddressCMethodBindingEmitter = new ProcAddressCMethodBindingEmitter(cMethodBindingEmitter, bl, bl2, string, this);
        MessageFormat messageFormat = cMethodBindingEmitter.getReturnValueCapacityExpression();
        if (messageFormat != null) {
            procAddressCMethodBindingEmitter.setReturnValueCapacityExpression(messageFormat);
        }
        list.add(procAddressCMethodBindingEmitter);
    }

    private String getAliasedSymName(FunctionSymbol functionSymbol) {
        String string = this.getConfig().getJavaSymbolRename(functionSymbol.getName());
        if (null == string) {
            string = functionSymbol.getName();
        }
        return string;
    }

    protected boolean needsProcAddressWrapper(FunctionSymbol functionSymbol) {
        Type type;
        String string = this.getAliasedSymName(functionSymbol);
        ProcAddressConfiguration procAddressConfiguration = this.getProcAddressConfig();
        String string2 = this.getFunctionPointerTypedefName(functionSymbol);
        boolean bl = this.typedefDictionary.containsKey(string2);
        if (procAddressConfiguration.skipProcAddressGen(string)) {
            bl = false;
        }
        if (procAddressConfiguration.forceProcAddressGen(string)) {
            bl = true;
        }
        if (bl && (type = this.typedefDictionary.get(string2)) != null) {
            FunctionType functionType = type.asPointer().getTargetType().asFunction();
            FunctionType functionType2 = functionSymbol.getType();
            int n = functionType.getNumArguments();
            for (int i = 0; i < n; ++i) {
                if (functionType2.getArgumentName(i) != null) continue;
                functionType2.setArgumentName(i, functionType.getArgumentName(i));
            }
        }
        return bl;
    }

    protected void beginProcAddressTable() throws Exception {
        this.tableClassPackage = this.getProcAddressConfig().tableClassPackage();
        this.tableClassName = this.getProcAddressConfig().tableClassName();
        String string = this.tableClassPackage;
        if (string == null) {
            string = this.getImplPackageName();
        }
        String string2 = this.getJavaOutputDir() + File.separator + CodeGenUtils.packageAsPath(string);
        this.tableWriter = this.openFile(string2 + File.separator + this.tableClassName + ".java");
        this.emittedTableEntries = new HashSet<String>();
        CodeGenUtils.emitAutogeneratedWarning(this.tableWriter, this);
        this.tableWriter.println("package " + string + ";");
        this.tableWriter.println();
        for (String string3 : this.getConfig().imports()) {
            this.tableWriter.println("import " + string3 + ";");
        }
        this.tableWriter.println("import " + ProcAddressTable.class.getName() + ";");
        this.tableWriter.println();
        this.tableWriter.println("/**");
        this.tableWriter.println(" * This table is a cache of pointers to the dynamically-linkable C library.");
        this.tableWriter.println(" * @see " + ProcAddressTable.class.getSimpleName());
        this.tableWriter.println(" */");
        this.tableWriter.println("public class " + this.tableClassName + " extends " + ProcAddressTable.class.getSimpleName() + " {");
        this.tableWriter.println();
        for (String string3 : this.getProcAddressConfig().getForceProcAddressGen()) {
            this.emitProcAddressTableEntryForString(string3);
        }
        this.tableWriter.println();
        this.tableWriter.println("  public " + this.tableClassName + "(){ super(); }");
        this.tableWriter.println();
        this.tableWriter.println("  public " + this.tableClassName + "(" + FunctionAddressResolver.class.getName() + " resolver){ super(resolver); }");
        this.tableWriter.println();
    }

    protected void endProcAddressTable() throws Exception {
        this.tableWriter.println("} // end of class " + this.tableClassName);
        this.tableWriter.flush();
        this.tableWriter.close();
    }

    protected void emitProcAddressTableEntryForString(String string) {
        if (this.emittedTableEntries.contains(string)) {
            return;
        }
        this.emittedTableEntries.add(string);
        this.tableWriter.print("  public long ");
        this.tableWriter.print(PROCADDRESS_VAR_PREFIX);
        this.tableWriter.print(string);
        this.tableWriter.println(";");
    }

    protected ProcAddressConfiguration getProcAddressConfig() {
        return (ProcAddressConfiguration)this.getConfig();
    }
}

