/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class Debug {
    private static boolean verbose;
    private static boolean debugAll;
    private static AccessControlContext localACC;
    public static final String jnlp_prefix = "jnlp.";

    static int getIntProperty(String string, boolean bl) {
        return Debug.getIntProperty(string, bl, localACC, 0);
    }

    public static int getIntProperty(String string, boolean bl, AccessControlContext accessControlContext, int n) {
        int n2 = n;
        try {
            String string2 = Debug.getProperty(string, bl, accessControlContext);
            if (null != string2) {
                Integer n3 = Integer.valueOf(string2);
                n2 = n3;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    public static long getLongProperty(String string, boolean bl, AccessControlContext accessControlContext, long l) {
        long l2 = l;
        try {
            String string2 = Debug.getProperty(string, bl, accessControlContext);
            if (null != string2) {
                Long l3 = Long.valueOf(string2);
                l2 = l3;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l2;
    }

    static boolean getBooleanProperty(String string, boolean bl) {
        return Debug.getBooleanProperty(string, bl, localACC);
    }

    public static boolean getBooleanProperty(String string, boolean bl, AccessControlContext accessControlContext) {
        Boolean bl2 = Boolean.valueOf(Debug.getProperty(string, bl, accessControlContext));
        return bl2;
    }

    static boolean isPropertyDefined(String string, boolean bl) {
        return Debug.isPropertyDefined(string, bl, localACC);
    }

    public static boolean isPropertyDefined(String string, boolean bl, AccessControlContext accessControlContext) {
        return Debug.getProperty(string, bl, accessControlContext) != null;
    }

    static String getProperty(String string, boolean bl) {
        return Debug.getProperty(string, bl, localACC);
    }

    public static String getProperty(final String string, final boolean bl, AccessControlContext accessControlContext) {
        String string2 = null;
        if (null != accessControlContext && accessControlContext.equals(localACC)) {
            string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string2 = null;
                    try {
                        string2 = System.getProperty(string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (null == string2 && bl && !string.startsWith(Debug.jnlp_prefix)) {
                        try {
                            string2 = System.getProperty(Debug.jnlp_prefix + string);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return string2;
                }
            });
        } else {
            try {
                string2 = System.getProperty(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null == string2 && bl && !string.startsWith(jnlp_prefix)) {
                try {
                    string2 = System.getProperty(jnlp_prefix + string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return string2;
    }

    public static boolean verbose() {
        return verbose;
    }

    public static boolean debugAll() {
        return debugAll;
    }

    public static boolean debug(String string) {
        return Debug.debugAll() || Debug.isPropertyDefined("jogamp.debug." + string, true);
    }

    static {
        localACC = AccessController.getContext();
        verbose = Debug.isPropertyDefined("jogamp.verbose", true);
        debugAll = Debug.isPropertyDefined("jogamp.debug", true);
    }
}

