/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.AbstractBuffer;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.NativeBuffer;
import com.jogamp.common.os.Platform;
import com.jogamp.gluegen.runtime.NativeLibLoader;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeSizeBuffer
extends AbstractBuffer<NativeSizeBuffer> {
    protected NativeSizeBuffer(ByteBuffer byteBuffer) {
        super(byteBuffer, NativeSizeBuffer.elementSize());
    }

    public static NativeSizeBuffer allocate(int n) {
        return new NativeSizeBuffer(ByteBuffer.wrap(new byte[NativeSizeBuffer.elementSize() * n]));
    }

    public static NativeSizeBuffer allocate(long[] lArray) {
        return (NativeSizeBuffer)NativeSizeBuffer.allocate(lArray.length).put(lArray, 0, lArray.length).rewind();
    }

    public static NativeSizeBuffer allocateDirect(int n) {
        return new NativeSizeBuffer(Buffers.newDirectByteBuffer(NativeSizeBuffer.elementSize() * n));
    }

    public static NativeSizeBuffer allocateDirect(long[] lArray) {
        return (NativeSizeBuffer)NativeSizeBuffer.allocateDirect(lArray.length).put(lArray, 0, lArray.length).rewind();
    }

    public static NativeSizeBuffer wrap(ByteBuffer byteBuffer) {
        return new NativeSizeBuffer(byteBuffer);
    }

    public static int elementSize() {
        return Platform.is32Bit() ? 4 : 8;
    }

    @Override
    public NativeSizeBuffer put(int n, long l) {
        this.putImpl(n, l);
        return this;
    }

    private void putImpl(long l) {
        if (Platform.is32Bit()) {
            this.bb.putInt((int)l);
        } else {
            this.bb.putLong(l);
        }
    }

    private void putImpl(int n, long l) {
        if (Platform.is32Bit()) {
            this.bb.putInt(n * NativeSizeBuffer.elementSize(), (int)l);
        } else {
            this.bb.putLong(n * NativeSizeBuffer.elementSize(), l);
        }
    }

    @Override
    public NativeSizeBuffer put(NativeBuffer nativeBuffer) {
        if (this.remaining() < nativeBuffer.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        while (nativeBuffer.hasRemaining()) {
            this.put(nativeBuffer.get());
        }
        return this;
    }

    @Override
    public NativeSizeBuffer put(long l) {
        this.putImpl(l);
        return this;
    }

    public NativeSizeBuffer put(long[] lArray, int n, int n2) {
        if (lArray.length < n + n2) {
            throw new IndexOutOfBoundsException();
        }
        if (this.remaining() < n2) {
            throw new IndexOutOfBoundsException();
        }
        while (n2 > 0) {
            this.putImpl(lArray[n++]);
            --n2;
        }
        return this;
    }

    @Override
    public long get() {
        return this.getImpl();
    }

    @Override
    public long get(int n) {
        return this.getImpl(n);
    }

    private long getImpl() {
        if (Platform.is32Bit()) {
            return this.bb.getInt();
        }
        return this.bb.getLong();
    }

    private long getImpl(int n) {
        if (Platform.is32Bit()) {
            return this.bb.getInt(n * NativeSizeBuffer.elementSize());
        }
        return this.bb.getLong(n * NativeSizeBuffer.elementSize());
    }

    public NativeSizeBuffer get(long[] lArray, int n, int n2) {
        if (lArray.length < n + n2) {
            throw new IndexOutOfBoundsException();
        }
        if (this.remaining() < n2) {
            throw new IndexOutOfBoundsException();
        }
        while (n2 > 0) {
            lArray[n++] = this.getImpl();
            --n2;
        }
        return this;
    }

    static {
        NativeLibLoader.loadGlueGenRT();
    }
}

