/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.os;

import com.jogamp.common.os.DynamicLinker;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.os.MacOSXDynamicLinkerImpl;
import com.jogamp.common.os.UnixDynamicLinkerImpl;
import com.jogamp.common.os.WindowsDynamicLinkerImpl;
import com.jogamp.gluegen.runtime.NativeLibLoader;
import java.io.File;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class NativeLibrary
implements DynamicLookupHelper {
    private static final int WINDOWS = 1;
    private static final int UNIX = 2;
    private static final int MACOSX = 3;
    protected static boolean DEBUG;
    protected static boolean DEBUG_LOOKUP;
    private static int platform;
    private static DynamicLinker dynLink;
    private static String[] prefixes;
    private static String[] suffixes;
    private long libraryHandle;
    private String libraryPath;
    private static boolean initializedFindLibraryMethod;
    private static Method findLibraryMethod;

    private NativeLibrary(long l, String string) {
        this.libraryHandle = l;
        this.libraryPath = string;
    }

    public String toString() {
        return "NativeLibrary[" + this.libraryPath + ", 0x" + Long.toHexString(this.libraryHandle) + "]";
    }

    public static NativeLibrary open(String string, ClassLoader classLoader) {
        return NativeLibrary.open(string, string, string, true, classLoader, true);
    }

    public static NativeLibrary open(String string, ClassLoader classLoader, boolean bl) {
        return NativeLibrary.open(string, string, string, true, classLoader, bl);
    }

    public static NativeLibrary open(String string, String string2, String string3, boolean bl, ClassLoader classLoader) {
        return NativeLibrary.open(string, string2, string3, bl, classLoader, true);
    }

    public static NativeLibrary open(String string, String string2, String string3, boolean bl, ClassLoader classLoader, boolean bl2) {
        List list = NativeLibrary.enumerateLibraryPaths(string, string2, string3, bl, classLoader);
        for (String string4 : list) {
            if (DEBUG) {
                System.err.println("Trying to load " + string4);
            }
            NativeLibLoader.loadGlueGenRT();
            long l = bl2 ? dynLink.openLibraryGlobal(string4, DEBUG) : dynLink.openLibraryLocal(string4, DEBUG);
            if (l == 0L) continue;
            if (DEBUG) {
                System.err.println("Successfully loaded " + string4 + ": res = 0x" + Long.toHexString(l));
            }
            return new NativeLibrary(l, string4);
        }
        if (DEBUG) {
            System.err.println("Did not succeed in loading (" + string + ", " + string2 + ", " + string3 + ")");
        }
        return null;
    }

    public long dynamicLookupFunction(String string) {
        if (this.libraryHandle == 0L) {
            throw new RuntimeException("Library is not open");
        }
        return dynLink.lookupSymbol(this.libraryHandle, string);
    }

    public static long dynamicLookupFunctionGlobal(String string) {
        return dynLink.lookupSymbolGlobal(string);
    }

    public long getLibraryHandle() {
        return this.libraryHandle;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }

    public void close() {
        if (this.libraryHandle == 0L) {
            throw new RuntimeException("Library already closed");
        }
        long l = this.libraryHandle;
        this.libraryHandle = 0L;
        dynLink.closeLibrary(l);
    }

    private static List enumerateLibraryPaths(String string, String string2, String string3, boolean bl, ClassLoader classLoader) {
        Object object;
        String string4;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string5 = NativeLibrary.selectName(string, string2, string3);
        if (string5 == null) {
            return arrayList;
        }
        File file = new File(string5);
        if (file.isAbsolute()) {
            arrayList.add(string5);
            return arrayList;
        }
        String[] stringArray = NativeLibrary.buildNames(string5);
        if (bl) {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        String string6 = NativeLibrary.getPathFromClassLoader(string5, classLoader);
        if (DEBUG) {
            System.err.println("Class loader path to " + string5 + ": " + string6);
        }
        if (string6 != null) {
            arrayList.add(string6);
        }
        if ((string4 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.library.path");
            }
        })) != null) {
            object = new StringTokenizer(string4, File.pathSeparator);
            while (((StringTokenizer)object).hasMoreTokens()) {
                NativeLibrary.addPaths(((StringTokenizer)object).nextToken(), stringArray, arrayList);
            }
        }
        object = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("user.dir");
            }
        });
        NativeLibrary.addPaths((String)object, stringArray, arrayList);
        if (platform == 3) {
            NativeLibrary.addPaths("/Library/Frameworks/" + string5 + ".Framework", stringArray, arrayList);
            NativeLibrary.addPaths("/System/Library/Frameworks/" + string5 + ".Framework", stringArray, arrayList);
        }
        if (!bl) {
            arrayList.addAll(Arrays.asList(stringArray));
        }
        return arrayList;
    }

    private static String selectName(String string, String string2, String string3) {
        switch (platform) {
            case 1: {
                return string;
            }
            case 2: {
                return string2;
            }
            case 3: {
                return string3;
            }
        }
        throw new InternalError();
    }

    private static String[] buildNames(String string) {
        int n;
        int n2;
        int n3;
        if (string.startsWith(prefixes[0])) {
            if (string.endsWith(suffixes[0])) {
                return new String[]{string};
            }
            int n4 = string.indexOf(suffixes[0]);
            n3 = 1;
            if (n4 >= 0) {
                for (n2 = n4 + suffixes[0].length(); n2 < string.length(); ++n2) {
                    n = string.charAt(n2);
                    if (n == 46 || n >= 48 && n <= 57) continue;
                    n3 = 0;
                    break;
                }
                if (n3 != 0) {
                    return new String[]{string};
                }
            }
        }
        String[] stringArray = new String[prefixes.length * suffixes.length];
        n3 = 0;
        for (n2 = 0; n2 < prefixes.length; ++n2) {
            for (n = 0; n < suffixes.length; ++n) {
                stringArray[n3++] = prefixes[n2] + string + suffixes[n];
            }
        }
        return stringArray;
    }

    private static void addPaths(String string, String[] stringArray, List list) {
        for (int i = 0; i < stringArray.length; ++i) {
            list.add(string + File.separator + stringArray[i]);
        }
    }

    private static String getPathFromClassLoader(final String string, final ClassLoader classLoader) {
        block5: {
            if (classLoader == null) {
                return null;
            }
            if (!initializedFindLibraryMethod) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            findLibraryMethod = ClassLoader.class.getDeclaredMethod("findLibrary", String.class);
                            findLibraryMethod.setAccessible(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        initializedFindLibraryMethod = true;
                        return null;
                    }
                });
            }
            if (findLibraryMethod != null) {
                try {
                    return (String)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            try {
                                return findLibraryMethod.invoke((Object)classLoader, string);
                            }
                            catch (Exception exception) {
                                throw new RuntimeException(exception);
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    if (!DEBUG) break block5;
                    exception.printStackTrace();
                }
            }
        }
        return null;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("os.name").toLowerCase();
                if (string.startsWith("wind")) {
                    platform = 1;
                } else if (string.startsWith("mac os x")) {
                    platform = 3;
                } else {
                    platform = 2;
                }
                DEBUG = System.getProperty("jogamp.debug.NativeLibrary") != null;
                DEBUG_LOOKUP = System.getProperty("jogamp.debug.NativeLibrary.Lookup") != null;
                return null;
            }
        });
        switch (platform) {
            case 1: {
                dynLink = new WindowsDynamicLinkerImpl();
                prefixes = new String[]{""};
                suffixes = new String[]{".dll"};
                break;
            }
            case 2: {
                dynLink = new UnixDynamicLinkerImpl();
                prefixes = new String[]{"lib"};
                suffixes = new String[]{".so"};
                break;
            }
            case 3: {
                dynLink = new MacOSXDynamicLinkerImpl();
                prefixes = new String[]{"lib", ""};
                suffixes = new String[]{".dylib", ".jnilib", ""};
                break;
            }
            default: {
                throw new InternalError("Platform not initialized properly");
            }
        }
        initializedFindLibraryMethod = false;
        findLibraryMethod = null;
    }
}

