/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongLongHashMap
implements Cloneable,
Iterable {
    private final float loadFactor;
    private Entry[] table;
    private int size;
    private int mask;
    private int capacity;
    private int threshold;
    private long keyNotFoundValue = -1L;
    private static final boolean isPrimitive;
    private static final Constructor entryConstructor;
    private static final Method equalsMethod;

    public LongLongHashMap() {
        this(16, 0.75f);
    }

    public LongLongHashMap(int n) {
        this(n, 0.75f);
    }

    public LongLongHashMap(int n, float f) {
        if (n > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be greater than zero.");
        }
        this.capacity = 1;
        while (this.capacity < n) {
            this.capacity <<= 1;
        }
        this.loadFactor = f;
        this.threshold = (int)((float)this.capacity * f);
        this.table = new Entry[this.capacity];
        this.mask = this.capacity - 1;
    }

    private LongLongHashMap(float f, int n, int n2, int n3, int n4, int n5, long l) {
        this.loadFactor = f;
        this.table = new Entry[n];
        this.size = n2;
        this.mask = n3;
        this.capacity = n4;
        this.threshold = n5;
        this.keyNotFoundValue = l;
    }

    public Object clone() {
        LongLongHashMap longLongHashMap = new LongLongHashMap(this.loadFactor, this.table.length, this.size, this.mask, this.capacity, this.threshold, this.keyNotFoundValue);
        for (int i = this.table.length - 1; i >= 0; --i) {
            ArrayList<Entry> arrayList = new ArrayList<Entry>();
            Entry entry = this.table[i];
            while (null != entry) {
                arrayList.add(entry);
                entry = entry.next;
            }
            Entry entry2 = null;
            for (int j = arrayList.size() - 1; j >= 0; --j) {
                entry = (Entry)arrayList.get(j);
                if (isPrimitive) {
                    entry2 = new Entry(entry.key, entry.value, entry2);
                    continue;
                }
                Object object = ReflectionUtil.callMethod(entry.value, LongLongHashMap.getCloneMethod(entry.value), new Object[0]);
                entry2 = (Entry)ReflectionUtil.createInstance(entryConstructor, entry.key, object, entry2);
            }
            longLongHashMap.table[i] = entry2;
        }
        return longLongHashMap;
    }

    public boolean containsValue(long l) {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (n-- > 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                Boolean bl;
                if (isPrimitive ? entry.value == l : (bl = (Boolean)ReflectionUtil.callMethod(l, equalsMethod, entry.value)) != false) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsKey(long l) {
        Entry[] entryArray = this.table;
        int n = (int)(l & (long)this.mask);
        Entry entry = entryArray[n];
        while (entry != null) {
            if (entry.key == l) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public long get(long l) {
        Entry[] entryArray = this.table;
        int n = (int)(l & (long)this.mask);
        Entry entry = entryArray[n];
        while (entry != null) {
            if (entry.key == l) {
                return entry.value;
            }
            entry = entry.next;
        }
        return this.keyNotFoundValue;
    }

    public long put(long l, long l2) {
        Entry[] entryArray = this.table;
        int n = (int)(l & (long)this.mask);
        Entry entry = entryArray[n];
        while (entry != null) {
            if (entry.key == l) {
                long l3 = entry.value;
                entry.value = l2;
                return l3;
            }
            entry = entry.next;
        }
        entryArray[n] = new Entry(l, l2, entryArray[n]);
        if (this.size++ >= this.threshold) {
            int n2 = 2 * this.capacity;
            Entry[] entryArray2 = new Entry[n2];
            long l4 = n2 - 1;
            for (int i = 0; i < entryArray.length; ++i) {
                Entry entry2;
                Entry entry3 = entryArray[i];
                if (entry3 == null) continue;
                entryArray[i] = null;
                do {
                    entry2 = entry3.next;
                    n = (int)(entry3.key & l4);
                    entry3.next = entryArray2[n];
                    entryArray2[n] = entry3;
                } while ((entry3 = entry2) != null);
            }
            this.table = entryArray2;
            this.capacity = n2;
            this.threshold = (int)((float)n2 * this.loadFactor);
            this.mask = this.capacity - 1;
        }
        return this.keyNotFoundValue;
    }

    public void putAll(LongLongHashMap longLongHashMap) {
        for (Entry entry : longLongHashMap) {
            this.put(entry.key, entry.value);
        }
    }

    public long remove(long l) {
        Entry entry;
        Entry[] entryArray = this.table;
        int n = (int)(l & (long)this.mask);
        Entry entry2 = entry = entryArray[n];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (entry2.key == l) {
                --this.size;
                if (entry == entry2) {
                    entryArray[n] = entry3;
                } else {
                    entry.next = entry3;
                }
                return entry2.value;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return this.keyNotFoundValue;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public void clear() {
        Arrays.fill(this.table, null);
        this.size = 0;
    }

    public Iterator<Entry> iterator() {
        return new EntryIterator(this.table);
    }

    public long setKeyNotFoundValue(long l) {
        long l2 = this.keyNotFoundValue;
        this.keyNotFoundValue = l;
        return l2;
    }

    public long getKeyNotFoundValue() {
        return this.keyNotFoundValue;
    }

    public String toString() {
        String string = "{";
        Iterator<Entry> iterator = this.iterator();
        while (iterator.hasNext()) {
            string = string + iterator.next();
            if (!iterator.hasNext()) continue;
            string = string + ", ";
        }
        string = string + "}";
        return string;
    }

    private static Method getCloneMethod(Object object) {
        Class<?> clazz = object.getClass();
        Method method = null;
        try {
            method = clazz.getDeclaredMethod("clone", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new JogampRuntimeException("Class " + clazz + " doesn't support clone()", noSuchMethodException);
        }
        return method;
    }

    static {
        Class<Long> clazz = Long.TYPE;
        Class<Long> clazz2 = Long.TYPE;
        isPrimitive = clazz.isPrimitive();
        Constructor constructor = null;
        Method method = null;
        if (!isPrimitive) {
            constructor = ReflectionUtil.getConstructor(Entry.class, clazz2, clazz, Entry.class);
            try {
                method = clazz.getDeclaredMethod("equals", Object.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new JogampRuntimeException("Class " + clazz + " doesn't support equals(Object)");
            }
        }
        entryConstructor = constructor;
        equalsMethod = method;
    }

    public static final class Entry {
        public final long key;
        public long value;
        private Entry next;

        Entry(long l, long l2, Entry entry) {
            this.key = l;
            this.value = l2;
            this.next = entry;
        }

        public long getKey() {
            return this.key;
        }

        public long getValue() {
            return this.value;
        }

        public void setValue(long l) {
            this.value = l;
        }

        public String toString() {
            return "[" + this.key + ":" + this.value + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EntryIterator
    implements Iterator<Entry> {
        private final Entry[] entries;
        private int index;
        private Entry next;

        private EntryIterator(Entry[] entryArray) {
            this.entries = entryArray;
            this.next();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Entry next() {
            Entry entry = this.next;
            if (entry != null && entry.next != null) {
                this.next = entry.next;
            } else {
                while (this.index < this.entries.length) {
                    Entry entry2;
                    if ((entry2 = this.entries[this.index++]) == null) continue;
                    this.next = entry2;
                    return entry;
                }
                this.next = null;
            }
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

