/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import com.jogamp.common.GlueGenVersion;
import com.jogamp.gluegen.ConstantDefinition;
import com.jogamp.gluegen.GlueEmitter;
import com.jogamp.gluegen.GlueEmitterControls;
import com.jogamp.gluegen.JavaEmitter;
import com.jogamp.gluegen.Logging;
import com.jogamp.gluegen.ReferencedStructs;
import com.jogamp.gluegen.SymbolFilter;
import com.jogamp.gluegen.cgram.CToken;
import com.jogamp.gluegen.cgram.Define;
import com.jogamp.gluegen.cgram.GNUCTokenTypes;
import com.jogamp.gluegen.cgram.GnuCLexer;
import com.jogamp.gluegen.cgram.GnuCParser;
import com.jogamp.gluegen.cgram.HeaderParser;
import com.jogamp.gluegen.cgram.TNode;
import com.jogamp.gluegen.cgram.types.CompoundType;
import com.jogamp.gluegen.cgram.types.EnumType;
import com.jogamp.gluegen.cgram.types.FunctionSymbol;
import com.jogamp.gluegen.cgram.types.MachineDescription;
import com.jogamp.gluegen.cgram.types.MachineDescription32Bit;
import com.jogamp.gluegen.cgram.types.MachineDescription64Bit;
import com.jogamp.gluegen.cgram.types.PointerType;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.cgram.types.TypeDictionary;
import com.jogamp.gluegen.cgram.types.TypeVisitor;
import com.jogamp.gluegen.pcpp.PCPP;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class GlueGen
implements GlueEmitterControls {
    private List<String> forcedStructNames = new ArrayList<String>();
    private PCPP preprocessor;
    private List<ConstantDefinition> constants;
    private List<FunctionSymbol> functions;

    @Override
    public void forceStructEmission(String string) {
        this.forcedStructNames.add(string);
    }

    @Override
    public String findHeaderFile(String string) {
        return this.preprocessor.findFile(string);
    }

    @Override
    public void runSymbolFilter(SymbolFilter symbolFilter) {
        symbolFilter.filterSymbols(this.constants, this.functions);
        List<ConstantDefinition> list = symbolFilter.getConstants();
        List<FunctionSymbol> list2 = symbolFilter.getFunctions();
        if (list != null) {
            this.constants = list;
        }
        if (list2 != null) {
            this.functions = list2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void run(Reader reader, String string, Class<?> clazz, List<String> list, List<String> list2, String string2, boolean bl, boolean bl2) {
        try {
            Object object;
            Object object422;
            Object object5;
            PipedInputStream pipedInputStream = new PipedInputStream();
            PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
            File file = File.createTempFile("PCPPTemp", ".pcpp");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            if (bl) {
                System.err.println("PCPP output at (persistent): " + file.getAbsolutePath());
            } else {
                file.deleteOnExit();
            }
            this.preprocessor = new PCPP(list, bl, bl2);
            this.preprocessor.addDefine("__GLUEGEN__", "2");
            this.preprocessor.setOut(fileOutputStream);
            this.preprocessor.run(reader, string);
            fileOutputStream.flush();
            fileOutputStream.close();
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            GnuCLexer gnuCLexer = new GnuCLexer(dataInputStream);
            gnuCLexer.setTokenObjectClass(CToken.class.getName());
            gnuCLexer.initialize();
            GnuCParser gnuCParser = new GnuCParser(gnuCLexer);
            gnuCParser.setASTNodeClass(TNode.class.getName());
            TNode.setTokenVocabulary(GNUCTokenTypes.class.getName());
            try {
                gnuCParser.translationUnit();
            }
            catch (RecognitionException recognitionException) {
                throw new RuntimeException("Fatal IO error", recognitionException);
            }
            catch (TokenStreamException tokenStreamException) {
                throw new RuntimeException("Fatal IO error", tokenStreamException);
            }
            HeaderParser headerParser = new HeaderParser();
            headerParser.setDebug(bl);
            TypeDictionary typeDictionary = new TypeDictionary();
            headerParser.setTypedefDictionary(typeDictionary);
            TypeDictionary typeDictionary2 = new TypeDictionary();
            headerParser.setStructDictionary(typeDictionary2);
            headerParser.setASTNodeClass(TNode.class.getName());
            headerParser.translationUnit(gnuCParser.getAST());
            dataInputStream.close();
            fileInputStream.close();
            GlueEmitter glueEmitter = null;
            if (clazz == null) {
                glueEmitter = new JavaEmitter();
            } else {
                try {
                    glueEmitter = (GlueEmitter)clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new RuntimeException("Exception occurred while instantiating emitter class.", exception);
                }
            }
            Object object6 = list2.iterator();
            while (object6.hasNext()) {
                object5 = object6.next();
                glueEmitter.readConfigurationFile((String)object5);
            }
            if (null != string2 && string2.trim().length() > 0 && glueEmitter instanceof JavaEmitter && null != ((JavaEmitter)(object6 = (JavaEmitter)glueEmitter)).getConfig()) {
                ((JavaEmitter)object6).getConfig().setOutputRootDir(string2);
            }
            object6 = new MachineDescription32Bit();
            object5 = new MachineDescription64Bit();
            glueEmitter.setMachineDescription((MachineDescription)object6, (MachineDescription)object5);
            this.constants = new ArrayList<ConstantDefinition>();
            for (Object object422 : headerParser.getEnums()) {
                EnumType object32 = (EnumType)object422;
                String string3 = object32.getName();
                if (string3.equals("<anonymous>")) {
                    Object var26_40 = null;
                }
                for (int i = 0; i < object32.getNumEnumerates(); ++i) {
                    void var26_38;
                    object = object32.getEnumName(i);
                    String string4 = String.valueOf(object32.getEnumValue(i));
                    this.constants.add(new ConstantDefinition((String)object, string4, true, (String)var26_38));
                }
            }
            for (Object object422 : gnuCLexer.getDefines()) {
                Define define = (Define)object422;
                this.constants.add(new ConstantDefinition(define.getName(), define.getValue(), false, null));
            }
            this.functions = headerParser.getParsedFunctions();
            glueEmitter.beginEmission(this);
            glueEmitter.beginDefines();
            HashSet hashSet = new HashSet(100);
            for (ConstantDefinition constantDefinition : this.constants) {
                void var26_50;
                if (hashSet.contains(constantDefinition.getName())) continue;
                hashSet.add(constantDefinition.getName());
                Object var26_42 = null;
                Set<String> set = constantDefinition.getAliases();
                if (set != null) {
                    void var26_44;
                    String string5 = "Alias for: <code>";
                    for (String string4 : set) {
                        String string6 = (String)var26_44 + " " + string4;
                    }
                    String string7 = (String)var26_44 + "</code>";
                }
                if (constantDefinition.getEnumName() != null) {
                    void var26_47;
                    object = "Defined as part of enum type \"" + constantDefinition.getEnumName() + "\"";
                    if (var26_47 == null) {
                        Object object2 = object;
                    } else {
                        String string8 = (String)var26_47 + "<br>\n" + (String)object;
                    }
                }
                glueEmitter.emitDefine(constantDefinition, (String)var26_50);
            }
            glueEmitter.endDefines();
            object422 = new ReferencedStructs();
            for (FunctionSymbol functionSymbol : this.functions) {
                functionSymbol.getType().visit((TypeVisitor)object422);
            }
            for (String string9 : this.forcedStructNames) {
                Type type = typeDictionary.get(string9);
                if (type == null) {
                    System.err.println("WARNING: during forced struct emission: struct \"" + string9 + "\" not found");
                    continue;
                }
                if (!type.isCompound()) {
                    System.err.println("WARNING: during forced struct emission: type \"" + string9 + "\" was not a struct");
                    continue;
                }
                type.visit((TypeVisitor)object422);
            }
            glueEmitter.beginStructLayout();
            Iterator<Type> iterator = ((ReferencedStructs)object422).results();
            while (iterator.hasNext()) {
                Type type = iterator.next();
                if (type.isCompound()) {
                    glueEmitter.layoutStruct(type.asCompound());
                    continue;
                }
                if (!type.isPointer()) continue;
                PointerType pointerType = type.asPointer();
                object = pointerType.getTargetType().asCompound();
                glueEmitter.layoutStruct((CompoundType)object);
            }
            glueEmitter.endStructLayout();
            glueEmitter.beginStructs(typeDictionary, typeDictionary2, headerParser.getCanonMap());
            Iterator<Type> iterator2 = ((ReferencedStructs)object422).results();
            while (iterator2.hasNext()) {
                Type type = iterator2.next();
                if (type.isCompound()) {
                    glueEmitter.emitStruct(type.asCompound(), null);
                    continue;
                }
                if (!type.isPointer()) continue;
                PointerType pointerType = type.asPointer();
                object = pointerType.getTargetType().asCompound();
                assert (pointerType.hasTypedefedName() && ((Type)object).getName() == null) : "ReferencedStructs incorrectly recorded pointer type " + pointerType;
                glueEmitter.emitStruct((CompoundType)object, pointerType.getName());
            }
            glueEmitter.endStructs();
            glueEmitter.beginFunctions(typeDictionary, typeDictionary2, headerParser.getCanonMap());
            glueEmitter.emitFunctions(this.functions);
            glueEmitter.endFunctions();
            glueEmitter.endEmission();
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception occurred while generating glue code.", exception);
        }
    }

    public static void main(String ... stringArray) {
        if (stringArray.length == 0) {
            System.err.println(GlueGenVersion.getInstance());
            GlueGen.usage();
        }
        Reader reader = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string4;
            if (i < stringArray.length - 1) {
                string4 = stringArray[i];
                if (string4.startsWith("-I")) {
                    String[] stringArray2 = string4.substring(2).split(System.getProperty("path.separator"));
                    arrayList2.addAll(Arrays.asList(stringArray2));
                    continue;
                }
                if (string4.startsWith("-O")) {
                    string3 = string4.substring(2);
                    continue;
                }
                if (string4.startsWith("-E")) {
                    string2 = string4.substring(2);
                    continue;
                }
                if (string4.startsWith("-C")) {
                    arrayList.add(string4.substring(2));
                    continue;
                }
                if (string4.equals("--debug")) {
                    bl = true;
                    continue;
                }
                if (string4.equals("--dumpCPP")) {
                    bl2 = true;
                    continue;
                }
                GlueGen.usage();
                continue;
            }
            string4 = stringArray[i];
            if (string4.equals("-")) {
                reader = new InputStreamReader(System.in);
                string = "standard input";
                continue;
            }
            if (string4.startsWith("-")) {
                GlueGen.usage();
            }
            string = string4;
            try {
                reader = new BufferedReader(new FileReader(string));
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RuntimeException("input file not found", fileNotFoundException);
            }
        }
        try {
            Class<?> clazz = string2 == null ? null : Class.forName(string2);
            new GlueGen().run(reader, string, clazz, arrayList2, arrayList, string3, bl, bl2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("specified emitter class was not in the classpath", classNotFoundException);
        }
    }

    private static void usage() {
        System.out.println("Usage: java GlueGen [-I...] [-Eemitter_class_name] [-Ccfg_file_name...] <filename | ->");
        System.out.println();
        System.out.println("Runs C header parser on input file or standard input, first");
        System.out.println("passing input through minimal pseudo-C-preprocessor. Use -I");
        System.out.println("command-line arguments to specify the search path for #includes.");
        System.out.println("Emitter class name can be specified with -E option: i.e.,");
        System.out.println("-Ecom.jogamp.gluegen.JavaEmitter (the default). Use");
        System.out.println("-Ecom.jogamp.gluegen.DebugEmitter to print recognized entities");
        System.out.println("(#define directives to constant numbers, typedefs, and function");
        System.out.println("declarations) to standard output. Emitter-specific configuration");
        System.out.println("file or files can be specified with -C option; e.g,");
        System.out.println("-Cjava-emitter.cfg.");
        System.out.println("  --debug enables debug mode");
        System.out.println("  --dumpCPP directs PCPP to dump all output to stderr as well");
        System.exit(1);
    }

    static {
        Logging.init();
    }
}

