/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import com.jogamp.gluegen.CommentEmitter;
import com.jogamp.gluegen.FunctionEmitter;
import com.jogamp.gluegen.JavaConfiguration;
import com.jogamp.gluegen.JavaType;
import com.jogamp.gluegen.MethodBinding;
import com.jogamp.gluegen.cgram.types.ArrayType;
import com.jogamp.gluegen.cgram.types.CompoundType;
import com.jogamp.gluegen.cgram.types.EnumType;
import com.jogamp.gluegen.cgram.types.PointerType;
import com.jogamp.gluegen.cgram.types.Type;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.List;

public class JavaMethodBindingEmitter
extends FunctionEmitter {
    public static final FunctionEmitter.EmissionModifier PUBLIC = new FunctionEmitter.EmissionModifier("public");
    public static final FunctionEmitter.EmissionModifier PROTECTED = new FunctionEmitter.EmissionModifier("protected");
    public static final FunctionEmitter.EmissionModifier PRIVATE = new FunctionEmitter.EmissionModifier("private");
    public static final FunctionEmitter.EmissionModifier ABSTRACT = new FunctionEmitter.EmissionModifier("abstract");
    public static final FunctionEmitter.EmissionModifier FINAL = new FunctionEmitter.EmissionModifier("final");
    public static final FunctionEmitter.EmissionModifier NATIVE = new FunctionEmitter.EmissionModifier("native");
    public static final FunctionEmitter.EmissionModifier SYNCHRONIZED = new FunctionEmitter.EmissionModifier("synchronized");
    protected final CommentEmitter defaultJavaCommentEmitter = new DefaultCommentEmitter();
    protected final CommentEmitter defaultInterfaceCommentEmitter = new InterfaceCommentEmitter();
    private String runtimeExceptionType;
    private String unsupportedExceptionType;
    protected boolean emitBody;
    protected boolean eraseBufferAndArrayTypes;
    protected boolean directNIOOnly;
    protected boolean forImplementingMethodCall;
    protected boolean forDirectBufferImplementation;
    protected boolean forIndirectBufferAndArrayImplementation;
    protected boolean isUnimplemented;
    protected boolean tagNativeBinding;
    protected MethodBinding binding;
    protected List<String> prologue;
    protected List<String> epilogue;
    private String returnedArrayLengthExpression;
    private static final String COMPOUND_ARRAY_SUFFIX = "_buf_array_copy";
    private JavaConfiguration cfg;

    public JavaMethodBindingEmitter(MethodBinding methodBinding, PrintWriter printWriter, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, JavaConfiguration javaConfiguration) {
        super(printWriter, bl9);
        this.binding = methodBinding;
        this.runtimeExceptionType = string;
        this.unsupportedExceptionType = string2;
        this.emitBody = bl;
        this.tagNativeBinding = bl2;
        this.eraseBufferAndArrayTypes = bl3;
        this.directNIOOnly = bl4;
        this.forImplementingMethodCall = bl5;
        this.forDirectBufferImplementation = bl6;
        this.forIndirectBufferAndArrayImplementation = bl7;
        this.isUnimplemented = bl8;
        if (bl5) {
            this.setCommentEmitter(this.defaultJavaCommentEmitter);
        } else {
            this.setCommentEmitter(this.defaultInterfaceCommentEmitter);
        }
        this.cfg = javaConfiguration;
    }

    public JavaMethodBindingEmitter(JavaMethodBindingEmitter javaMethodBindingEmitter) {
        super(javaMethodBindingEmitter);
        this.binding = javaMethodBindingEmitter.binding;
        this.runtimeExceptionType = javaMethodBindingEmitter.runtimeExceptionType;
        this.unsupportedExceptionType = javaMethodBindingEmitter.unsupportedExceptionType;
        this.emitBody = javaMethodBindingEmitter.emitBody;
        this.tagNativeBinding = javaMethodBindingEmitter.tagNativeBinding;
        this.eraseBufferAndArrayTypes = javaMethodBindingEmitter.eraseBufferAndArrayTypes;
        this.directNIOOnly = javaMethodBindingEmitter.directNIOOnly;
        this.forImplementingMethodCall = javaMethodBindingEmitter.forImplementingMethodCall;
        this.forDirectBufferImplementation = javaMethodBindingEmitter.forDirectBufferImplementation;
        this.forIndirectBufferAndArrayImplementation = javaMethodBindingEmitter.forIndirectBufferAndArrayImplementation;
        this.isUnimplemented = javaMethodBindingEmitter.isUnimplemented;
        this.prologue = javaMethodBindingEmitter.prologue;
        this.epilogue = javaMethodBindingEmitter.epilogue;
        this.returnedArrayLengthExpression = javaMethodBindingEmitter.returnedArrayLengthExpression;
        this.cfg = javaMethodBindingEmitter.cfg;
    }

    public final MethodBinding getBinding() {
        return this.binding;
    }

    public boolean isForImplementingMethodCall() {
        return this.forImplementingMethodCall;
    }

    public boolean isForDirectBufferImplementation() {
        return this.forDirectBufferImplementation;
    }

    public boolean isForIndirectBufferAndArrayImplementation() {
        return this.forIndirectBufferAndArrayImplementation;
    }

    @Override
    public String getName() {
        return this.binding.getName();
    }

    protected String getArgumentName(int n) {
        return this.binding.getArgumentName(n);
    }

    public String getRuntimeExceptionType() {
        return this.runtimeExceptionType;
    }

    public String getUnsupportedExceptionType() {
        return this.unsupportedExceptionType;
    }

    public void setReturnedArrayLengthExpression(String string) {
        this.returnedArrayLengthExpression = string;
    }

    public void setPrologue(List<String> list) {
        this.prologue = list;
    }

    public void setEpilogue(List<String> list) {
        this.epilogue = list;
    }

    public boolean signatureOnly() {
        return !this.emitBody;
    }

    public void setEmitBody(boolean bl) {
        this.emitBody = bl;
    }

    public void setEraseBufferAndArrayTypes(boolean bl) {
        this.eraseBufferAndArrayTypes = bl;
    }

    public void setForImplementingMethodCall(boolean bl) {
        this.forImplementingMethodCall = bl;
    }

    public void setForDirectBufferImplementation(boolean bl) {
        this.forDirectBufferImplementation = bl;
    }

    public void setForIndirectBufferAndArrayImplementation(boolean bl) {
        this.forIndirectBufferAndArrayImplementation = bl;
    }

    @Override
    protected void emitReturnType(PrintWriter printWriter) {
        printWriter.print(this.getReturnTypeString(false));
    }

    protected String erasedTypeString(JavaType javaType, boolean bl) {
        if (this.eraseBufferAndArrayTypes) {
            if (javaType.isNIOBuffer()) {
                if (!bl) {
                    return "Object";
                }
                if (!javaType.isNIOByteBuffer()) {
                    return "ByteBuffer";
                }
            } else if (javaType.isPrimitiveArray()) {
                if (!bl) {
                    return "Object";
                }
            } else {
                if (javaType.isNIOBufferArray()) {
                    return "Object[]";
                }
                if (javaType.isCompoundTypeWrapper()) {
                    return "ByteBuffer";
                }
                if (javaType.isArrayOfCompoundTypeWrappers()) {
                    if (bl) {
                        return "ByteBuffer";
                    }
                    return "ByteBuffer[]";
                }
            }
        }
        String string = javaType.getName();
        int n = string.lastIndexOf(46) + 1;
        string = string.substring(n);
        if (javaType.isArrayOfCompoundTypeWrappers()) {
            return string + "[]";
        }
        return string;
    }

    protected String getReturnTypeString(boolean bl) {
        if (bl || this.getReturnedArrayLengthExpression() == null && !this.binding.getJavaReturnType().isArrayOfCompoundTypeWrappers() || this.eraseBufferAndArrayTypes && this.binding.getJavaReturnType().isCompoundTypeWrapper() && this.getReturnedArrayLengthExpression() != null) {
            return this.erasedTypeString(this.binding.getJavaReturnType(), true);
        }
        return this.erasedTypeString(this.binding.getJavaReturnType(), true) + "[]";
    }

    @Override
    protected void emitName(PrintWriter printWriter) {
        if (this.forImplementingMethodCall) {
            printWriter.print(this.getImplMethodName());
        } else {
            printWriter.print(this.getName());
        }
    }

    @Override
    protected int emitArguments(PrintWriter printWriter) {
        boolean bl = false;
        int n = 0;
        if (this.forImplementingMethodCall && this.binding.hasContainingType()) {
            printWriter.print("ByteBuffer ");
            printWriter.print(JavaMethodBindingEmitter.javaThisArgumentName());
            ++n;
            bl = true;
        }
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            JavaType javaType = this.binding.getJavaArgumentType(i);
            if (javaType.isVoid()) {
                if (this.binding.getNumArguments() == 1) continue;
                throw new InternalError("\"void\" argument type found in multi-argument function \"" + this.binding + "\"");
            }
            if (javaType.isJNIEnv() || this.binding.isArgumentThisPointer(i)) continue;
            if (bl) {
                printWriter.print(", ");
            }
            printWriter.print(this.erasedTypeString(javaType, false));
            printWriter.print(" ");
            printWriter.print(this.getArgumentName(i));
            ++n;
            bl = true;
            if (this.forDirectBufferImplementation || this.forIndirectBufferAndArrayImplementation) {
                if (javaType.isNIOBuffer()) {
                    printWriter.print(", int " + this.byteOffsetArgName(i));
                    if (!this.directNIOOnly) {
                        printWriter.print(", boolean " + this.isNIOArgName(i));
                    }
                } else if (javaType.isNIOBufferArray()) {
                    printWriter.print(", int[] " + this.byteOffsetArrayArgName(i));
                }
            }
            if (!javaType.isPrimitiveArray()) continue;
            if (this.directNIOOnly) {
                throw new RuntimeException("NIODirectOnly " + this.binding + " is set, but " + this.getArgumentName(i) + " is a primitive array");
            }
            printWriter.print(", int " + this.offsetArgName(i));
        }
        return n;
    }

    protected String getImplMethodName() {
        return this.binding.getName() + (this.directNIOOnly ? "0" : "1");
    }

    protected String byteOffsetArgName(int n) {
        return this.byteOffsetArgName(this.getArgumentName(n));
    }

    protected String byteOffsetArgName(String string) {
        return string + "_byte_offset";
    }

    protected String isNIOArgName(int n) {
        return this.isNIOArgName(this.binding.getArgumentName(n));
    }

    protected String isNIOArgName(String string) {
        return string + "_is_direct";
    }

    protected String byteOffsetArrayArgName(int n) {
        return this.getArgumentName(n) + "_byte_offset_array";
    }

    protected String offsetArgName(int n) {
        return this.getArgumentName(n) + "_offset";
    }

    @Override
    protected void emitBody(PrintWriter printWriter) {
        if (!this.emitBody) {
            printWriter.println(';');
        } else {
            MethodBinding methodBinding = this.getBinding();
            printWriter.println("  {");
            printWriter.println();
            if (this.isUnimplemented) {
                printWriter.println("    throw new " + this.getUnsupportedExceptionType() + "(\"Unimplemented\");");
            } else {
                this.emitPrologueOrEpilogue(this.prologue, printWriter);
                this.emitPreCallSetup(methodBinding, printWriter);
                this.emitReturnVariableSetupAndCall(methodBinding, printWriter);
            }
            printWriter.println("  }");
        }
    }

    protected void emitPrologueOrEpilogue(List<String> list, PrintWriter printWriter) {
        if (list != null) {
            String[] stringArray = this.argumentNameArray();
            for (String string : list) {
                try {
                    MessageFormat messageFormat = new MessageFormat(string);
                    printWriter.println("    " + messageFormat.format(stringArray));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    printWriter.println("    " + string);
                }
            }
        }
    }

    protected void emitPreCallSetup(MethodBinding methodBinding, PrintWriter printWriter) {
        this.emitArrayLengthAndNIOBufferChecks(methodBinding, printWriter);
        this.emitCompoundArrayCopies(methodBinding, printWriter);
    }

    protected void emitArrayLengthAndNIOBufferChecks(MethodBinding methodBinding, PrintWriter printWriter) {
        for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
            String string;
            Object object;
            Type type = methodBinding.getCArgumentType(i);
            String string2 = this.getArgumentName(i);
            if (type.isArray()) {
                object = type.asArray();
                printWriter.println("    if (" + string2 + ".length < " + ((ArrayType)object).getLength() + ")");
                printWriter.println("      throw new " + this.getRuntimeExceptionType() + "(\"Length of array \\\"" + string2 + "\\\" was less than the required " + ((ArrayType)object).getLength() + "\");");
                throw new RuntimeException("????? " + methodBinding + ": binding.getCArgumentType(" + i + ").isArray(): " + type);
            }
            object = methodBinding.getJavaArgumentType(i);
            if (((JavaType)object).isNIOBuffer()) {
                if (this.directNIOOnly) {
                    printWriter.println("    Buffer _" + string2 + ";");
                    printWriter.println("    int _" + string2 + "_offset;");
                    printWriter.println("    if (" + string2 + " == null) {");
                    printWriter.println("        _" + string2 + "        = null;");
                    printWriter.println("        _" + string2 + "_offset = 0;");
                    printWriter.println("    } else if (" + string2 + ".isDirect()) {");
                    if (((JavaType)object).isNIONativeSizeBuffer()) {
                        printWriter.println("        _" + string2 + "        =  " + string2 + ".getBuffer();");
                        printWriter.println("        _" + string2 + "_offset = _" + string2 + ".position();");
                    } else {
                        printWriter.println("        _" + string2 + "        = " + string2 + ";");
                        printWriter.println("        _" + string2 + "_offset = Buffers.getDirectBufferByteOffset(_" + string2 + ");");
                    }
                    printWriter.println("    } else {");
                    printWriter.println("        throw new " + this.getRuntimeExceptionType() + "(\"Argument \\\"" + string2 + "\\\" was not a direct buffer\");");
                    printWriter.println("    }");
                    printWriter.println();
                    continue;
                }
                printWriter.println("    boolean " + this.isNIOArgName(i) + " = " + string2 + " != null && Buffers.isDirect(" + string2 + ");");
                continue;
            }
            if (((JavaType)object).isNIOBufferArray()) {
                string = this.byteOffsetArrayArgName(i);
                printWriter.println("    int[] " + string + " = new int[" + string2 + ".length];");
                printWriter.println("    if (" + string2 + " != null) {");
                printWriter.println("      for (int _ctr = 0; _ctr < " + string2 + ".length; _ctr++) {");
                printWriter.println("        if (!Buffers.isDirect(" + string2 + "[_ctr])) {");
                printWriter.println("          throw new " + this.getRuntimeExceptionType() + "(\"Element \" + _ctr + \" of argument \\\"" + string2 + "\\\" was not a direct buffer\");");
                printWriter.println("        }");
                printWriter.println("        " + string + "[_ctr] = Buffers.getDirectBufferByteOffset(" + string2 + "[_ctr]);");
                printWriter.println("      }");
                printWriter.println("    }");
                continue;
            }
            if (!((JavaType)object).isPrimitiveArray()) continue;
            string = this.offsetArgName(i);
            printWriter.println("    if(" + string2 + " != null && " + string2 + ".length <= " + string + ")");
            printWriter.print("      throw new " + this.getRuntimeExceptionType());
            printWriter.println("(\"array offset argument \\\"" + string + "\\\" (\" + " + string + " + \") equals or exceeds array length (\" + " + string2 + ".length + \")\");");
        }
    }

    protected void emitCompoundArrayCopies(MethodBinding methodBinding, PrintWriter printWriter) {
        if (methodBinding.signatureUsesArraysOfCompoundTypeWrappers()) {
            for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
                JavaType javaType = methodBinding.getJavaArgumentType(i);
                if (!javaType.isArrayOfCompoundTypeWrappers()) continue;
                String string = this.getArgumentName(i);
                String string2 = string + COMPOUND_ARRAY_SUFFIX;
                printWriter.println("    ByteBuffer[] " + string2 + " = new ByteBuffer[" + string + ".length];");
                printWriter.println("    for (int _ctr = 0; _ctr < + " + string + ".length; _ctr++) {");
                printWriter.println("      " + javaType.getName() + " _tmp = " + string + "[_ctr];");
                printWriter.println("      " + string2 + "[_ctr] = ((_tmp == null) ? null : _tmp.getBuffer());");
                printWriter.println("    }");
            }
        }
    }

    protected void emitCall(MethodBinding methodBinding, PrintWriter printWriter) {
        printWriter.print(this.getImplMethodName());
        printWriter.print("(");
        this.emitCallArguments(methodBinding, printWriter);
        printWriter.print(");");
    }

    protected void emitReturnVariableSetupAndCall(MethodBinding methodBinding, PrintWriter printWriter) {
        printWriter.print("    ");
        JavaType javaType = methodBinding.getJavaReturnType();
        boolean bl = false;
        if (!javaType.isVoid()) {
            if (javaType.isCompoundTypeWrapper() || javaType.isNIOBuffer()) {
                printWriter.println("ByteBuffer _res;");
                bl = true;
            } else if (javaType.isArrayOfCompoundTypeWrappers()) {
                printWriter.println("ByteBuffer[] _res;");
                bl = true;
            } else if (this.epilogue != null && this.epilogue.size() > 0 || methodBinding.signatureUsesArraysOfCompoundTypeWrappers()) {
                this.emitReturnType(printWriter);
                printWriter.println(" _res;");
                bl = true;
            }
        }
        if (bl) {
            printWriter.print("    _res = ");
        } else {
            printWriter.print("    ");
            if (!javaType.isVoid()) {
                printWriter.print("return ");
            }
        }
        this.emitCall(methodBinding, printWriter);
        printWriter.println();
        this.emitPostCallCleanup(methodBinding, printWriter);
        this.emitPrologueOrEpilogue(this.epilogue, printWriter);
        if (bl) {
            this.emitCallResultReturn(methodBinding, printWriter);
        }
    }

    protected int emitCallArguments(MethodBinding methodBinding, PrintWriter printWriter) {
        boolean bl = false;
        int n = 0;
        if (methodBinding.hasContainingType()) {
            assert (methodBinding.getContainingType().isCompoundTypeWrapper());
            printWriter.print("getBuffer()");
            bl = true;
            ++n;
        }
        for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
            String string;
            JavaType javaType = methodBinding.getJavaArgumentType(i);
            String string2 = this.getArgumentName(i);
            if (javaType.isJNIEnv() || methodBinding.isArgumentThisPointer(i)) continue;
            if (javaType.isVoid()) {
                assert (methodBinding.getNumArguments() == 1);
                continue;
            }
            if (bl) {
                printWriter.print(", ");
            }
            if (javaType.isCompoundTypeWrapper()) {
                printWriter.print("((");
            }
            if (javaType.isNIOBuffer()) {
                string = this.isNIOArgName(i);
                if (javaType.isNIONativeSizeBuffer()) {
                    if (this.directNIOOnly) {
                        printWriter.print("_" + string2);
                    } else {
                        printWriter.print(string + " ? ( " + string2 + " != null ? " + string2 + ".getBuffer() : null )");
                        printWriter.print(" : Buffers.getArray(" + string2 + ")");
                    }
                } else if (this.directNIOOnly) {
                    printWriter.print(string2);
                } else {
                    printWriter.print(string + " ? " + string2 + " : Buffers.getArray(" + string2 + ")");
                }
            } else if (javaType.isArrayOfCompoundTypeWrappers()) {
                printWriter.print(string2 + COMPOUND_ARRAY_SUFFIX);
            } else {
                printWriter.print(string2);
            }
            if (javaType.isCompoundTypeWrapper()) {
                printWriter.print(" == null) ? null : ");
                printWriter.print(string2);
                printWriter.print(".getBuffer())");
            }
            if (javaType.isNIOBuffer()) {
                string = this.isNIOArgName(i);
                if (this.directNIOOnly) {
                    printWriter.print(", _" + string2 + "_offset");
                } else {
                    printWriter.print(", " + string + " ? Buffers.getDirectBufferByteOffset(" + string2 + ")");
                    printWriter.print(" : Buffers.getIndirectBufferByteOffset(" + string2 + ")");
                }
            } else if (javaType.isNIOBufferArray()) {
                printWriter.print(", " + this.byteOffsetArrayArgName(i));
            } else if (javaType.isPrimitiveArray()) {
                if (javaType.isFloatArray()) {
                    printWriter.print(", Buffers.SIZEOF_FLOAT * ");
                } else if (javaType.isDoubleArray()) {
                    printWriter.print(", Buffers.SIZEOF_DOUBLE * ");
                } else if (javaType.isByteArray()) {
                    printWriter.print(", ");
                } else if (javaType.isLongArray()) {
                    printWriter.print(", Buffers.SIZEOF_LONG * ");
                } else if (javaType.isShortArray()) {
                    printWriter.print(", Buffers.SIZEOF_SHORT * ");
                } else if (javaType.isIntArray()) {
                    printWriter.print(", Buffers.SIZEOF_INT * ");
                } else {
                    throw new RuntimeException("Unsupported type for calculating array offset argument for " + string2 + " -- error occurred while processing Java glue code for " + this.getName());
                }
                printWriter.print(this.offsetArgName(i));
            }
            if (javaType.isNIOBuffer()) {
                if (!this.directNIOOnly) {
                    printWriter.print(", " + this.isNIOArgName(i));
                }
            } else if (javaType.isPrimitiveArray()) {
                if (this.directNIOOnly) {
                    throw new RuntimeException("NIODirectOnly " + methodBinding + " is set, but " + string2 + " is a primitive array");
                }
                printWriter.print(", false");
            }
            bl = true;
            ++n;
        }
        return n;
    }

    protected void emitPostCallCleanup(MethodBinding methodBinding, PrintWriter printWriter) {
        if (methodBinding.signatureUsesArraysOfCompoundTypeWrappers()) {
            for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
                JavaType javaType = methodBinding.getJavaArgumentType(i);
                if (!javaType.isArrayOfCompoundTypeWrappers()) continue;
                String string = methodBinding.getArgumentName(i);
                printWriter.println("    for (int _ctr = 0; _ctr < " + string + ".length; _ctr++) {");
                printWriter.println("      if ((" + string + "[_ctr] == null && " + string + COMPOUND_ARRAY_SUFFIX + "[_ctr] == null) ||");
                printWriter.println("          (" + string + "[_ctr] != null && " + string + "[_ctr].getBuffer() == " + string + COMPOUND_ARRAY_SUFFIX + "[_ctr])) {");
                printWriter.println("        // No copy back needed");
                printWriter.println("      } else {");
                printWriter.println("        if (" + string + COMPOUND_ARRAY_SUFFIX + "[_ctr] == null) {");
                printWriter.println("          " + string + "[_ctr] = null;");
                printWriter.println("        } else {");
                printWriter.println("          " + string + "[_ctr] = " + javaType.getName() + ".create(" + string + COMPOUND_ARRAY_SUFFIX + "[_ctr]);");
                printWriter.println("        }");
                printWriter.println("      }");
                printWriter.println("    }");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void emitCallResultReturn(MethodBinding methodBinding, PrintWriter printWriter) {
        JavaType javaType = methodBinding.getJavaReturnType();
        if (javaType.isCompoundTypeWrapper()) {
            String string = this.getReturnedArrayLengthExpression();
            printWriter.println("    if (_res == null) return null;");
            if (string == null) {
                printWriter.print("    return " + javaType.getName() + ".create(Buffers.nativeOrder(_res))");
            } else {
                printWriter.println("    Buffers.nativeOrder(_res);");
                String string2 = new MessageFormat(string).format(this.argumentNameArray());
                PointerType pointerType = methodBinding.getCReturnType().asPointer();
                CompoundType compoundType = null;
                if (pointerType != null) {
                    compoundType = pointerType.getTargetType().asCompound();
                }
                if (compoundType == null) {
                    throw new RuntimeException("ReturnedArrayLength directive currently only supported for pointers to compound types (error occurred while generating Java glue code for " + this.getName() + ")");
                }
                printWriter.println("    " + this.getReturnTypeString(false) + " _retarray = new " + this.getReturnTypeString(true) + "[" + string2 + "];");
                printWriter.println("    for (int _count = 0; _count < " + string2 + "; _count++) {");
                printWriter.println("      _res.position(_count * " + this.getReturnTypeString(true) + ".size());");
                printWriter.println("      _res.limit   ((1 + _count) * " + this.getReturnTypeString(true) + ".size());");
                printWriter.println("      ByteBuffer _tmp = _res.slice();");
                printWriter.println("      Buffers.nativeOrder(_tmp);");
                printWriter.println("      _res.position(0);");
                printWriter.println("      _res.limit(_res.capacity());");
                printWriter.println("      _retarray[_count] = " + this.getReturnTypeString(true) + ".create(_tmp);");
                printWriter.println("    }");
                printWriter.print("    return _retarray");
            }
            printWriter.println(";");
            return;
        } else if (javaType.isNIOBuffer()) {
            printWriter.println("    if (_res == null) return null;");
            printWriter.println("    Buffers.nativeOrder(_res);");
            if (!javaType.isNIOByteBuffer()) {
                if (this.getBinding().getCReturnType().pointerDepth() >= 2) {
                    if (javaType.isNIONativeSizeBuffer()) {
                        printWriter.println("    return NativeSizeBuffer.wrap(_res);");
                        return;
                    } else {
                        if (!javaType.isNIOLongBuffer()) throw new RuntimeException("While emitting glue code for " + this.getName() + ": can not legally make pointers opaque to anything but PointerBuffer or LongBuffer/long");
                        printWriter.println("    return _res.asLongBuffer();");
                    }
                    return;
                } else if (this.getBinding().getCReturnType().pointerDepth() == 1 && javaType.isNIOLongBuffer()) {
                    printWriter.println("    return _res.asLongBuffer();");
                    return;
                } else {
                    String string = javaType.getName().substring("java.nio.".length());
                    printWriter.println("    return _res.as" + string + "();");
                }
                return;
            } else {
                printWriter.println("    return _res;");
            }
            return;
        } else if (javaType.isArrayOfCompoundTypeWrappers()) {
            printWriter.println("    if (_res == null) return null;");
            printWriter.println("    " + this.getReturnTypeString(false) + " _retarray = new " + this.getReturnTypeString(true) + "[_res.length];");
            printWriter.println("    for (int _count = 0; _count < _res.length; _count++) {");
            printWriter.println("      _retarray[_count] = " + this.getReturnTypeString(true) + ".create(_res[_count]);");
            printWriter.println("    }");
            printWriter.println("    return _retarray;");
            return;
        } else {
            printWriter.println("    return _res;");
        }
    }

    protected String[] argumentNameArray() {
        String[] stringArray = new String[this.binding.getNumArguments()];
        for (int i = 0; i < this.binding.getNumArguments(); ++i) {
            stringArray[i] = this.getArgumentName(i);
            if (!this.binding.getJavaArgumentType(i).isPrimitiveArray()) continue;
            stringArray[i] = stringArray[i] + ", " + this.offsetArgName(i);
        }
        return stringArray;
    }

    public static String javaThisArgumentName() {
        return "jthis0";
    }

    @Override
    protected String getCommentStartString() {
        return "/** ";
    }

    @Override
    protected String getBaseIndentString() {
        return "  ";
    }

    protected String getReturnedArrayLengthExpression() {
        return this.returnedArrayLengthExpression;
    }

    protected class InterfaceCommentEmitter
    extends DefaultCommentEmitter {
        protected InterfaceCommentEmitter() {
        }

        @Override
        protected void emitBeginning(FunctionEmitter functionEmitter, PrintWriter printWriter) {
            printWriter.print("Interface to C language function: <br> ");
        }
    }

    protected class DefaultCommentEmitter
    implements CommentEmitter {
        protected DefaultCommentEmitter() {
        }

        @Override
        public void emit(FunctionEmitter functionEmitter, PrintWriter printWriter) {
            this.emitBeginning(functionEmitter, printWriter);
            this.emitBindingCSignature(((JavaMethodBindingEmitter)functionEmitter).getBinding(), printWriter);
            this.emitEnding(functionEmitter, printWriter);
        }

        protected void emitBeginning(FunctionEmitter functionEmitter, PrintWriter printWriter) {
            printWriter.print("Entry point to C language function: ");
        }

        protected void emitBindingCSignature(MethodBinding methodBinding, PrintWriter printWriter) {
            printWriter.print("<code> ");
            printWriter.print(methodBinding.getCSymbol().toString(JavaMethodBindingEmitter.this.tagNativeBinding));
            printWriter.print(" </code> ");
        }

        protected void emitEnding(FunctionEmitter functionEmitter, PrintWriter printWriter) {
            MethodBinding methodBinding = ((JavaMethodBindingEmitter)functionEmitter).getBinding();
            for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
                Type type = methodBinding.getCArgumentType(i);
                JavaType javaType = methodBinding.getJavaArgumentType(i);
                if (type.isEnum() && !"<anonymous>".equals(type.getName())) {
                    EnumType enumType = (EnumType)type;
                    printWriter.println();
                    printWriter.print(functionEmitter.getBaseIndentString());
                    printWriter.print("    ");
                    printWriter.print("@param ");
                    printWriter.print(JavaMethodBindingEmitter.this.getArgumentName(i));
                    printWriter.print(" valid values are: <code>");
                    for (int j = 0; j < enumType.getNumEnumerates(); ++j) {
                        if (j > 0) {
                            printWriter.print(", ");
                        }
                        printWriter.print(enumType.getEnumName(j));
                    }
                    printWriter.println("</code>");
                    continue;
                }
                if (!JavaMethodBindingEmitter.this.directNIOOnly || !javaType.isNIOBuffer()) continue;
                printWriter.println();
                printWriter.print(functionEmitter.getBaseIndentString());
                printWriter.print("    ");
                printWriter.print("@param ");
                printWriter.print(JavaMethodBindingEmitter.this.getArgumentName(i));
                printWriter.print(" a direct {@link " + javaType.getName() + "}");
            }
        }
    }
}

