/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import com.jogamp.common.nio.NativeBuffer;
import com.jogamp.common.nio.NativeSizeBuffer;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.gluegen.cgram.types.Type;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class JavaType {
    private Class<?> clazz;
    private String name;
    private Type elementType;
    private C_PTR primitivePointerType;
    private static JavaType nioBufferType;
    private static JavaType nioByteBufferType;
    private static JavaType nioShortBufferType;
    private static JavaType nioIntBufferType;
    private static JavaType nioLongBufferType;
    private static JavaType nioPointerBufferType;
    private static JavaType nioNativeSizeBufferType;
    private static JavaType nioFloatBufferType;
    private static JavaType nioDoubleBufferType;
    private static JavaType nioByteBufferArrayType;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == null) return false;
        if (!(object instanceof JavaType)) {
            return false;
        }
        JavaType javaType = (JavaType)object;
        if (this == javaType) return true;
        if (javaType.clazz != this.clazz) return false;
        if (!(this.name != null ? this.name.equals(javaType.name) : javaType.name == null)) {
            if (this.name == null) return false;
            if (javaType.name == null) return false;
            if (!this.name.equals(javaType.name)) return false;
        }
        if (this.elementType != javaType.elementType) {
            if (this.elementType == null) return false;
            if (javaType.elementType == null) return false;
            if (!this.elementType.equals(javaType.elementType)) return false;
        }
        if (this.primitivePointerType != javaType.primitivePointerType) return false;
        return true;
    }

    public int hashCode() {
        if (this.clazz == null) {
            if (this.name == null) {
                return 0;
            }
            return this.name.hashCode();
        }
        return this.clazz.hashCode();
    }

    public JavaType getElementType() {
        return new JavaType(this.elementType);
    }

    public static JavaType createForClass(Class<?> clazz) {
        return new JavaType(clazz);
    }

    public static JavaType createForCStruct(String string) {
        return new JavaType(string);
    }

    public static JavaType createForCArray(Type type) {
        return new JavaType(type);
    }

    public static JavaType createForVoidPointer() {
        return new JavaType(C_PTR.VOID);
    }

    public static JavaType createForCCharPointer() {
        return new JavaType(C_PTR.CHAR);
    }

    public static JavaType createForCShortPointer() {
        return new JavaType(C_PTR.SHORT);
    }

    public static JavaType createForCInt32Pointer() {
        return new JavaType(C_PTR.INT32);
    }

    public static JavaType createForCInt64Pointer() {
        return new JavaType(C_PTR.INT64);
    }

    public static JavaType createForCFloatPointer() {
        return new JavaType(C_PTR.FLOAT);
    }

    public static JavaType createForCDoublePointer() {
        return new JavaType(C_PTR.DOUBLE);
    }

    public static JavaType createForJNIEnv() {
        return JavaType.createForCStruct("JNIEnv");
    }

    public static JavaType forNIOBufferClass() {
        if (nioBufferType == null) {
            nioBufferType = JavaType.createForClass(Buffer.class);
        }
        return nioBufferType;
    }

    public static JavaType forNIOByteBufferClass() {
        if (nioByteBufferType == null) {
            nioByteBufferType = JavaType.createForClass(ByteBuffer.class);
        }
        return nioByteBufferType;
    }

    public static JavaType forNIOShortBufferClass() {
        if (nioShortBufferType == null) {
            nioShortBufferType = JavaType.createForClass(ShortBuffer.class);
        }
        return nioShortBufferType;
    }

    public static JavaType forNIOIntBufferClass() {
        if (nioIntBufferType == null) {
            nioIntBufferType = JavaType.createForClass(IntBuffer.class);
        }
        return nioIntBufferType;
    }

    public static JavaType forNIOLongBufferClass() {
        if (nioLongBufferType == null) {
            nioLongBufferType = JavaType.createForClass(LongBuffer.class);
        }
        return nioLongBufferType;
    }

    public static JavaType forNIOPointerBufferClass() {
        if (nioPointerBufferType == null) {
            nioPointerBufferType = JavaType.createForClass(PointerBuffer.class);
        }
        return nioPointerBufferType;
    }

    public static JavaType forNIONativeSizeBufferClass() {
        if (nioNativeSizeBufferType == null) {
            nioNativeSizeBufferType = JavaType.createForClass(NativeSizeBuffer.class);
        }
        return nioNativeSizeBufferType;
    }

    public static JavaType forNIOFloatBufferClass() {
        if (nioFloatBufferType == null) {
            nioFloatBufferType = JavaType.createForClass(FloatBuffer.class);
        }
        return nioFloatBufferType;
    }

    public static JavaType forNIODoubleBufferClass() {
        if (nioDoubleBufferType == null) {
            nioDoubleBufferType = JavaType.createForClass(DoubleBuffer.class);
        }
        return nioDoubleBufferType;
    }

    public static JavaType forNIOByteBufferArrayClass() {
        if (nioByteBufferArrayType == null) {
            ByteBuffer[] byteBufferArray = new ByteBuffer[]{};
            nioByteBufferArrayType = JavaType.createForClass(byteBufferArray.getClass());
        }
        return nioByteBufferArrayType;
    }

    public Class<?> getJavaClass() {
        return this.clazz;
    }

    public String getName() {
        if (this.clazz != null) {
            if (this.clazz.isArray()) {
                return this.arrayName(this.clazz);
            }
            return this.clazz.getName();
        }
        if (this.elementType != null) {
            return this.elementType.getName();
        }
        return this.name;
    }

    public String getDescriptor() {
        if (this.clazz != null) {
            return this.descriptor(this.clazz);
        }
        if (this.elementType != null) {
            if (this.elementType.getName() == null) {
                throw new RuntimeException("elementType.name is null: " + this.getDumpString());
            }
            return "[" + this.descriptor(this.elementType.getName());
        }
        return this.descriptor(this.name);
    }

    public String jniTypeName() {
        if (this.isCompoundTypeWrapper()) {
            return "jobject";
        }
        if (this.isArrayOfCompoundTypeWrappers()) {
            return "jobjectArray /* of ByteBuffer */";
        }
        if (this.clazz == null) {
            return null;
        }
        if (this.isVoid()) {
            return "void";
        }
        if (this.isPrimitive()) {
            return "j" + this.clazz.getName();
        }
        if (this.isPrimitiveArray() || this.isNIOBuffer()) {
            return "jobject";
        }
        if (this.isArray()) {
            if (this.isStringArray()) {
                return "jobjectArray /*elements are String*/";
            }
            Class<?> clazz = this.clazz.getComponentType();
            if (this.isNIOBufferArray()) {
                return "jobjectArray /*elements are " + clazz.getName() + "*/";
            }
            if (clazz.isArray()) {
                if (clazz.getComponentType().isPrimitive()) {
                    return "jobjectArray /* elements are " + clazz.getComponentType() + "[]*/";
                }
                throw new RuntimeException("Multi-dimensional arrays of types that are not primitives or Strings are not supported.");
            }
            throw new RuntimeException("Unexpected and unsupported array type: \"" + this + "\"");
        }
        if (this.isString()) {
            return "jstring";
        }
        return "jobject";
    }

    public boolean isNIOBuffer() {
        return this.clazz != null && (Buffer.class.isAssignableFrom(this.clazz) || NativeBuffer.class.isAssignableFrom(this.clazz));
    }

    public boolean isNIOByteBuffer() {
        return this.clazz == ByteBuffer.class;
    }

    public boolean isNIOByteBufferArray() {
        return this == nioByteBufferArrayType;
    }

    public boolean isNIOBufferArray() {
        return this.isArray() && Buffer.class.isAssignableFrom(this.clazz.getComponentType());
    }

    public boolean isNIOLongBuffer() {
        return this.clazz == LongBuffer.class;
    }

    public boolean isNIOPointerBuffer() {
        return this.clazz == PointerBuffer.class;
    }

    public boolean isNIONativeSizeBuffer() {
        return this.clazz == NativeSizeBuffer.class;
    }

    public boolean isString() {
        return this.clazz == String.class;
    }

    public boolean isArray() {
        return this.clazz != null && this.clazz.isArray();
    }

    public boolean isFloatArray() {
        return this.clazz != null && this.clazz.isArray() && this.clazz.getComponentType() == Float.TYPE;
    }

    public boolean isDoubleArray() {
        return this.clazz != null && this.clazz.isArray() && this.clazz.getComponentType() == Double.TYPE;
    }

    public boolean isByteArray() {
        return this.clazz != null && this.clazz.isArray() && this.clazz.getComponentType() == Byte.TYPE;
    }

    public boolean isIntArray() {
        return this.clazz != null && this.clazz.isArray() && this.clazz.getComponentType() == Integer.TYPE;
    }

    public boolean isShortArray() {
        return this.clazz != null && this.clazz.isArray() && this.clazz.getComponentType() == Short.TYPE;
    }

    public boolean isLongArray() {
        return this.clazz != null && this.clazz.isArray() && this.clazz.getComponentType() == Long.TYPE;
    }

    public boolean isStringArray() {
        return this.clazz != null && this.clazz.isArray() && this.clazz.getComponentType() == String.class;
    }

    public boolean isPrimitive() {
        return this.clazz != null && !this.isArray() && this.clazz.isPrimitive() && this.clazz != Void.TYPE;
    }

    public boolean isPrimitiveArray() {
        return this.isArray() && this.clazz.getComponentType().isPrimitive();
    }

    public boolean isShort() {
        return this.clazz == Short.TYPE;
    }

    public boolean isFloat() {
        return this.clazz == Float.TYPE;
    }

    public boolean isDouble() {
        return this.clazz == Double.TYPE;
    }

    public boolean isByte() {
        return this.clazz == Byte.TYPE;
    }

    public boolean isLong() {
        return this.clazz == Long.TYPE;
    }

    public boolean isInt() {
        return this.clazz == Integer.TYPE;
    }

    public boolean isVoid() {
        return this.clazz == Void.TYPE;
    }

    public boolean isCompoundTypeWrapper() {
        return this.clazz == null && this.name != null && !this.isJNIEnv();
    }

    public boolean isArrayOfCompoundTypeWrappers() {
        return this.elementType != null;
    }

    public boolean isCPrimitivePointerType() {
        return this.primitivePointerType != null;
    }

    public boolean isCVoidPointerType() {
        return C_PTR.VOID.equals((Object)this.primitivePointerType);
    }

    public boolean isCCharPointerType() {
        return C_PTR.CHAR.equals((Object)this.primitivePointerType);
    }

    public boolean isCShortPointerType() {
        return C_PTR.SHORT.equals((Object)this.primitivePointerType);
    }

    public boolean isCInt32PointerType() {
        return C_PTR.INT32.equals((Object)this.primitivePointerType);
    }

    public boolean isCInt64PointerType() {
        return C_PTR.INT64.equals((Object)this.primitivePointerType);
    }

    public boolean isCFloatPointerType() {
        return C_PTR.FLOAT.equals((Object)this.primitivePointerType);
    }

    public boolean isCDoublePointerType() {
        return C_PTR.DOUBLE.equals((Object)this.primitivePointerType);
    }

    public boolean isJNIEnv() {
        return this.clazz == null && "JNIEnv".equals(this.name);
    }

    public Object clone() {
        JavaType javaType = new JavaType(this.primitivePointerType);
        javaType.clazz = this.clazz;
        javaType.name = this.name;
        javaType.elementType = this.elementType;
        return javaType;
    }

    public String toString() {
        return this.getName();
    }

    public String getDumpString() {
        return "[clazz = " + this.clazz + " , name = " + this.name + " , elementType = " + this.elementType + " , primitivePointerType = " + (Object)((Object)this.primitivePointerType) + "]";
    }

    public void dump() {
        System.err.println(this.getDumpString());
    }

    private JavaType(Class<?> clazz) {
        this.clazz = clazz;
    }

    private JavaType(String string) {
        this.name = string;
    }

    private JavaType(Type type) {
        this.elementType = type;
    }

    private JavaType(C_PTR c_PTR) {
        this.primitivePointerType = c_PTR;
    }

    private String arrayName(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (clazz.isArray()) {
            ++n;
            clazz = clazz.getComponentType();
        }
        stringBuilder.append(clazz.getName());
        while (--n >= 0) {
            stringBuilder.append("[]");
        }
        return stringBuilder.toString();
    }

    private String arrayDescriptor(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        while (clazz.isArray()) {
            stringBuilder.append("[");
            clazz = clazz.getComponentType();
        }
        stringBuilder.append(this.descriptor(clazz));
        return stringBuilder.toString();
    }

    private String descriptor(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unexpected primitive type " + clazz.getName());
        }
        if (clazz.isArray()) {
            return this.arrayDescriptor(clazz);
        }
        return this.descriptor(clazz.getName());
    }

    private String descriptor(String string) {
        return "L" + string.replace('.', '/') + ";";
    }

    private static enum C_PTR {
        VOID,
        CHAR,
        SHORT,
        INT32,
        INT64,
        FLOAT,
        DOUBLE;

    }
}

