/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import com.jogamp.gluegen.cgram.types.ArrayType;
import com.jogamp.gluegen.cgram.types.CompoundType;
import com.jogamp.gluegen.cgram.types.Field;
import com.jogamp.gluegen.cgram.types.SizeThunk;
import com.jogamp.gluegen.cgram.types.Type;

public class StructLayout {
    private int baseOffset;
    private int structAlignment;

    protected StructLayout(int n, int n2) {
        this.baseOffset = n;
        this.structAlignment = n2;
    }

    public void layout(CompoundType compoundType) {
        int n = compoundType.getNumFields();
        SizeThunk sizeThunk = SizeThunk.constant(this.baseOffset);
        SizeThunk sizeThunk2 = SizeThunk.constant(0);
        for (int i = 0; i < n; ++i) {
            Object object;
            Field field = compoundType.getField(i);
            Type type = field.getType();
            if (type.isInt() || type.isFloat() || type.isDouble() || type.isPointer()) {
                object = type.getSize();
                sizeThunk = SizeThunk.roundUp(sizeThunk, (SizeThunk)object);
                field.setOffset(sizeThunk);
                if (compoundType.isUnion()) {
                    sizeThunk2 = SizeThunk.max(sizeThunk2, (SizeThunk)object);
                    continue;
                }
                sizeThunk = SizeThunk.add(sizeThunk, (SizeThunk)object);
                continue;
            }
            if (type.isCompound()) {
                new StructLayout(0, this.structAlignment).layout(type.asCompound());
                sizeThunk = SizeThunk.roundUp(sizeThunk, SizeThunk.constant(this.structAlignment));
                field.setOffset(sizeThunk);
                if (compoundType.isUnion()) {
                    sizeThunk2 = SizeThunk.max(sizeThunk2, type.getSize());
                    continue;
                }
                sizeThunk = SizeThunk.add(sizeThunk, type.getSize());
                continue;
            }
            if (type.isArray()) {
                object = type.asArray();
                CompoundType compoundType2 = ((ArrayType)object).getBaseElementType().asCompound();
                if (compoundType2 != null) {
                    new StructLayout(0, this.structAlignment).layout(compoundType2);
                    ((ArrayType)object).recomputeSize();
                }
                sizeThunk = SizeThunk.roundUp(sizeThunk, SizeThunk.constant(this.structAlignment));
                field.setOffset(sizeThunk);
                sizeThunk = SizeThunk.add(sizeThunk, type.getSize());
                continue;
            }
            object = compoundType.getName();
            if (object == null) {
                object = compoundType.toString();
            }
            throw new RuntimeException("Complicated field types (" + type + " " + field.getName() + " in type " + (String)object + ") not implemented yet");
        }
        if (compoundType.isUnion()) {
            compoundType.setSize(sizeThunk2);
        } else {
            compoundType.setSize(sizeThunk);
        }
    }

    public static StructLayout createForCurrentPlatform() {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.arch").toLowerCase();
        if (string.startsWith("windows") && string2.equals("x86")) {
            return new StructLayout(0, 4);
        }
        if (string.startsWith("windows") && string2.equals("amd64") || string.startsWith("linux") && string2.equals("i386") || string.startsWith("linux") && string2.equals("x86") || string.startsWith("linux") && string2.equals("amd64") || string.startsWith("linux") && string2.equals("x86_64") || string.startsWith("linux") && string2.equals("ia64") || string.startsWith("sunos") && string2.equals("sparc") || string.startsWith("sunos") && string2.equals("sparcv9") || string.startsWith("sunos") && string2.equals("x86") || string.startsWith("sunos") && string2.equals("amd64") || string.startsWith("mac os") && string2.equals("ppc") || string.startsWith("mac os") && string2.equals("i386") || string.startsWith("mac os") && string2.equals("x86_64") || string.startsWith("freebsd") && string2.equals("i386") || string.startsWith("freebsd") && string2.equals("amd64") || string.startsWith("hp-ux") && string2.equals("pa_risc2.0")) {
            return new StructLayout(0, 8);
        }
        throw new RuntimeException("Please port StructLayout to your OS (" + string + ") and CPU (" + string2 + ")");
    }
}

