/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram.types;

import com.jogamp.gluegen.cgram.types.CompoundTypeKind;
import com.jogamp.gluegen.cgram.types.Field;
import com.jogamp.gluegen.cgram.types.SizeThunk;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.cgram.types.TypeVisitor;
import java.util.ArrayList;

public class CompoundType
extends Type
implements Cloneable {
    private CompoundTypeKind kind;
    private String structName;
    private ArrayList<Field> fields;
    private boolean visiting;
    private boolean bodyParsed;
    private boolean computedHashcode;
    private int hashcode;

    public CompoundType(String string, SizeThunk sizeThunk, CompoundTypeKind compoundTypeKind, int n) {
        this(string, sizeThunk, compoundTypeKind, n, null);
    }

    private CompoundType(String string, SizeThunk sizeThunk, CompoundTypeKind compoundTypeKind, int n, String string2) {
        super(string, sizeThunk, n);
        assert (compoundTypeKind != null);
        this.kind = compoundTypeKind;
        this.structName = string2;
    }

    @Override
    public Object clone() {
        CompoundType compoundType = (CompoundType)super.clone();
        if (null != this.fields) {
            compoundType.fields = (ArrayList)this.fields.clone();
        }
        return compoundType;
    }

    @Override
    public int hashCode() {
        if (this.computedHashcode) {
            return this.hashcode;
        }
        this.hashcode = this.structName != null ? this.structName.hashCode() : (this.getName() != null ? this.getName().hashCode() : 0);
        this.computedHashcode = true;
        return this.hashcode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) return false;
        if (!(object instanceof CompoundType)) {
            return false;
        }
        CompoundType compoundType = (CompoundType)object;
        if (!super.equals(object)) return false;
        if (!(this.structName != null ? this.structName.equals(compoundType.structName) : compoundType.structName == null)) {
            if (this.structName == null) return false;
            if (!this.structName.equals(compoundType.structName)) return false;
        }
        if (this.kind != compoundType.kind) return false;
        if (!CompoundType.listsEqual(this.fields, compoundType.fields)) return false;
        return true;
    }

    public String getStructName() {
        return this.structName;
    }

    public void setStructName(String string) {
        this.structName = string;
    }

    @Override
    public void setSize(SizeThunk sizeThunk) {
        super.setSize(sizeThunk);
    }

    @Override
    public CompoundType asCompound() {
        return this;
    }

    public int getNumFields() {
        return this.fields == null ? 0 : this.fields.size();
    }

    public Field getField(int n) {
        return this.fields.get(n);
    }

    public void addField(Field field) {
        if (this.bodyParsed) {
            throw new RuntimeException("Body of this CompoundType has already been parsed; should not be adding more fields");
        }
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        this.fields.add(field);
    }

    public void setBodyParsed() {
        this.bodyParsed = true;
    }

    public boolean isStruct() {
        return this.kind == CompoundTypeKind.STRUCT;
    }

    public boolean isUnion() {
        return this.kind == CompoundTypeKind.UNION;
    }

    @Override
    public String toString() {
        String string = this.getCVAttributesString();
        if (this.getName() != null) {
            return string + this.getName();
        }
        if (this.getStructName() != null) {
            return string + "struct " + this.getStructName();
        }
        return string + this.getStructString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(TypeVisitor typeVisitor) {
        if (this.visiting) {
            return;
        }
        try {
            this.visiting = true;
            super.visit(typeVisitor);
            int n = this.getNumFields();
            for (int i = 0; i < n; ++i) {
                Field field = this.getField(i);
                field.getType().visit(typeVisitor);
            }
        }
        finally {
            this.visiting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStructString() {
        if (this.visiting) {
            if (this.getName() != null) {
                return this.getName();
            }
            return "struct {/*Recursive type reference*/}";
        }
        try {
            this.visiting = true;
            String string = this.isStruct() ? "struct {" : "union {";
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            int n = this.getNumFields();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(" ");
                stringBuffer.append(this.getField(i));
            }
            stringBuffer.append(" }");
            String string2 = stringBuffer.toString();
            return string2;
        }
        finally {
            this.visiting = false;
        }
    }

    @Override
    Type newCVVariant(int n) {
        CompoundType compoundType = new CompoundType(this.getName(), this.getSize(), this.kind, n, this.structName);
        compoundType.fields = this.fields;
        return compoundType;
    }
}

