/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram.types;

import com.jogamp.gluegen.cgram.types.MachineDescription;

public abstract class SizeThunk
implements Cloneable {
    public static final SizeThunk CHAR = new SizeThunk(){

        @Override
        public long compute(MachineDescription machineDescription) {
            return machineDescription.charSizeInBytes();
        }
    };
    public static final SizeThunk SHORT = new SizeThunk(){

        @Override
        public long compute(MachineDescription machineDescription) {
            return machineDescription.shortSizeInBytes();
        }
    };
    public static final SizeThunk INT = new SizeThunk(){

        @Override
        public long compute(MachineDescription machineDescription) {
            return machineDescription.intSizeInBytes();
        }
    };
    public static final SizeThunk LONG = new SizeThunk(){

        @Override
        public long compute(MachineDescription machineDescription) {
            return machineDescription.longSizeInBytes();
        }
    };
    public static final SizeThunk INT64 = new SizeThunk(){

        @Override
        public long compute(MachineDescription machineDescription) {
            return machineDescription.int64SizeInBytes();
        }
    };
    public static final SizeThunk FLOAT = new SizeThunk(){

        @Override
        public long compute(MachineDescription machineDescription) {
            return machineDescription.floatSizeInBytes();
        }
    };
    public static final SizeThunk DOUBLE = new SizeThunk(){

        @Override
        public long compute(MachineDescription machineDescription) {
            return machineDescription.doubleSizeInBytes();
        }
    };
    public static final SizeThunk POINTER = new SizeThunk(){

        @Override
        public long compute(MachineDescription machineDescription) {
            return machineDescription.pointerSizeInBytes();
        }
    };

    private SizeThunk() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public abstract long compute(MachineDescription var1);

    public static SizeThunk add(final SizeThunk sizeThunk, final SizeThunk sizeThunk2) {
        return new SizeThunk(){

            @Override
            public long compute(MachineDescription machineDescription) {
                return sizeThunk.compute(machineDescription) + sizeThunk2.compute(machineDescription);
            }
        };
    }

    public static SizeThunk sub(final SizeThunk sizeThunk, final SizeThunk sizeThunk2) {
        return new SizeThunk(){

            @Override
            public long compute(MachineDescription machineDescription) {
                return sizeThunk.compute(machineDescription) - sizeThunk2.compute(machineDescription);
            }
        };
    }

    public static SizeThunk mul(final SizeThunk sizeThunk, final SizeThunk sizeThunk2) {
        return new SizeThunk(){

            @Override
            public long compute(MachineDescription machineDescription) {
                return sizeThunk.compute(machineDescription) * sizeThunk2.compute(machineDescription);
            }
        };
    }

    public static SizeThunk mod(final SizeThunk sizeThunk, final SizeThunk sizeThunk2) {
        return new SizeThunk(){

            @Override
            public long compute(MachineDescription machineDescription) {
                return sizeThunk.compute(machineDescription) % sizeThunk2.compute(machineDescription);
            }
        };
    }

    public static SizeThunk roundUp(final SizeThunk sizeThunk, final SizeThunk sizeThunk2) {
        return new SizeThunk(){

            @Override
            public long compute(MachineDescription machineDescription) {
                long l;
                long l2 = sizeThunk.compute(machineDescription);
                long l3 = l2 % (l = sizeThunk2.compute(machineDescription));
                if (l3 == 0L) {
                    return l2;
                }
                return l2 + (l - l3);
            }
        };
    }

    public static SizeThunk max(final SizeThunk sizeThunk, final SizeThunk sizeThunk2) {
        return new SizeThunk(){

            @Override
            public long compute(MachineDescription machineDescription) {
                return Math.max(sizeThunk.compute(machineDescription), sizeThunk2.compute(machineDescription));
            }
        };
    }

    public static SizeThunk constant(final int n) {
        return new SizeThunk(){

            @Override
            public long compute(MachineDescription machineDescription) {
                return n;
            }
        };
    }
}

