/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl;

import com.sap.cloud.security.ams.dcl.DCLTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class DCLBuildInformationTools {
    private static final String VERSION = "Version";
    private static final String REVISION = "Revision";
    private static final String BUILD_TIME = "BuildTime";
    private static Properties appInfo = null;
    private static volatile String OWN_VERSION = null;
    private static volatile String OWN_VERSION_STRING = null;
    private static volatile String COMMIT_ID = null;
    private static volatile String BUILD_TIME_VALUE = null;

    private DCLBuildInformationTools() {
    }

    private static boolean isDirectory(URL locationUrl) {
        if (locationUrl != null && "file".equals(locationUrl.getProtocol())) {
            try {
                return new File(locationUrl.toURI()).isDirectory();
            }
            catch (URISyntaxException uRISyntaxException) {
                return false;
            }
        }
        return false;
    }

    private static boolean isLocalDevelopment() {
        CodeSource sc = DCLTools.class.getProtectionDomain().getCodeSource();
        return sc != null && DCLBuildInformationTools.isDirectory(sc.getLocation());
    }

    public static String getGitCommitId() {
        if (COMMIT_ID == null) {
            if (DCLBuildInformationTools.isLocalDevelopment()) {
                COMMIT_ID = "----";
            } else {
                DCLBuildInformationTools.init();
                COMMIT_ID = appInfo.getProperty(REVISION, "----");
            }
        }
        return COMMIT_ID;
    }

    public static String getBuildTime() {
        if (BUILD_TIME_VALUE == null) {
            if (DCLBuildInformationTools.isLocalDevelopment()) {
                BUILD_TIME_VALUE = "";
            } else {
                DCLBuildInformationTools.init();
                BUILD_TIME_VALUE = appInfo.getProperty(BUILD_TIME, "");
            }
        }
        return BUILD_TIME_VALUE;
    }

    private static synchronized void init() {
        if (appInfo == null) {
            appInfo = new Properties();
            try {
                Throwable throwable = null;
                Object var1_2 = null;
                try (InputStream is = DCLTools.class.getClassLoader().getResourceAsStream("DCLVersion.properties");){
                    if (is != null) {
                        appInfo.load(is);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String getVersion() {
        if (OWN_VERSION_STRING == null) {
            String version = null;
            Bundle bundle = FrameworkUtil.getBundle(DCLTools.class);
            if (bundle != null) {
                version = bundle.getVersion().toString();
            } else {
                DCLBuildInformationTools.init();
                version = appInfo.getProperty(VERSION, "----");
            }
            if (version == null) {
                version = "unknown";
            }
            OWN_VERSION_STRING = version;
        }
        return OWN_VERSION_STRING;
    }

    public static String getVersionInfo() {
        if (OWN_VERSION == null) {
            OWN_VERSION = "Version: " + DCLBuildInformationTools.getVersion() + " (commitId: " + DCLBuildInformationTools.getGitCommitId() + ")";
        }
        return OWN_VERSION;
    }
}

