/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sap.cloud.security.ams.dcl.DCLModelTools;
import com.sap.cloud.security.ams.dcl.DCLResourceHelper;
import com.sap.cloud.security.ams.dcl.DCLTools;
import com.sap.cloud.security.ams.dcl.ResourceLocation;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.NamedElement;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaAttribute;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaMap;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaType;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;

@Singleton
public class DCLDeclarativeQualifiedNameProvider
extends DefaultDeclarativeQualifiedNameProvider {
    @Inject
    private DCLResourceHelper dclResourceHelper;

    public QualifiedName qualifiedName(SchemaDefinition obj) {
        ResourceLocation rl = this.dclResourceHelper.getResourceLocation(obj.eResource());
        if (rl.isValid()) {
            return obj.isTenant() ? rl.getSchemaQualifiedName() : DCLTools.QN_ROOT_SCHEMA;
        }
        return null;
    }

    public QualifiedName qualifiedName(NamedElement obj) {
        ResourceLocation rl;
        NamedElement obj1 = obj;
        String name = obj.getName();
        if (name != null && (rl = this.dclResourceHelper.getResourceLocation(obj1.eResource())).isValid()) {
            return rl.getQualifiedName(name);
        }
        return null;
    }

    public QualifiedName qualifiedName(SchemaAttribute it) {
        List<String> segments = this.fillSchemaElementHierarchy(it);
        return segments == null ? null : QualifiedName.create(segments);
    }

    @Override
    protected QualifiedName computeFullyQualifiedNameFromNameAttribute(EObject obj) {
        return null;
    }

    @Override
    public QualifiedName getFullyQualifiedName(EObject obj) {
        return DCLModelTools.isNamedElement(obj) ? super.getFullyQualifiedName(obj) : null;
    }

    private List<String> fillSchemaElementHierarchy(EObject context) {
        if (context instanceof SchemaType || context instanceof SchemaMap) {
            return this.fillSchemaElementHierarchy(context.eContainer());
        }
        if (context instanceof SchemaAttribute) {
            SchemaAttribute se = (SchemaAttribute)context;
            String name = se.getName();
            List<String> res = null;
            if (name != null && (res = this.fillSchemaElementHierarchy(context.eContainer())) != null) {
                res.add(name);
            }
            return res;
        }
        return new ArrayList<String>();
    }
}

