/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl;

import com.sap.cloud.security.ams.dcl.DCLDerivedStateAwareResource;
import com.sap.cloud.security.ams.dcl.DCLModelTools;
import com.sap.cloud.security.ams.dcl.DCLTools;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.DataType;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyDocument;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaAttribute;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaDefinition;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.IDerivedStateComputer;

class DCLDerivedStateComputer
implements IDerivedStateComputer {
    DCLDerivedStateComputer() {
    }

    private static SchemaAttribute createDollarUserSchemaElement() {
        SchemaAttribute se = DCLModelTools.createSchemaElementStructure("$user");
        EList<SchemaAttribute> entries = se.getType().getNested().getEntries();
        entries.add(DCLModelTools.createSchemaElementType("user_uuid", DataType.DT_STRING));
        entries.add(DCLModelTools.createSchemaElementType("email", DataType.DT_STRING));
        entries.add(DCLModelTools.createSchemaElementType("groups", DataType.DT_STRING, true));
        return se;
    }

    @Override
    public void installDerivedState(DerivedStateAwareResource resource, boolean preLinkingPhase) {
        SchemaDefinition sd;
        if (!(resource instanceof DCLDerivedStateAwareResource)) {
            return;
        }
        DCLDerivedStateAwareResource dsr = (DCLDerivedStateAwareResource)resource;
        PolicyDocument root = DCLTools.getPolicyDocument(resource);
        SchemaDefinition schemaDefinition = sd = root == null ? null : root.getSchema();
        if (sd != null && !sd.isTenant() && !DCLModelTools.containsEntryWithName(sd, "$user")) {
            SchemaAttribute se = DCLDerivedStateComputer.createDollarUserSchemaElement();
            sd.getEntries().add(se);
            dsr.addElement(se);
        }
    }

    @Override
    public void discardDerivedState(DerivedStateAwareResource resource) {
        if (resource instanceof DCLDerivedStateAwareResource) {
            DCLDerivedStateAwareResource dsar = (DCLDerivedStateAwareResource)resource;
            dsar.removeAdditionalElements();
        }
    }
}

