/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl;

import com.sap.cloud.security.ams.dcl.validation.DCLIssue;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.linking.ILinkingDiagnosticMessageProvider;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.linking.impl.LinkingDiagnosticMessageProvider;

public class DCLLinkingDiagnosticMessageProvider
extends LinkingDiagnosticMessageProvider {
    private String getLinkText(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context) {
        try {
            return context.getLinkText();
        }
        catch (IllegalNodeException e) {
            return e.getNode().getText();
        }
    }

    @Override
    public DiagnosticMessage getUnresolvedProxyMessage(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context) {
        EClass referenceType = context.getReference().getEReferenceType();
        String msg = DCLIssue.CANNOT_FIND_TYPE_WITH_NAME.format(referenceType.getName(), this.getLinkText(context));
        return new DiagnosticMessage(msg, Severity.ERROR, DCLIssue.CANNOT_FIND_TYPE_WITH_NAME.getErrorCodeStr(), new String[0]);
    }

    private static DiagnosticMessage patch(DiagnosticMessage dm) {
        String msg = DCLIssue.LINKER_ERROR.format(dm.getMessage());
        return new DiagnosticMessage(msg, dm.getSeverity(), DCLIssue.LINKER_ERROR.getErrorCodeStr(), dm.getIssueData());
    }

    @Override
    public DiagnosticMessage getIllegalNodeMessage(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context, IllegalNodeException ex) {
        return DCLLinkingDiagnosticMessageProvider.patch(super.getIllegalNodeMessage(context, ex));
    }

    @Override
    public DiagnosticMessage getIllegalCrossReferenceMessage(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context, CrossReference reference) {
        return DCLLinkingDiagnosticMessageProvider.patch(super.getIllegalCrossReferenceMessage(context, reference));
    }

    @Override
    public DiagnosticMessage getViolatedBoundsConstraintMessage(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context, int size) {
        return DCLLinkingDiagnosticMessageProvider.patch(super.getViolatedBoundsConstraintMessage(context, size));
    }

    @Override
    public DiagnosticMessage getViolatedUniqueConstraintMessage(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context) {
        return DCLLinkingDiagnosticMessageProvider.patch(super.getViolatedUniqueConstraintMessage(context));
    }
}

