/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl;

import com.google.inject.Inject;
import com.sap.cloud.security.ams.dcl.DCLMtTools;
import com.sap.cloud.security.ams.dcl.DCLResourceHelper;
import com.sap.cloud.security.ams.dcl.ResourceLocation;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.JMapEntry;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;

public class DCLLinkingService
extends DefaultLinkingService {
    private static final Logger logger = Logger.getLogger(DCLLinkingService.class);
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private DCLResourceHelper dclResourceHelper;

    @Override
    protected IScope getScope(EObject context, EReference reference) {
        IScopeProvider scopeProvider = this.getScopeProvider();
        if (scopeProvider == null) {
            throw new IllegalStateException("scopeProvider must not be null.");
        }
        return scopeProvider.getScope(context, reference);
    }

    @Override
    public List<EObject> getLinkedObjects(EObject context, EReference ref, INode node) throws IllegalNodeException {
        QualifiedName qualifiedLinkName;
        IScope scope;
        EClass requiredType = ref.getEReferenceType();
        if (requiredType == null) {
            return Collections.emptyList();
        }
        String crossRefString = this.getCrossRefNodeAsString(node);
        if (crossRefString == null || crossRefString.equals("")) {
            return Collections.emptyList();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("before getLinkedObjects: node: '" + crossRefString + "'");
        }
        if ((scope = this.getScope(context, ref)) == null) {
            throw new AssertionError((Object)("Scope provider " + this.getScopeProvider().getClass().getName() + " must not return null for context " + String.valueOf(context) + ", reference " + String.valueOf(ref) + "! Consider to return IScope.NULLSCOPE instead."));
        }
        if (context instanceof JMapEntry) {
            qualifiedLinkName = QualifiedName.create(crossRefString);
        } else {
            ResourceLocation rl;
            qualifiedLinkName = this.qualifiedNameConverter.toQualifiedName(crossRefString);
            if (DCLMtTools.isReferencingElement(context) && qualifiedLinkName.getSegmentCount() == 1 && (rl = this.dclResourceHelper.getResourceLocation(context.eResource())).isValid()) {
                qualifiedLinkName = rl.getQualifiedName(qualifiedLinkName.getLastSegment());
            }
        }
        IEObjectDescription eObjectDescription = scope.getSingleElement(qualifiedLinkName);
        if (logger.isDebugEnabled()) {
            logger.debug("after getLinkedObjects: node: '" + crossRefString + "' result: " + String.valueOf(eObjectDescription));
        }
        if (eObjectDescription == null) {
            return Collections.emptyList();
        }
        EObject result = eObjectDescription.getEObjectOrProxy();
        return Collections.singletonList(result);
    }
}

