/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.sap.cloud.security.ams.dcl.DCLGenericEntity;
import com.sap.cloud.security.ams.dcl.DCLTools;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.AnnotatedElement;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.DataControlLanguageFactory;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.DataControlLanguagePackage;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.DataType;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.NamedElement;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyDocument;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaAttribute;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaMap;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaType;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.util.IAcceptor;

public class DCLModelTools {
    private static final Iterable<IEObjectDescription> EMPTY_ITERABLE = Collections::emptyIterator;

    private DCLModelTools() {
    }

    public static ISelectable getAllDCLDescriptions(Resource resource, IDefaultResourceDescriptionStrategy rds) {
        return new DCLResourceSelectable(resource, rds);
    }

    public static Iterable<IEObjectDescription> filter(Iterable<IEObjectDescription> coll, QualifiedName name, boolean ignoreCase) {
        return ignoreCase ? Iterables.filter(coll, f -> f.getQualifiedName().equalsIgnoreCase(name)) : Iterables.filter(coll, f -> f.getQualifiedName().equals(name));
    }

    public static Iterable<IEObjectDescription> filter(Iterable<IEObjectDescription> elements, EClass type) {
        return Iterables.filter(elements, f -> EcoreUtil2.isAssignableFrom(type, f.getEClass()));
    }

    public static Iterable<IEObjectDescription> describe(Iterable<? extends EObject> elements, IDefaultResourceDescriptionStrategy rds) {
        Iterable transformed = Iterables.transform(elements, new DescriptionHelper(rds));
        return Iterables.filter(transformed, Objects::nonNull);
    }

    public static Iterable<IEObjectDescription> describe(Collection<? extends EObject> elements, IDefaultResourceDescriptionStrategy rds) {
        return DCLTools.isEmpty(elements) ? EMPTY_ITERABLE : DCLModelTools.describe(elements, rds);
    }

    public static boolean isNamedElement(EObject obj) {
        return obj instanceof NamedElement;
    }

    public static Iterable<EObject> getNamedElementIterable(Resource resource) {
        return () -> DCLModelTools.getNamedElementIterator(resource);
    }

    public static Iterator<EObject> getNamedElementIterator(Resource resource) {
        final PolicyDocument root = DCLTools.getPolicyDocument(resource);
        return root == null ? Collections.emptyIterator() : new EcoreUtil.ContentTreeIterator<EObject>((Object)root, false){
            private static final long serialVersionUID = -4963147220725695772L;

            @Override
            public Iterator<EObject> getChildren(Object object) {
                if (object != root) {
                    EList<SchemaAttribute> entries;
                    SchemaAttribute se;
                    if (object instanceof SchemaDefinition) {
                        SchemaDefinition sd = (SchemaDefinition)object;
                        return sd.getEntries().iterator();
                    }
                    if (object instanceof SchemaAttribute && (se = (SchemaAttribute)object).getType() != null && se.getType().getNested() != null && DCLTools.hasContent(entries = se.getType().getNested().getEntries())) {
                        return entries.iterator();
                    }
                    return Collections.emptyIterator();
                }
                return Iterators.filter(this.getEObjectChildren((EObject)object), DCLModelTools::isNamedElement);
            }
        };
    }

    public static SchemaAttribute createSchemaElementType(String name, DataType dataType) {
        return DCLModelTools.createSchemaElement(name, DCLModelTools.createSchemaType(dataType, false));
    }

    public static SchemaAttribute createSchemaElementType(String name, DataType dataType, boolean isArray) {
        return DCLModelTools.createSchemaElement(name, DCLModelTools.createSchemaType(dataType, isArray));
    }

    public static SchemaAttribute createSchemaElementStructure(String name) {
        return DCLModelTools.createSchemaElement(name, DCLModelTools.createSchemaTypeStructure());
    }

    public static SchemaType createSchemaType(DataType dataType, boolean isArray) {
        SchemaType st = DataControlLanguageFactory.eINSTANCE.createSchemaType();
        st.setArray(isArray);
        st.setDataType(Objects.requireNonNull(dataType));
        return st;
    }

    public static SchemaType createSchemaTypeStructure() {
        SchemaType st = DataControlLanguageFactory.eINSTANCE.createSchemaType();
        st.setDataType(null);
        st.setArray(false);
        SchemaMap sm = DataControlLanguageFactory.eINSTANCE.createSchemaMap();
        st.setNested(sm);
        return st;
    }

    public static SchemaAttribute createSchemaElement(String name, SchemaType type) {
        SchemaAttribute se = DataControlLanguageFactory.eINSTANCE.createSchemaAttribute();
        se.setName(Objects.requireNonNull(name));
        se.setType(Objects.requireNonNull(type));
        se.eAdapters().add(DCLGenericEntity.INSTANCE);
        return se;
    }

    public static boolean containsEntryWithName(SchemaMap smap, String name) {
        for (SchemaAttribute se : smap.getEntries()) {
            if (!name.equals(se.getName())) continue;
            return true;
        }
        return false;
    }

    private static class DCLResourceSelectable
    implements ISelectable {
        private Resource resource;
        private IDefaultResourceDescriptionStrategy rds;

        public DCLResourceSelectable(Resource resource, IDefaultResourceDescriptionStrategy rds) {
            this.resource = resource;
            this.rds = rds;
        }

        @Override
        public boolean isEmpty() {
            return DCLTools.getPolicyDocument(this.resource) == null;
        }

        @Override
        public Iterable<IEObjectDescription> getExportedObjects() {
            PolicyDocument root = DCLTools.getPolicyDocument(this.resource);
            return root == null ? EMPTY_ITERABLE : DCLModelTools.describe(DCLModelTools.getNamedElementIterable(this.resource), this.rds);
        }

        @Override
        public Iterable<IEObjectDescription> getExportedObjects(EClass type, QualifiedName name, boolean ignoreCase) {
            Iterable<IEObjectDescription> it = this.getExportedObjectsByType(type);
            return it == EMPTY_ITERABLE ? EMPTY_ITERABLE : DCLModelTools.filter(it, name, ignoreCase);
        }

        @Override
        public Iterable<IEObjectDescription> getExportedObjectsByType(EClass type) {
            if (EcorePackage.eINSTANCE.getEClass().equals(type)) {
                return this.getExportedObjects();
            }
            Collection<? extends EObject> coll = this.getEObjectsForType(DCLTools.getPolicyDocument(this.resource), type);
            return DCLTools.isEmpty(coll) ? EMPTY_ITERABLE : DCLModelTools.describe(coll, this.rds);
        }

        @Override
        public Iterable<IEObjectDescription> getExportedObjectsByObject(EObject object) {
            PolicyDocument root = DCLTools.getPolicyDocument(this.resource);
            if (root == null) {
                return EMPTY_ITERABLE;
            }
            URI uri = EcoreUtil2.getPlatformResourceOrNormalizedURI(object);
            return Iterables.filter(this.getExportedObjectsByType(object.eClass()), input -> input.getEObjectOrProxy() == object || uri.equals(input.getEObjectURI()));
        }

        private Collection<? extends EObject> getEObjectsForType(PolicyDocument root, EClass type) {
            if (root == null || !type.getEPackage().equals(DataControlLanguagePackage.eINSTANCE)) {
                return Collections.emptyList();
            }
            switch (type.getClassifierID()) {
                case 25: 
                case 27: {
                    if (root.getSchema() == null) {
                        return Collections.emptyList();
                    }
                    return Collections.singleton(root.getSchema());
                }
                case 1: {
                    return root.getPolicies();
                }
                case 6: {
                    return root.getFunctions();
                }
                case 28: {
                    return root.getTestScenarios();
                }
                case 26: {
                    if (root.getSchema() == null) {
                        return Collections.emptyList();
                    }
                    return EcoreUtil2.getAllContentsOfType(root.getSchema(), SchemaAttribute.class);
                }
                case 10: {
                    return EcoreUtil2.getAllContentsOfType(root.getSchema(), AnnotatedElement.class);
                }
            }
            return Collections.emptyList();
        }
    }

    private static class DescriptionHelper<T extends EObject>
    implements Function<T, IEObjectDescription>,
    IAcceptor<IEObjectDescription> {
        private final IDefaultResourceDescriptionStrategy rds;
        private IEObjectDescription current;

        public DescriptionHelper(IDefaultResourceDescriptionStrategy rds) {
            this.rds = rds;
        }

        @Override
        public void accept(IEObjectDescription t) {
            this.current = t;
        }

        @Override
        public IEObjectDescription apply(T from) {
            return this.rds.createEObjectDescriptions((EObject)from, this) ? this.current : null;
        }
    }
}

