/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl;

import com.sap.cloud.security.ams.dcl.DCLResourceHelper;
import com.sap.cloud.security.ams.dcl.ResourceLocation;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionCall;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.FunctionDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyList;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyUse;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.TestCase;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.TestCaseInput;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.TestScenario;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerResult;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerResultAccessor;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.QualifiedName;

public class DCLMtTools {
    private DCLMtTools() {
    }

    public static boolean isMtSupport(DCLCompilerResultAccessor cra) {
        DCLCompilerResult cr = cra.get();
        if (cr != null) {
            return cr.getCompilerParameter().isMtSupport();
        }
        return false;
    }

    public static boolean isUsingSupport(DCLCompilerResultAccessor cra) {
        DCLCompilerResult cr = cra.get();
        if (cr != null) {
            return cr.getCompilerParameter().isUsingSupport();
        }
        return false;
    }

    public static boolean isReferenceableElement(EObject eo) {
        return eo instanceof PolicyDefinition || eo instanceof FunctionDefinition;
    }

    public static boolean isReferencingElement(EObject eo) {
        return eo instanceof PolicyUse || eo instanceof PolicyList || eo instanceof TestCaseInput || eo instanceof ExpressionCall;
    }

    public static Set<String> listReferencedPackages(EList<TestScenario> ts, QualifiedName pkg, DCLResourceHelper rh) {
        HashSet<String> referencedPackages = new HashSet<String>();
        for (TestScenario testScenario : ts) {
            EList<TestCase> testCases = testScenario.getTestCases();
            for (TestCase testCase : testCases) {
                PolicyList policies = testCase.getPolicyList();
                for (PolicyDefinition policy : policies.getPolicies()) {
                    ResourceLocation rl = rh.getResourceLocation(policy.eResource());
                    if (pkg.equals(rl.getQualifiedName())) continue;
                    referencedPackages.add(rl.getDclPackage());
                }
            }
        }
        return referencedPackages;
    }
}

