/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sap.cloud.security.ams.dcl.DCLStringProcessing;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Expression;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionIdentifier;
import java.util.List;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;

@Singleton
public class DCLNameTools {
    @Inject
    private IQualifiedNameProvider qnp;

    public String toString(QualifiedName it) {
        return it.toString(".");
    }

    public String toString(ExpressionIdentifier identifier, IDSerializationMode mode) {
        QualifiedName qName = this.getFullyQualifiedName(identifier);
        if (qName.isEmpty()) {
            throw new IllegalStateException("Qualified name must not be empty.");
        }
        DCLStringProcessing.SegmentType segmentType = DCLStringProcessing.getSegmentType(qName.getFirstSegment());
        switch (mode) {
            case REGO: {
                List<String> segments = qName.getSegments();
                StringBuilder sb = new StringBuilder(128);
                sb.append("input");
                if (segmentType != DCLStringProcessing.SegmentType.DCL) {
                    sb.append("[\"");
                    sb.append(segmentType.toString());
                    sb.append("\"]");
                }
                for (String id : segments) {
                    sb.append("[\"");
                    DCLStringProcessing.escapeJSONString(id, sb, true);
                    sb.append("\"]");
                }
                return sb.toString();
            }
            case MESSAGE: {
                return segmentType != DCLStringProcessing.SegmentType.DCL ? segmentType.getUiPrefix() + this.toString(qName) : this.toString(qName);
            }
        }
        throw new IllegalStateException("Unknown mode");
    }

    public QualifiedName getFullyQualifiedName(Expression id) {
        return id instanceof ExpressionIdentifier ? this.getFullyQualifiedName((ExpressionIdentifier)id) : null;
    }

    public QualifiedName getFullyQualifiedName(ExpressionIdentifier identifier) {
        return this.qnp.getFullyQualifiedName(identifier.getSchemaAttribute());
    }

    public String toString(ExpressionIdentifier identifier) {
        return this.toString(this.getFullyQualifiedName(identifier));
    }

    public static enum IDSerializationMode {
        MESSAGE,
        REGO;

    }
}

