/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl;

import com.google.common.base.Preconditions;
import com.google.inject.Singleton;
import com.sap.cloud.security.ams.dcl.DCLStringProcessing;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;

@Singleton
public class DCLQualifiedNameConverter
implements IQualifiedNameConverter {
    @Override
    public QualifiedName toQualifiedName(String qualifiedNameAsString) {
        Preconditions.checkArgument(qualifiedNameAsString != null, "Qualified name cannot be null");
        Preconditions.checkArgument(!qualifiedNameAsString.isEmpty(), "Qualified name cannot be empty");
        return DCLStringProcessing.toQualifiedName(qualifiedNameAsString);
    }

    @Override
    public String toString(QualifiedName qualifiedName) {
        return DCLStringProcessing.toFullQualifiedDclString(qualifiedName);
    }
}

