/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl;

import com.google.inject.Singleton;
import com.sap.cloud.security.ams.dcl.DCLTools;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaDefinition;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionStrategy;
import org.eclipse.xtext.util.IAcceptor;

@Singleton
public class DCLResourceDescriptionStrategy
extends DefaultResourceDescriptionStrategy {
    public static final String KEY_TENANT = "tenant";
    private static final Logger LOG = Logger.getLogger(DCLResourceDescriptionStrategy.class);

    @Override
    public boolean createEObjectDescriptions(EObject eObject, IAcceptor<IEObjectDescription> acceptor) {
        if (this.getQualifiedNameProvider() == null) {
            return false;
        }
        try {
            QualifiedName qualifiedName = this.getQualifiedNameProvider().getFullyQualifiedName(eObject);
            if (qualifiedName != null) {
                this.doAccept(eObject, acceptor, qualifiedName);
            }
        }
        catch (Exception exc) {
            LOG.error(exc.getMessage(), exc);
        }
        return true;
    }

    private void doAccept(EObject eObject, IAcceptor<IEObjectDescription> acceptor, QualifiedName qualifiedName) {
        SchemaDefinition sd;
        Map<String, String> map = Collections.emptyMap();
        if (eObject instanceof SchemaDefinition && (sd = (SchemaDefinition)eObject).isTenant()) {
            map = Collections.singletonMap(KEY_TENANT, DCLTools.emptify(sd.getName()));
        }
        acceptor.accept(EObjectDescription.create(qualifiedName, eObject, map));
    }
}

