/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sap.cloud.security.ams.dcl.DCLDerivedStateAwareResource;
import com.sap.cloud.security.ams.dcl.DCLTools;
import com.sap.cloud.security.ams.dcl.ResourceLocation;
import com.sap.cloud.security.ams.dcl.ResourceLocationAdapter;
import com.sap.cloud.security.ams.dcl.validation.DCLIssue;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IProjectConfigProvider;
import org.eclipse.xtext.workspace.ISourceFolder;

@Singleton
public class DCLResourceHelper {
    private static final Logger LOG = Logger.getLogger(DCLResourceHelper.class);
    private static final ThreadLocal<URI> CURRENT_SOURCE = new ThreadLocal();
    static final char URI_SEGMENT_SEPARATOR = '/';
    static final String URI_SEGMENT_SEPARATOR_STR = "/";
    private static final Pattern ALLOWED_PACKAGE_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z_0-9]*+(/[a-zA-Z_][a-zA-Z_0-9]*+)*+");
    private static final Pattern ALLOWED_FILE_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z_0-9]*+");
    private static final String[] ILLEGAL_DCL_NAME_PARTS = new String[]{"_dcl_"};
    @Inject(optional=true)
    private IProjectConfigProvider projectConfigProvider;

    public void setCurrentSource(String currentSource) {
        this.setCurrentSource(DCLResourceHelper.normalizeSourceURI(currentSource));
    }

    public void setCurrentSource(URI currentSourceUri) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("SetCurrentSource to " + String.valueOf(currentSourceUri));
        }
        CURRENT_SOURCE.set(currentSourceUri);
    }

    public static URI normalizeSourceURI(String currentSource) {
        URI uri = URI.createFileURI(currentSource);
        return uri.hasTrailingPathSeparator() ? uri : uri.appendSegment("");
    }

    public void removeCurrentSource() {
        CURRENT_SOURCE.remove();
    }

    private URI getCurrentSource(Resource resource) {
        URI res = CURRENT_SOURCE.get();
        if (res != null) {
            return res;
        }
        if (this.projectConfigProvider != null) {
            ISourceFolder sourceFolder;
            IProjectConfig projectConfig = this.projectConfigProvider.getProjectConfig(resource.getResourceSet());
            if (projectConfig != null && (sourceFolder = projectConfig.findSourceFolderContaining(resource.getURI())) != null) {
                return sourceFolder.getPath();
            }
            return null;
        }
        throw new IllegalStateException("CurrentSource folder not set");
    }

    public ResourceLocation createResourceLocation(Resource resource) {
        return this.createResourceLocation(resource, resource.getURI());
    }

    private ResourceLocation createResourceLocation(Resource resource, URI uri) {
        String fileName;
        String pkg;
        String logicalName;
        String qualifiedName;
        String tmp;
        URI currentSourceURI = this.getCurrentSource(resource);
        if (currentSourceURI == null) {
            return new ResourceLocation(uri, DCLIssue.DCL_FILE_NOT_IN_SOURCE_FOLDER, new Object[0]);
        }
        if (uri.isPlatform()) {
            tmp = currentSourceURI.toPlatformString(true);
            qualifiedName = uri.toPlatformString(true);
            qualifiedName = qualifiedName.substring(qualifiedName.indexOf(47, 1) + 1);
            if (LOG.isTraceEnabled()) {
                LOG.trace("{\"currentSourceURI\": \"" + String.valueOf(currentSourceURI) + "\", \"resourceURI\": \"" + qualifiedName + "\"}");
            }
            qualifiedName = DCLTools.normalizeToForwardSlash(qualifiedName);
            int idx = tmp.length() - tmp.indexOf(47, 1) - 1;
            logicalName = qualifiedName.substring(idx);
        } else if (uri.isFile()) {
            tmp = currentSourceURI.toString();
            qualifiedName = uri.toString();
            if (LOG.isTraceEnabled()) {
                LOG.trace("{\"currentSourceURI\": \"" + String.valueOf(currentSourceURI) + "\", \"resourceURI\": \"" + qualifiedName + "\"}");
            }
            if (!qualifiedName.startsWith(tmp)) {
                return new ResourceLocation(uri, DCLIssue.DCL_FILE_NOT_IN_SOURCE_FOLDER, new Object[0]);
            }
            qualifiedName = DCLTools.normalizeToForwardSlash(qualifiedName);
            logicalName = qualifiedName = qualifiedName.substring(tmp.length());
        } else {
            throw new IllegalStateException("Not supported URI:" + String.valueOf(uri));
        }
        int idx = logicalName.lastIndexOf(47);
        if (idx == -1) {
            pkg = "";
            fileName = logicalName;
        } else {
            pkg = logicalName.substring(0, idx);
            fileName = logicalName.substring(idx + 1);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("{\"pkg\": \"" + pkg + "\", \"fileName\": \"" + fileName + "\"}");
        }
        return this.createResourceLocation(uri, pkg, fileName, qualifiedName);
    }

    private ResourceLocation createResourceLocation(URI uri, String pkg, String fileName, String qualifiedName) {
        String s1;
        String EXT;
        String fileNameLower = fileName.toLowerCase(Locale.US);
        String string = EXT = fileNameLower.endsWith(".dcn") ? "dcn" : "dcl";
        if (pkg.isEmpty() && !fileNameLower.equals("schema.dcl") && !fileNameLower.equals("schema.dcn")) {
            return new ResourceLocation(uri, DCLIssue.DCL_FILE_ON_ROOT, fileName);
        }
        if (pkg.contains(".")) {
            return new ResourceLocation(uri, DCLIssue.DCL_PACKAGE_CONTAINS, pkg, ".");
        }
        if (pkg.toLowerCase(Locale.US).contains("_dcl_")) {
            return new ResourceLocation(uri, DCLIssue.DCL_PACKAGE_CONTAINS, pkg, "_dcl_");
        }
        if (!pkg.isEmpty() && !ALLOWED_PACKAGE_PATTERN.matcher(pkg).matches()) {
            return new ResourceLocation(uri, DCLIssue.DCL_PACKAGE_DOES_NOT_MATCH, pkg);
        }
        int length = "dcr".length();
        if (pkg.startsWith("dcr") && (pkg.length() == length || pkg.charAt(length) == '/')) {
            return new ResourceLocation(uri, DCLIssue.DCL_PACKAGE_START_WITH, pkg, "dcr");
        }
        if (fileNameLower.equals(".dcl")) {
            return new ResourceLocation(uri, DCLIssue.DCL_FILE_EQUALS, fileName);
        }
        if (!fileName.endsWith(".dcl") && !fileName.endsWith(".dcn")) {
            return new ResourceLocation(uri, DCLIssue.DCL_FILE_ENDS_WITH, fileName, EXT);
        }
        String fileNameLC = fileNameLower.substring(0, fileNameLower.length() - EXT.length() - 1);
        if (!ALLOWED_FILE_PATTERN.matcher(fileNameLC).matches()) {
            return new ResourceLocation(uri, DCLIssue.DCL_FILE_DOES_NOT_MATCH, fileName);
        }
        String[] stringArray = ILLEGAL_DCL_NAME_PARTS;
        int n = ILLEGAL_DCL_NAME_PARTS.length;
        int n2 = 0;
        while (n2 < n) {
            String np = stringArray[n2];
            if (fileNameLC.contains(np)) {
                return new ResourceLocation(uri, DCLIssue.DCL_FILE_CONTAINS, fileName, np);
            }
            ++n2;
        }
        ResourceLocation res = new ResourceLocation(uri, pkg, qualifiedName.substring(0, qualifiedName.length() - DCLTools.DCL_SUFFIX_LENGTH));
        QualifiedName qn = res.getQualifiedName();
        if (!qn.isEmpty() && "local".equalsIgnoreCase(s1 = qn.getFirstSegment())) {
            if (!"local".equals(s1)) {
                return new ResourceLocation(uri, DCLIssue.DCL_LOCAL_PACKAGE_CASING, pkg);
            }
            if (qn.getSegmentCount() > 1) {
                return new ResourceLocation(uri, DCLIssue.DCL_LOCAL_PACKAGE_NO_NESTED, pkg);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("{\"name\": \"" + res.getRelativeDocumentName() + "\"}");
        }
        return res;
    }

    public ResourceLocation getResourceLocation(Resource resource) {
        if (resource instanceof DCLDerivedStateAwareResource) {
            return ((DCLDerivedStateAwareResource)resource).getResourceLocation();
        }
        return ResourceLocationAdapter.grantResourceLocationAdapter(this, resource).getResourceLocation();
    }
}

