/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl;

import com.sap.cloud.security.ams.dcl.DCLTools;
import com.sap.cloud.security.ams.dcl.client.language.DataControlLanguageScanner;
import com.sap.cloud.security.ams.dcl.client.language.DataControlLanguageTools;
import com.sap.cloud.security.ams.dcl.client.language.TokenFormat;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.Strings;

public class DCLStringProcessing {
    private static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();

    private DCLStringProcessing() {
    }

    private static boolean isQuoted(String s, char quoteChar) {
        return s != null && s.length() >= 2 && quoteChar == s.charAt(0) && quoteChar == s.charAt(s.length() - 1);
    }

    public static SegmentType getSegmentType(String data) {
        if (DCLTools.hasContent(data) && '$' == data.charAt(0)) {
            return "$dcl".equals(data) ? SegmentType.DCL : SegmentType.ENV;
        }
        return SegmentType.APP;
    }

    public static boolean isRegoFormat(String id) {
        return TokenFormat.ALPHA_NUMERIC_EXT.isToken(id);
    }

    public static boolean escapeRegoLikeString(String data, StringBuilder sb, boolean appendIfNotEscaped) {
        return DCLStringProcessing.escapeString(data, sb, appendIfNotEscaped, true);
    }

    public static boolean escapeJSONString(String data, StringBuilder sb, boolean appendIfNotEscaped) {
        return DCLStringProcessing.escapeString(data, sb, appendIfNotEscaped, false);
    }

    private static boolean escapeString(String data, StringBuilder sb, boolean appendIfNotEscaped, boolean regex) {
        if (DCLTools.isEmpty(data)) {
            return false;
        }
        int start = 0;
        int pos = 0;
        int len = data.length();
        block8: do {
            char ch = data.charAt(pos);
            switch (ch) {
                case '\b': {
                    ch = 'b';
                    break;
                }
                case '\f': {
                    ch = 'f';
                    break;
                }
                case '\n': {
                    ch = 'n';
                    break;
                }
                case '\r': {
                    ch = 'r';
                    break;
                }
                case '\t': {
                    ch = 't';
                    break;
                }
                case '\"': 
                case '/': 
                case '\\': {
                    break;
                }
                default: {
                    if (ch < ' ') {
                        if (start != pos) {
                            sb.append(data, start, pos);
                        }
                        if (regex) {
                            sb.append("\\\\x");
                            sb.append(HEX_CHARS[ch / 16]);
                            sb.append(HEX_CHARS[ch % 16]);
                        } else {
                            sb.append("\\u00");
                            sb.append((char)(48 + ch / 10));
                            sb.append((char)(48 + ch % 10));
                        }
                        start = ++pos;
                        continue block8;
                    }
                    ++pos;
                    continue block8;
                }
            }
            if (start != pos) {
                sb.append(data, start, pos);
            }
            sb.append('\\');
            sb.append(ch);
            start = ++pos;
        } while (pos != len);
        if (start != len && (start != 0 || appendIfNotEscaped)) {
            sb.append(data, start, len);
        }
        return start != 0;
    }

    private static String quoteEscapeIfNeeded(String string, char quote) {
        return string != null && !DCLStringProcessing.isIdentifier(string) ? quote + DCLStringProcessing.convertToJavaString(string, true) + quote : string;
    }

    public static String doubleQuotedEscapeIfNeeded(String string) {
        return DCLStringProcessing.quoteEscapeIfNeeded(string, '\"');
    }

    public static String singleQuotedEscapeIfNeeded(String string) {
        return DCLStringProcessing.quoteEscapeIfNeeded(string, '\'');
    }

    public static String convertFromJavaString(String string, boolean unicode) {
        return Strings.convertFromJavaString(string, unicode);
    }

    public static String convertToJavaString(String string, boolean unicode) {
        return Strings.convertToJavaString(string, unicode);
    }

    private static String decodeQuotedString(String string, char quote) {
        if (DCLStringProcessing.isQuoted(string, quote)) {
            string = DCLStringProcessing.convertFromJavaString(string.substring(1, string.length() - 1), true);
        }
        return string;
    }

    public static String decodeDoubleQuotedString(String string) {
        return DCLStringProcessing.decodeQuotedString(string, '\"');
    }

    public static String decodeSingleQuotedString(String string) {
        return DCLStringProcessing.decodeQuotedString(string, '\'');
    }

    public static String replaceAllPlain(Pattern pattern, String input, Function<MatchResult, String> replacer) {
        Objects.requireNonNull(replacer);
        Matcher it = pattern.matcher(input);
        if (it.find()) {
            StringBuffer sb = new StringBuffer();
            do {
                it.appendReplacement(sb, replacer.apply(it));
            } while (it.find());
            it.appendTail(sb);
            return sb.toString();
        }
        return input;
    }

    private static List<String> splitSegments(String qualifiedNameAsString) {
        DataControlLanguageScanner scanner = DataControlLanguageScanner.create();
        scanner.input(qualifiedNameAsString);
        List<String> segments = scanner.scanQualifiedName(false);
        if (!scanner.isOk() || scanner.hasMore() || segments.isEmpty()) {
            return Collections.emptyList();
        }
        return segments;
    }

    public static QualifiedName toQualifiedName(String qualifiedNameAsString) {
        if (qualifiedNameAsString.indexOf(34) == -1 && qualifiedNameAsString.indexOf(46) == -1) {
            return QualifiedName.create(qualifiedNameAsString);
        }
        return QualifiedName.create(DCLStringProcessing.splitSegments(qualifiedNameAsString));
    }

    public static boolean isIdentifier(String value) {
        return TokenFormat.DCL_IDENTIFIER.isToken(value);
    }

    public static boolean isValidCharacters(String value) {
        if (DCLTools.hasContent(value)) {
            int idx = 0;
            int length = value.length();
            while (idx < length) {
                char ch = value.charAt(idx);
                if (Character.isSurrogate(ch)) {
                    return false;
                }
                ++idx;
            }
        }
        return true;
    }

    public static String createQualifiedPolicy(String dclPackage, String policy) {
        return DataControlLanguageTools.createQualifiedPolicy(dclPackage, policy);
    }

    public static String toFullQualifiedDclString(QualifiedName qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Qualified name must not be null.");
        }
        int end = qualifiedName.getSegmentCount();
        if (end == 0) {
            return "\"\"";
        }
        if (end == 1) {
            String s = qualifiedName.getSegment(0);
            if (!TokenFormat.DCL_IDENTIFIER.isToken(s)) {
                StringBuilder sb = new StringBuilder(s.length() + 10);
                DataControlLanguageTools.appendQuotedString(sb, s);
                return sb.toString();
            }
            return s;
        }
        StringBuilder sb = new StringBuilder(128);
        int i = 0;
        while (i < end) {
            String s = qualifiedName.getSegment(i);
            if (sb.length() > 0) {
                sb.append('.');
            }
            if (!TokenFormat.DCL_IDENTIFIER.isToken(s)) {
                DataControlLanguageTools.appendQuotedString(sb, s);
            } else {
                sb.append(s);
            }
            ++i;
        }
        return sb.toString();
    }

    public static enum SegmentType {
        DCL("$dcl"),
        APP("$app"),
        ENV("$env");

        private final String name;
        private final String uiPrefix;

        private SegmentType(String name) {
            this.name = name;
            this.uiPrefix = name.substring(1) + ".";
        }

        public String toString() {
            return this.name;
        }

        public String getUiPrefix() {
            return this.uiPrefix;
        }
    }
}

