/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl;

import com.google.inject.Inject;
import com.sap.cloud.security.ams.dcl.validation.DCLIssue;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.parser.antlr.ISyntaxErrorMessageProvider;
import org.eclipse.xtext.parser.antlr.SyntaxErrorMessageProvider;

public class DCLSyntaxErrorMessageProvider
extends SyntaxErrorMessageProvider {
    @Inject
    private IGrammarAccess grammarAccess;
    private static volatile Set<String> ALL_KEYWORDS;

    private static SyntaxErrorMessage patch(SyntaxErrorMessage dm) {
        String msg = DCLIssue.SYNTAX_ERROR.format(dm.getMessage());
        return new SyntaxErrorMessage(msg, DCLIssue.SYNTAX_ERROR.getErrorCodeStr(), dm.getIssueData());
    }

    @Override
    public SyntaxErrorMessage getSyntaxErrorMessage(ISyntaxErrorMessageProvider.IParserErrorContext context) {
        Optional<SyntaxErrorMessage> nameMustNotBeAKeywordError = this.getNameMustNotBeAKeywordError(context);
        if (nameMustNotBeAKeywordError.isPresent()) {
            return nameMustNotBeAKeywordError.get();
        }
        return DCLSyntaxErrorMessageProvider.patch(super.getSyntaxErrorMessage(context));
    }

    private Optional<SyntaxErrorMessage> getNameMustNotBeAKeywordError(ISyntaxErrorMessageProvider.IParserErrorContext context) {
        return this.extractMismatchedTokenException(context).map(e -> e.token).map(t -> t.getText()).map(keyword -> {
            if (this.getAllKeywords().contains(keyword.toUpperCase(Locale.ENGLISH))) {
                String msg = DCLIssue.NAME_MUST_NOT_BE_A_KEYWORD.format(keyword);
                return new SyntaxErrorMessage(msg, DCLIssue.NAME_MUST_NOT_BE_A_KEYWORD.getErrorCodeStr());
            }
            return null;
        });
    }

    private Optional<RecognitionException> extractMismatchedTokenException(ISyntaxErrorMessageProvider.IParserErrorContext context) {
        RecognitionException e;
        if (context != null && ((e = context.getRecognitionException()) instanceof MismatchedTokenException || e instanceof NoViableAltException)) {
            return Optional.of(e);
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<String> getAllKeywords() {
        Set<String> localAllKeywords = ALL_KEYWORDS;
        if (localAllKeywords != null) return localAllKeywords;
        Class<DCLSyntaxErrorMessageProvider> clazz = DCLSyntaxErrorMessageProvider.class;
        synchronized (DCLSyntaxErrorMessageProvider.class) {
            localAllKeywords = ALL_KEYWORDS;
            if (localAllKeywords != null) return localAllKeywords;
            ALL_KEYWORDS = localAllKeywords = Collections.unmodifiableSet(GrammarUtil.getAllKeywords(this.grammarAccess.getGrammar()).stream().map(k -> k.toUpperCase(Locale.ENGLISH)).collect(Collectors.toSet()));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return localAllKeywords;
        }
    }
}

