/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl;

import com.google.common.collect.ImmutableMap;
import com.sap.cloud.security.ams.dcl.DCLType;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.AnnotatedElement;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Annotation;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Constant;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.DataType;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Expression;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionArray;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionBoolean;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionCall;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionConstant;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionIdentifier;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionSpecialValue;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.ExpressionString;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.FunctionDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyDefinition;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.PolicyDocument;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.RoleRule;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.Rule;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaAttribute;
import com.sap.cloud.security.ams.dcl.dataControlLanguage.SchemaType;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerParameter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.LineAndColumn;

public class DCLTools {
    public static final String DCL = "$dcl";
    public static final String APP = "$app";
    public static final String ENV = "$env";
    public static final String DCL_ACTION = "action";
    public static final String DCL_RESOURCE = "resource";
    public static final String DCL_PRINCIPAL_2_POLICIES = "principal2policies";
    public static final String DCL_POLICIES = "policies";
    public static final String DCL_TENANT = "tenant";
    public static final String DCL_SCOPE_FILTER = "scopeFilter";
    public static final Set<String> RESERVED_SECTIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("$cas", "$dcl", "$app", "$env")));
    public static final Set<String> ALLOWED_SECTIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("$user")));
    public static final String DATA_PRINCIPAL_2_POLICIES = "principal2policies";
    public static final Class<Map<String, Map<String, List<String>>>> DATA_PRINCIPAL_2_POLICIES_TYPE = Map.class;
    public static final String TEST_SUFFIX = "_test";
    public static final char DCL_SEPATATOR_CHAR = '.';
    public static final String DCL_SEGMENT = "_dcl_";
    public static final String DCR_PACKAGE = "dcr";
    public static final String DCR_DEFAULT_PACKAGE = "dcr._default_";
    public static final String DCL_FILE_EXTENSION = "dcl";
    public static final String DCL_SUFFIX = ".dcl";
    public static final int DCL_SUFFIX_LENGTH = ".dcl".length();
    public static final String DCL_SCHEMA_NAME = "schema";
    public static final String DCL_SUFFIX_TEST = "_test.dcl";
    public static final String DCL_SCHEMA_FILE = "schema.dcl";
    public static final String DCN_SCHEMA_FILE = "schema.dcn";
    public static final QualifiedName QN_ROOT_SCHEMA = QualifiedName.create("schema");
    public static final String DCN_FILE_EXTENSION = "dcn";
    public static final String DCN_SUFFIX = ".dcn";
    public static final String DCN_SUFFIX_TEST = "_test.dcn";
    public static final String DCL_RESULT_SUFFIX = ".issues";
    public static final String DCL_SINGLE_RESULT_FILE = "_dcl_.result";
    public static final String REGO_SUFFIX = ".rego";
    public static final String REGO_SUFFIX_TEST = "_dcl_test.rego";
    public static final String JSON_SUFFIX = ".json";
    public static final String JSON_DATA_FILE = "data.json";
    public static final String DCL_API_FILE = "_dcl_api.dcl";
    public static final String REGO_API_FILE = "_dcl_api.rego";
    public static final String REGO_DISP_FILE = "_dcl_disp.rego";
    public static final String LOCAL_PACKAGE = "local";
    public static final Map<String, DataType> KNOWN_ANNOTATIONS;
    public static final List<String> KNOWN_ANNOTATIONS_NAMES;
    public static final String ANNOTATION_DESCRIPTION = "description";
    public static final String ANNOTATION_LABEL = "label";
    public static final String ANNOTATION_DEFAULT = "default";
    public static final String ANNOTATION_INTERNAL = "internal";
    public static final String ANNOTATION_TEST_COMPARISON = "comparison";

    static {
        ImmutableMap.Builder<String, DataType> builder = new ImmutableMap.Builder<String, DataType>().put(ANNOTATION_DESCRIPTION, DataType.DT_STRING).put(ANNOTATION_LABEL, DataType.DT_STRING);
        KNOWN_ANNOTATIONS = builder.build();
        ArrayList<String> l = new ArrayList<String>(KNOWN_ANNOTATIONS.keySet());
        l.sort(String::compareToIgnoreCase);
        KNOWN_ANNOTATIONS_NAMES = Collections.unmodifiableList(l);
    }

    private DCLTools() {
    }

    public static boolean hasContent(Object[] collection) {
        return collection != null && collection.length > 0;
    }

    public static boolean isEmpty(Object[] collection) {
        return collection == null || collection.length == 0;
    }

    public static boolean hasContent(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean hasContent(String string) {
        return string != null && !string.isEmpty();
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean hasContent(Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(QualifiedName qualifiedName) {
        return qualifiedName == null || qualifiedName.isEmpty();
    }

    public static String emptify(String name) {
        return name == null || name.isEmpty() ? "" : name;
    }

    public static int count(List<?> list) {
        return list == null ? 0 : list.size();
    }

    public static String changeSuffix(String name, String suffix) {
        if (DCLTools.isEmpty(name)) {
            throw new IllegalArgumentException("Name is empty.");
        }
        int idx = name.lastIndexOf(46);
        if (idx == -1) {
            return DCLTools.hasContent(suffix) ? name + suffix : name;
        }
        return name.substring(0, idx) + (DCLTools.hasContent(suffix) ? suffix : "");
    }

    public static <T> Set<T> updateTransitiveUsageMap(Map<T, Set<T>> cache, T root, Function<T, Iterator<? extends T>> childProvider) {
        return DCLTools.updateTransitiveUsageMap(cache, root, childProvider, null);
    }

    private static <T> Set<T> updateTransitiveUsageMap(Map<T, Set<T>> cache, T root, Function<T, Iterator<? extends T>> childProvider, List<T> stack) {
        int idx;
        Set<T> state = cache.get(root);
        if (state == null) {
            state = new HashSet<T>();
            cache.put(root, state);
            if (stack == null) {
                stack = new ArrayList<T>();
            }
            stack.add(root);
            Iterator<T> it = childProvider.apply(root);
            while (it.hasNext()) {
                T child = it.next();
                if (!state.add(child)) continue;
                DCLTools.updateTransitiveUsageMap(cache, child, childProvider, stack);
            }
            stack.remove(stack.size() - 1);
        } else if (stack != null && (idx = stack.indexOf(root)) != -1) {
            int i = idx + 1;
            while (i < stack.size()) {
                T f = stack.get(i);
                Set<T> siblingSet = cache.get(f);
                if (state != siblingSet) {
                    state.addAll(siblingSet);
                    cache.put(f, state);
                }
                ++i;
            }
        }
        return state;
    }

    public static boolean isDeny(Rule rule) {
        return false;
    }

    public static boolean isDeny(RoleRule rule) {
        return false;
    }

    public static boolean hasRule(PolicyDefinition pd, boolean isdeny) {
        if (isdeny) {
            return false;
        }
        return !pd.getRules().isEmpty() && !pd.getRoleRules().isEmpty();
    }

    public static DCLType getExpressionType(SchemaAttribute it) {
        if (it == null || it.eIsProxy()) {
            return DCLType.UNRESOLVED;
        }
        SchemaType type = it.getType();
        if (type == null) {
            return DCLType.UNRESOLVED;
        }
        if (type.getNested() != null) {
            return DCLType.Structure;
        }
        return DCLType.fromDataType(type.getDataType(), type.isArray());
    }

    public static DCLType getExpressionType(Expression it) {
        if (it == null) {
            return DCLType.UNRESOLVED;
        }
        switch (it.eClass().getClassifierID()) {
            case 19: {
                ExpressionIdentifier identifier = (ExpressionIdentifier)it;
                return DCLTools.getExpressionType(identifier.getSchemaAttribute());
            }
            case 20: {
                return DCLType.Structure;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                return DCLType.Boolean;
            }
            case 39: {
                FunctionDefinition fd = ((ExpressionCall)it).getLeft();
                return fd == null || fd.eIsProxy() ? DCLType.UNRESOLVED : DCLType.fromDataType(fd.getDataType(), fd.isArray());
            }
            case 23: {
                EList<Constant> values = ((ExpressionArray)it).getValues();
                return values.isEmpty() ? DCLType.EmptyArray : DCLTools.getExpressionType((Expression)values.get(0)).getArrayType();
            }
            case 40: {
                return DCLType.Number;
            }
            case 41: {
                return DCLType.String;
            }
            case 42: {
                return DCLType.Boolean;
            }
            case 43: {
                return DCLType.Null;
            }
            case 44: {
                String sv = ((ExpressionSpecialValue)it).getValue().toUpperCase(Locale.US);
                return sv.equals("IGNORE") ? DCLType.IGNORE : DCLType.UNKNOWN;
            }
        }
        return DCLType.UNRESOLVED;
    }

    public static <T> T firstOfResource(Resource res, Class<T> clazz) {
        EList<EObject> contents = res.getContents();
        if (DCLTools.isEmpty(contents)) {
            return null;
        }
        EObject first = (EObject)contents.get(0);
        return clazz.isInstance(first) ? (T)clazz.cast(first) : null;
    }

    public static PolicyDocument getPolicyDocument(Resource resource) {
        return DCLTools.firstOfResource(resource, PolicyDocument.class);
    }

    public static Writer createUTF8FileWriter(File file) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
    }

    public static Reader createUTF8FileReader(File file) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
    }

    public static List<String> readFileAsList(File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader reader = new BufferedReader(DCLTools.createUTF8FileReader(file));){
            String s;
            ArrayList<String> lines = new ArrayList<String>();
            while ((s = reader.readLine()) != null) {
                lines.add(s);
            }
            return lines;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static final String normalizeToForwardSlash(String data) {
        return File.separatorChar != '/' ? data.replace(File.separatorChar, '/') : data;
    }

    public static final String normalizeToFileSeparatorSlash(String data) {
        return File.separatorChar == '/' ? data.replace('\\', '/') : data.replace('/', '\\');
    }

    public static Annotation getFirstAnnotation(AnnotatedElement element, String name) {
        EList<Annotation> annotations = element.getAnnotations();
        if (DCLTools.hasContent(annotations)) {
            for (Annotation a : annotations) {
                if (!name.equalsIgnoreCase(a.getId())) continue;
                return a;
            }
        }
        return null;
    }

    public static String getFirstStringAnnotation(AnnotatedElement element, String name) {
        Annotation ann = DCLTools.getFirstAnnotation(element, name);
        if (ann != null && ann.getValue() instanceof ExpressionString) {
            ExpressionString es = (ExpressionString)ann.getValue();
            return es.getValue();
        }
        return null;
    }

    private static boolean isBooleanAnnotationValue(AnnotatedElement element, String name, boolean missing, boolean empty) {
        Annotation a = DCLTools.getFirstAnnotation(element, name);
        if (a == null) {
            return missing;
        }
        ExpressionConstant v = a.getValue();
        if (v == null) {
            return empty;
        }
        if (v instanceof ExpressionBoolean) {
            return ((ExpressionBoolean)v).isValue();
        }
        return false;
    }

    public static boolean isBooleanAnnotation(AnnotatedElement element, String name) {
        return DCLTools.isBooleanAnnotationValue(element, name, false, true);
    }

    public static boolean isInternal(FunctionDefinition fd) {
        return fd.isInternal() || DCLTools.isBooleanAnnotation(fd, ANNOTATION_INTERNAL);
    }

    public static boolean isInternal(PolicyDefinition pd) {
        return pd.isInternal() || DCLTools.isBooleanAnnotation(pd, ANNOTATION_INTERNAL);
    }

    public static boolean isDefault(PolicyDefinition pd) {
        return pd.isDefault() || DCLTools.isBooleanAnnotationValue(pd, ANNOTATION_DEFAULT, false, false);
    }

    public static boolean isSimpleRegoExpression(Expression e) {
        switch (e.eClass().getClassifierID()) {
            case 17: 
            case 19: {
                return true;
            }
            case 39: {
                return DCLTools.isSimpleRegoExpression(((ExpressionCall)e).getLeft().getResult());
            }
        }
        return false;
    }

    public static String getSourceFile(DCLCompilerParameter cp, Resource resource) {
        try {
            return cp.toRelativeSourcePath(resource);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static int[] getSourcePosition(EObject obj) {
        try {
            ICompositeNode rootNode;
            ICompositeNode cn = NodeModelUtils.getNode(obj);
            if (cn != null && (rootNode = cn.getRootNode()) != null) {
                int offsetS = cn.getOffset();
                int offsetE = cn.getEndOffset();
                LineAndColumn lcS = NodeModelUtils.getLineAndColumn(rootNode, offsetS);
                LineAndColumn lcE = NodeModelUtils.getLineAndColumn(rootNode, offsetE);
                int[] coordinates = new int[]{lcS.getLine(), lcS.getColumn(), lcE.getLine(), lcE.getColumn()};
                return coordinates;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return null;
    }

    public static boolean startsWithLocal(QualifiedName qn) {
        return qn.getSegmentCount() >= 1 && qn.getFirstSegment().equals(LOCAL_PACKAGE);
    }
}

