/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl;

import com.sap.cloud.security.ams.dcl.dataControlLanguage.DataType;

public enum DCLType {
    BooleanArray("Boolean[]"),
    Boolean(BooleanArray),
    NumberArray("Number[]"),
    Number(NumberArray),
    StringArray("String[]"),
    String(StringArray),
    Structure(true),
    EmptyArray("[]", false),
    Null,
    UNRESOLVED,
    UNKNOWN,
    IGNORE;

    private final DCLType arrayType;
    private final boolean isArray;
    private final String text;
    private final boolean isSchemaType;

    private DCLType(boolean isSchemaType) {
        this.text = null;
        this.isArray = false;
        this.arrayType = this;
        this.isSchemaType = isSchemaType;
    }

    private DCLType() {
        this(false);
    }

    private DCLType(String text, boolean isSchemaType) {
        this.text = text;
        this.isArray = true;
        this.arrayType = this;
        this.isSchemaType = isSchemaType;
    }

    private DCLType(String text) {
        this(text, true);
    }

    private DCLType(DCLType arrayType) {
        this.text = null;
        this.isArray = false;
        this.arrayType = arrayType == null ? this : arrayType;
        this.isSchemaType = true;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public DCLType getArrayType() {
        return this.arrayType;
    }

    public boolean isSchemaType() {
        return this.isSchemaType;
    }

    public String toString() {
        return this.text != null ? this.text : this.name();
    }

    public static DCLType fromDataType(DataType dataType, boolean isArray) {
        if (dataType == null) {
            return UNRESOLVED;
        }
        switch (dataType.getValue()) {
            case 2: {
                return isArray ? BooleanArray : Boolean;
            }
            case 1: {
                return isArray ? NumberArray : Number;
            }
            case 0: {
                return isArray ? StringArray : String;
            }
        }
        return UNRESOLVED;
    }
}

