/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.sap.cloud.security.ams.dcl.AbstractDataControlLanguageRuntimeModule;
import com.sap.cloud.security.ams.dcl.DCLDeclarativeQualifiedNameProvider;
import com.sap.cloud.security.ams.dcl.DCLDerivedStateAwareResource;
import com.sap.cloud.security.ams.dcl.DCLDerivedStateComputer;
import com.sap.cloud.security.ams.dcl.DCLLineSeparatorHarmonizer;
import com.sap.cloud.security.ams.dcl.DCLLinkingDiagnosticMessageProvider;
import com.sap.cloud.security.ams.dcl.DCLLinkingService;
import com.sap.cloud.security.ams.dcl.DCLMtTools;
import com.sap.cloud.security.ams.dcl.DCLOutputConfigurationProvider;
import com.sap.cloud.security.ams.dcl.DCLQualifiedNameConverter;
import com.sap.cloud.security.ams.dcl.DCLResourceDescriptionStrategy;
import com.sap.cloud.security.ams.dcl.DCLShouldGenerate;
import com.sap.cloud.security.ams.dcl.DCLStateBasedContainerManager;
import com.sap.cloud.security.ams.dcl.DCLSyntaxErrorMessageProvider;
import com.sap.cloud.security.ams.dcl.OnChangeEvictingCacheSmall;
import com.sap.cloud.security.ams.dcl.generator.DCLCompilerResultAccessor;
import com.sap.cloud.security.ams.dcl.scoping.DCLSimpleLocalScopeProvider;
import com.sap.cloud.security.ams.dcl.support.validation.CachingResourceValidatorImpl;
import com.sap.cloud.security.ams.dcl.support.validation.DCLEValidatorEqualitySupport;
import com.sap.cloud.security.ams.dcl.valueconverter.DCLIdValueConverter;
import com.sap.cloud.security.ams.dcl.valueconverter.DCLTerminalConverters;
import com.sap.cloud.security.ams.dcl.valueconverter.SingleQuotedStringConverter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.impl.AbstractIDValueConverter;
import org.eclipse.xtext.conversion.impl.STRINGValueConverter;
import org.eclipse.xtext.generator.IContextualOutputConfigurationProvider;
import org.eclipse.xtext.generator.IContextualOutputConfigurationProvider2;
import org.eclipse.xtext.generator.IOutputConfigurationProvider;
import org.eclipse.xtext.generator.IShouldGenerate;
import org.eclipse.xtext.generator.LineSeparatorHarmonizer;
import org.eclipse.xtext.linking.ILinkingDiagnosticMessageProvider;
import org.eclipse.xtext.linking.ILinkingService;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.parser.antlr.ISyntaxErrorMessageProvider;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.resource.IDerivedStateComputer;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.util.OnChangeEvictingCache;
import org.eclipse.xtext.validation.CompositeEValidator;
import org.eclipse.xtext.validation.IResourceValidator;

public class DataControlLanguageRuntimeModule
extends AbstractDataControlLanguageRuntimeModule {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String ENCODING = System.getProperty("com.sap.cloud.security.ams.dcl.file.encoding", "UTF-8");

    public Class<? extends IDerivedStateComputer> bindIDerivedStateComputer() {
        return DCLDerivedStateComputer.class;
    }

    @Override
    public Class<? extends XtextResource> bindXtextResource() {
        return DCLDerivedStateAwareResource.class;
    }

    public Class<? extends IResourceValidator> bindIResourceValidator() {
        return CachingResourceValidatorImpl.class;
    }

    @Provides
    public CompositeEValidator.EValidatorEqualitySupport getEValidatorEqualitySupport(Injector injector) {
        return injector.getInstance(DCLEValidatorEqualitySupport.class);
    }

    public Class<? extends IDefaultResourceDescriptionStrategy> bindIDefaultResourceDescriptionStrategy() {
        return DCLResourceDescriptionStrategy.class;
    }

    @Override
    public void configureIScopeProviderDelegate(Binder binder) {
        binder.bind(IScopeProvider.class).annotatedWith(Names.named("org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider.delegate")).to(DCLSimpleLocalScopeProvider.class);
    }

    @Override
    public Class<? extends AbstractIDValueConverter> bindAbstractIDValueConverter() {
        return DCLIdValueConverter.class;
    }

    @Override
    public Class<? extends IValueConverterService> bindIValueConverterService() {
        return DCLTerminalConverters.class;
    }

    public Class<? extends IQualifiedNameConverter> bindIQualifiedNameConverter() {
        return DCLQualifiedNameConverter.class;
    }

    @Override
    public Class<? extends ILinkingService> bindILinkingService() {
        return DCLLinkingService.class;
    }

    @Provides
    @Named(value="isMultiTenant")
    public boolean isMultitenancy(DCLCompilerResultAccessor cra) {
        return DCLMtTools.isMtSupport(cra);
    }

    @Override
    public void configure(Binder binder) {
        super.configure(binder);
        binder.bind(IOutputConfigurationProvider.class).to(DCLOutputConfigurationProvider.class);
        binder.bind(IContextualOutputConfigurationProvider.class).to(DCLOutputConfigurationProvider.class);
        binder.bind(IContextualOutputConfigurationProvider2.class).to(DCLOutputConfigurationProvider.class);
        binder.bind(STRINGValueConverter.class).to(SingleQuotedStringConverter.class);
        binder.bind(IResourceScopeCache.class).to(OnChangeEvictingCacheSmall.class);
        binder.bind(OnChangeEvictingCache.class).to(OnChangeEvictingCacheSmall.class);
    }

    @Override
    public Class<? extends IQualifiedNameProvider> bindIQualifiedNameProvider() {
        return DCLDeclarativeQualifiedNameProvider.class;
    }

    public Class<? extends ISyntaxErrorMessageProvider> bindISyntaxErrorMessageProvider() {
        return DCLSyntaxErrorMessageProvider.class;
    }

    public Class<? extends ILinkingDiagnosticMessageProvider.Extended> bindILinkingDiagnosticMessageProvider() {
        return DCLLinkingDiagnosticMessageProvider.class;
    }

    @Override
    public Class<? extends IEncodingProvider.Runtime> bindRuntimeEncodingProvider() {
        return DCLEncodingProviderRuntime.class;
    }

    @Override
    public Class<? extends IContainer.Manager> bindIContainer$Manager() {
        return DCLStateBasedContainerManager.class;
    }

    public Class<? extends IShouldGenerate> bindIShouldGenerate() {
        return DCLShouldGenerate.class;
    }

    public Class<? extends LineSeparatorHarmonizer> bindLineSeparatorHarmonizer() {
        return DCLLineSeparatorHarmonizer.class;
    }

    public static class DCLEncodingProviderRuntime
    extends IEncodingProvider.Runtime {
        @Override
        public String getEncoding(URI uri) {
            return ENCODING;
        }
    }
}

