/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl;

import com.google.inject.Singleton;
import com.sap.cloud.security.ams.dcl.DCLStringProcessing;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;

@Singleton
public class LikeGlobConverter {
    private static final String GLOB_BASE_PATTERN = "[" + Pattern.quote("%_*?[{") + "]";
    private static final Pattern GLOB_ESCAPE_PATTERN = Pattern.compile("(" + GLOB_BASE_PATTERN + ")");
    private ConcurrentMap<String, Pattern> GLOB_ESCAPE_PATTERN_MAP = new ConcurrentHashMap<String, Pattern>();

    private Pattern getGLOBEscapePattern(String escape) {
        if (escape == null || escape.length() != 1) {
            return GLOB_ESCAPE_PATTERN;
        }
        return this.GLOB_ESCAPE_PATTERN_MAP.computeIfAbsent(escape, e -> Pattern.compile("((" + Pattern.quote(escape) + "[%_])|(" + GLOB_BASE_PATTERN + "))"));
    }

    public String toPattern(String pattern) {
        return this.toPattern(pattern, null);
    }

    public String toPattern(String pattern, String escape) {
        return DCLStringProcessing.replaceAllPlain(this.getGLOBEscapePattern(escape), pattern, rm -> {
            String match = rm.group();
            if (match.length() > 1) {
                return match.endsWith("%") ? "%" : "_";
            }
            switch (match.charAt(0)) {
                case '%': {
                    return "*";
                }
                case '_': {
                    return "?";
                }
            }
            return "\\\\" + match;
        });
    }
}

