/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl;

import com.google.inject.Singleton;
import com.sap.cloud.security.ams.dcl.DCLStringProcessing;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;

@Singleton
public class LikeRegexConverter {
    private static final String REGEX_BASE_PATTERN = "[" + Pattern.quote("[%_\\^$.|?*+(){}") + "]";
    private static final Pattern REGEX_ESCAPE_PATTERN = Pattern.compile("(" + REGEX_BASE_PATTERN + ")");
    private ConcurrentMap<String, Pattern> REGEX_ESCAPE_PATTERN_MAP = new ConcurrentHashMap<String, Pattern>();

    private Pattern getREEscapePattern(String escape) {
        if (escape == null || escape.length() != 1) {
            return REGEX_ESCAPE_PATTERN;
        }
        return this.REGEX_ESCAPE_PATTERN_MAP.computeIfAbsent(escape, e -> Pattern.compile("((" + Pattern.quote(escape) + "[%_])|(" + REGEX_BASE_PATTERN + "))"));
    }

    public String toPattern(String pattern) {
        return this.toPattern(pattern, null);
    }

    public String toPattern(String pattern, String escape) {
        return DCLStringProcessing.replaceAllPlain(this.getREEscapePattern(escape), pattern, rm -> {
            String match = rm.group();
            if (match.length() > 1) {
                return match.endsWith("%") ? "%" : "_";
            }
            switch (match.charAt(0)) {
                case '%': {
                    return ".*";
                }
                case '_': {
                    return ".";
                }
                case '\\': {
                    return "\\\\\\\\";
                }
                case '$': {
                    return "\\\\\\$";
                }
            }
            return "\\\\" + match;
        });
    }
}

