/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl;

import com.google.common.collect.ImmutableList;
import com.sap.cloud.security.ams.dcl.DCLTools;
import com.sap.cloud.security.ams.dcl.client.el.QualifiedName;
import com.sap.cloud.security.ams.dcl.client.language.DataControlLanguageTools;
import com.sap.cloud.security.ams.dcl.validation.DCLIssue;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.URI;

public final class ResourceLocation {
    private final URI uri;
    private final String path;
    private final String relativeDocumentName;
    private final DCLIssue issue;
    private final String message;
    private final String documentName;
    private final String relativePath;
    private String dclPath;
    private List<String> pathList;
    private org.eclipse.xtext.naming.QualifiedName pathQName;
    private QualifiedName pathQNameDCL;

    public ResourceLocation(URI uri, DCLIssue issue, Object ... args) {
        this.uri = uri;
        this.path = null;
        this.issue = issue;
        this.message = issue.format(args);
        this.relativeDocumentName = null;
        this.documentName = null;
        this.relativePath = null;
    }

    public ResourceLocation(URI uri, String path, String name) {
        this.uri = uri;
        this.path = path;
        this.issue = null;
        this.message = null;
        this.relativeDocumentName = name;
        int idx = name.lastIndexOf(47);
        if (idx == -1) {
            this.documentName = name;
            this.relativePath = "";
        } else {
            this.documentName = name.substring(idx + 1);
            this.relativePath = name.substring(0, idx);
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public String getPath() {
        return this.path;
    }

    public String getMessage() {
        return this.message;
    }

    public DCLIssue getIssue() {
        return this.issue;
    }

    public boolean hasIssue() {
        return this.issue != null;
    }

    public boolean isValid() {
        return this.issue == null;
    }

    public String getRelativeDocumentName() {
        return this.relativeDocumentName;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getDclPackage() {
        return this.getFullQualifiedDclName(null);
    }

    public String getFullQualifiedDclName(String name) {
        if (this.path != null && this.dclPath == null) {
            this.dclPath = this.path.replace('/', '.');
        }
        if (name == null) {
            return this.dclPath;
        }
        if (this.dclPath == null) {
            return name;
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.dclPath);
        sb.append('.');
        DataControlLanguageTools.appendQuotedString(sb, name, true);
        return sb.toString();
    }

    private void grantPathList() {
        if (this.pathList == null) {
            this.pathList = DCLTools.hasContent(this.path) ? ImmutableList.copyOf(this.path.split("/")) : ImmutableList.of();
        }
    }

    public boolean isSamePackage(org.eclipse.xtext.naming.QualifiedName qname) {
        this.grantPathList();
        int size = this.pathList.size();
        if (qname.getSegmentCount() != size + 1) {
            return false;
        }
        int idx = 0;
        while (idx < size) {
            if (!Objects.equals(qname.getSegment(idx), this.pathList.get(idx))) {
                return false;
            }
            ++idx;
        }
        return true;
    }

    public List<String> getFullQualifiedDCLArray(String name) {
        this.grantPathList();
        if (name == null) {
            return this.pathList;
        }
        if (this.pathList.isEmpty()) {
            return ImmutableList.of(name);
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize(this.pathList.size() + 1);
        builder.addAll(this.pathList);
        builder.add(name);
        return builder.build();
    }

    public org.eclipse.xtext.naming.QualifiedName getQualifiedName() {
        if (this.pathQName == null) {
            this.grantPathList();
            this.pathQName = org.eclipse.xtext.naming.QualifiedName.create(this.pathList);
        }
        return this.pathQName;
    }

    public org.eclipse.xtext.naming.QualifiedName getQualifiedName(String name) {
        return this.getQualifiedName().append(name);
    }

    public QualifiedName getDclQualifiedName() {
        if (this.pathQNameDCL == null) {
            this.grantPathList();
            this.pathQNameDCL = QualifiedName.create(this.pathList);
        }
        return this.pathQNameDCL;
    }

    public QualifiedName getDclQualifiedName(String name) {
        return DCLTools.isEmpty(name) ? this.getDclQualifiedName() : (QualifiedName)this.getDclQualifiedName().append(name);
    }

    public org.eclipse.xtext.naming.QualifiedName getSchemaQualifiedName() {
        return this.getQualifiedName("schema");
    }

    public boolean isInLocalPackage() {
        return DCLTools.startsWithLocal(this.getQualifiedName());
    }
}

