/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl;

import com.sap.cloud.security.ams.dcl.DCLResourceHelper;
import com.sap.cloud.security.ams.dcl.ResourceLocation;
import java.util.Objects;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;

class ResourceLocationAdapter
extends AdapterImpl {
    private final DCLResourceHelper rh;
    private final Resource resource;
    private ResourceLocation resourceLocation;

    private ResourceLocationAdapter(DCLResourceHelper rh, Resource resource) {
        this.rh = rh;
        this.resource = resource;
    }

    public static ResourceLocationAdapter grantResourceLocationAdapter(DCLResourceHelper rh, Resource resource) {
        EList<Adapter> eAdapters = resource.eAdapters();
        ResourceLocationAdapter adapter = (ResourceLocationAdapter)EcoreUtil.getAdapter(eAdapters, ResourceLocationAdapter.class);
        if (adapter == null) {
            adapter = new ResourceLocationAdapter(rh, resource);
            eAdapters.add(adapter);
        }
        return adapter;
    }

    @Override
    public boolean isAdapterForType(Object type) {
        return ResourceLocationAdapter.class.equals(type);
    }

    public ResourceLocation getResourceLocation() {
        ResourceLocation resLocation = this.resourceLocation;
        if (resLocation == null || !Objects.equals(this.resource.getURI(), resLocation.getURI())) {
            this.resourceLocation = resLocation = this.rh.createResourceLocation(this.resource);
        }
        return resLocation;
    }
}

