/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.commons;

import java.util.Objects;

public final class Parameter<T> {
    private final Class<T> type;
    private final String name;
    private final String scopedName;
    private final boolean isDefault;
    private final T value;
    private final T defaultValue;
    private final int hash;
    public static final PropertyScope EMPTY_PROPERTY_SCOPE = new PropertyScope("");

    Parameter(Class<T> type, String name, String scopedName, boolean isDefault, T value, T defaultValue) {
        this.type = Objects.requireNonNull(type);
        this.name = Parameter.checkForName(name, "name");
        this.scopedName = Parameter.checkForName(scopedName, "scopedName");
        this.isDefault = isDefault;
        this.value = value;
        this.defaultValue = defaultValue;
        this.hash = Objects.hash(type, name, isDefault, value, defaultValue);
    }

    Parameter(Class<T> type, String name, boolean isDefault, T value, T defaultValue) {
        this(type, name, name, isDefault, value, defaultValue);
    }

    Parameter(Class<T> type, String name, T value) {
        this(type, name, true, value, value);
    }

    public Class<T> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getScopedName() {
        return this.scopedName;
    }

    public T getValue() {
        return this.value;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String toString() {
        return "Parameter [type=" + this.type + ", name=" + this.name + ", isDefault=" + this.isDefault + ", value=" + this.value + ", defaultValue=" + this.defaultValue + "]";
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Parameter other = (Parameter)obj;
        return this.hash == other.hash && this.isDefault == other.isDefault && Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.value, other.value) && Objects.equals(this.defaultValue, other.defaultValue);
    }

    static String checkForName(String value, String valueName) {
        if (Parameter.isEmpty(value)) {
            throw new IllegalArgumentException(valueName + " must not be null or empty");
        }
        return value;
    }

    static boolean isEmpty(String data) {
        return data == null || data.isEmpty();
    }

    public static Parameter<Boolean> create(String name, boolean value) {
        return new Parameter<Boolean>(Boolean.class, name, value);
    }

    public static Parameter<Integer> create(String name, int value) {
        return new Parameter<Integer>(Integer.class, name, value);
    }

    public static Parameter<Long> create(String name, long value) {
        return new Parameter<Long>(Long.class, name, value);
    }

    public static Parameter<Float> create(String name, float value) {
        return new Parameter<Float>(Float.class, name, Float.valueOf(value));
    }

    public static Parameter<Double> create(String name, double value) {
        return new Parameter<Double>(Double.class, name, value);
    }

    public static Parameter<String> create(String name, String value) {
        return new Parameter<String>(String.class, name, value);
    }

    public static <K> Parameter<K> create(Class<K> clazz, String name) {
        return Parameter.create(clazz, name, null);
    }

    public static <K> Parameter<K> create(Class<K> clazz, String name, K defaultValue) {
        return new Parameter<K>(clazz, name, defaultValue);
    }

    public static PropertyScope propertyScope() {
        return EMPTY_PROPERTY_SCOPE;
    }

    public static PropertyScope propertyScope(String scope) {
        return Parameter.isEmpty(scope) ? EMPTY_PROPERTY_SCOPE : new PropertyScope(scope);
    }

    public static PropertyScope propertyScope(String base, String client) {
        Parameter.checkForName(client, "client");
        return new PropertyScope((String)(Parameter.isEmpty(base) ? client : base + "." + client));
    }

    public static final class PropertyScope {
        private final String scope;

        PropertyScope(String scope) {
            this.scope = Objects.requireNonNull(scope);
        }

        public Parameter<Boolean> create(String name, boolean defaultValue) {
            return PropertyScope.createfromProperty(Boolean.class, this.scope, name, defaultValue, Boolean::parseBoolean);
        }

        public Parameter<Integer> create(String name, int defaultValue) {
            return PropertyScope.createfromProperty(Integer.class, this.scope, name, defaultValue, Integer::parseInt);
        }

        public Parameter<Long> create(String name, long defaultValue) {
            return PropertyScope.createfromProperty(Long.class, this.scope, name, defaultValue, Long::parseLong);
        }

        public Parameter<Float> create(String name, float defaultValue) {
            return PropertyScope.createfromProperty(Float.class, this.scope, name, Float.valueOf(defaultValue), Float::parseFloat);
        }

        public Parameter<Double> create(String name, double defaultValue) {
            return PropertyScope.createfromProperty(Double.class, this.scope, name, defaultValue, Double::parseDouble);
        }

        public Parameter<String> create(String name, String defaultValue) {
            return PropertyScope.createfromProperty(String.class, this.scope, name, defaultValue, value -> value);
        }

        public <T> Parameter<T> create(Class<T> type, String name, T defaultValue, StringParser<T> parser) {
            return PropertyScope.createfromProperty(type, this.scope, name, defaultValue, parser);
        }

        public String getScope() {
            return this.scope;
        }

        public String toString() {
            return "PropertyScope [scope=" + this.scope + "]";
        }

        public int hashCode() {
            return Objects.hash(this.scope);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyScope other = (PropertyScope)obj;
            return Objects.equals(this.scope, other.scope);
        }

        private static <T> Parameter<T> createfromProperty(Class<T> type, String scope, String name, T defaultValue, StringParser<T> parser) {
            Objects.requireNonNull(type);
            Objects.requireNonNull(parser);
            Parameter.checkForName(name, "name");
            String scopedName = Parameter.isEmpty(scope) ? name : scope + "." + name;
            boolean isDefault = true;
            T value = defaultValue;
            String data = System.getenv(scopedName);
            if (data != null) {
                try {
                    value = parser.apply(data);
                    isDefault = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((data = System.getProperty(scopedName)) != null) {
                try {
                    value = parser.apply(data);
                    isDefault = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new Parameter<T>(type, name, scopedName, isDefault, value, defaultValue);
        }

        @FunctionalInterface
        public static interface StringParser<R> {
            public R apply(String var1) throws Exception;
        }
    }
}

