/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.dcn;

import com.sap.cloud.security.ams.dcl.client.annotation.Beta;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Beta
public enum DataType {
    BooleanArray("Boolean[]"),
    Boolean("Boolean"),
    NumberArray("Number[]"),
    Number("Number"),
    StringArray("String[]"),
    String("String"),
    Structure("Structure");

    private final String text;

    private DataType(String text) {
        this.text = Objects.requireNonNull(text);
    }

    public String getText() {
        return this.text;
    }

    public static DataType lookup(String text) {
        DataType res = Helper.REVERSE_MAPPING.get(text);
        if (res == null) {
            throw new IllegalArgumentException("No existing SchemaAttributeType serializes as: " + text);
        }
        return res;
    }

    private static class Helper {
        static final Map<String, DataType> REVERSE_MAPPING = new HashMap<String, DataType>();

        private Helper() {
        }

        static {
            for (DataType sat : DataType.values()) {
                REVERSE_MAPPING.put(sat.getText(), sat);
            }
        }
    }
}

