/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.dcn;

import com.sap.cloud.security.ams.dcl.client.annotation.Beta;
import com.sap.cloud.security.ams.dcl.client.dcn.Annotated;
import com.sap.cloud.security.ams.dcl.client.dcn.DataType;
import com.sap.cloud.security.ams.dcl.client.dcn.DcnSchemaBuilder;
import com.sap.cloud.security.ams.dcl.client.dcn.DcnSchemaBuilderImpl;
import com.sap.cloud.security.ams.dcl.client.dcn.Effect;
import com.sap.cloud.security.ams.dcl.client.dcn.Function;
import com.sap.cloud.security.ams.dcl.client.dcn.Policy;
import com.sap.cloud.security.ams.dcl.client.dcn.PolicyMember;
import com.sap.cloud.security.ams.dcl.client.dcn.Rule;
import com.sap.cloud.security.ams.dcl.client.dcn.Use;
import com.sap.cloud.security.ams.dcl.client.el.AttributeName;
import com.sap.cloud.security.ams.dcl.client.el.Call;
import com.sap.cloud.security.ams.dcl.client.el.QualifiedName;
import com.sap.cloud.security.ams.dcl.client.el.QualifiedNamesBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Beta
public final class DcnBuilder {
    public static final String STAR = null;
    private static final List<String> SCOPES_AS_LIST = DcnBuilder.asSingletonList("$SCOPES");
    private static final PolicyMember[] EMPTY_POLICY_MEMBER_ARRAY = new PolicyMember[0];

    private DcnBuilder() {
    }

    public static QualifiedName q(String name) {
        return QualifiedNamesBuilder.globalParseQualifiedName(Objects.requireNonNull(name));
    }

    public static AttributeName a(String name) {
        return QualifiedNamesBuilder.globalParseAttributeName(Objects.requireNonNull(name));
    }

    public static DcnSchemaBuilder schema() {
        return new DcnSchemaBuilderImpl();
    }

    public static DcnSchemaBuilder tenantSchema(QualifiedName dclPackage, String tenant) {
        return new DcnSchemaBuilderImpl(dclPackage, tenant);
    }

    public static Rule grant(String action, String resource) {
        return DcnBuilder.grant0(DcnBuilder.asSingletonList(action), DcnBuilder.asSingletonList(resource), null);
    }

    public static Rule grant(List<String> actions, String resource) {
        return DcnBuilder.grant0(actions, DcnBuilder.asSingletonList(resource), null);
    }

    public static Rule grant(String action, List<String> resources) {
        return DcnBuilder.grant0(DcnBuilder.asSingletonList(action), resources, null);
    }

    public static Rule grant(List<String> actions, List<String> resources) {
        return DcnBuilder.grant0(actions, resources, null);
    }

    public static Rule grant(String action, String resource, Call condition) {
        return DcnBuilder.grant0(DcnBuilder.asSingletonList(action), DcnBuilder.asSingletonList(resource), condition);
    }

    public static Rule grant(List<String> actions, String resource, Call condition) {
        return DcnBuilder.grant0(actions, DcnBuilder.asSingletonList(resource), condition);
    }

    public static Rule grant(String action, List<String> resources, Call condition) {
        return DcnBuilder.grant0(DcnBuilder.asSingletonList(action), resources, condition);
    }

    public static Rule grant(List<String> actions, List<String> resources, Call condition) {
        return DcnBuilder.grant0(actions, resources, condition);
    }

    public static Rule grant(String action, String resource, boolean condition) {
        return DcnBuilder.grant0(DcnBuilder.asSingletonList(action), DcnBuilder.asSingletonList(resource), condition);
    }

    public static Rule grant(List<String> actions, String resource, boolean condition) {
        return DcnBuilder.grant0(actions, DcnBuilder.asSingletonList(resource), condition);
    }

    public static Rule grant(String action, List<String> resources, boolean condition) {
        return DcnBuilder.grant0(DcnBuilder.asSingletonList(action), resources, condition);
    }

    public static Rule grant(List<String> actions, List<String> resources, boolean condition) {
        return DcnBuilder.grant0(actions, resources, condition);
    }

    public static Rule grant(String action, String resource, AttributeName condition) {
        return DcnBuilder.grant0(DcnBuilder.asSingletonList(action), DcnBuilder.asSingletonList(resource), condition);
    }

    public static Rule grant(List<String> actions, String resource, AttributeName condition) {
        return DcnBuilder.grant0(actions, DcnBuilder.asSingletonList(resource), condition);
    }

    public static Rule grant(String action, List<String> resources, AttributeName condition) {
        return DcnBuilder.grant0(DcnBuilder.asSingletonList(action), resources, condition);
    }

    public static Rule grant(List<String> actions, List<String> resources, AttributeName condition) {
        return DcnBuilder.grant0(actions, resources, condition);
    }

    public static Rule assignRole(String role) {
        return DcnBuilder.grant0(DcnBuilder.asSingletonList(role), SCOPES_AS_LIST, null);
    }

    public static Rule assignRole(List<String> roles) {
        return DcnBuilder.grant0(roles, SCOPES_AS_LIST, null);
    }

    public static Rule assignRole(String role, Call condition) {
        return DcnBuilder.grant0(DcnBuilder.asSingletonList(role), SCOPES_AS_LIST, condition);
    }

    public static Rule assignRole(List<String> roles, Call condition) {
        return DcnBuilder.grant0(roles, SCOPES_AS_LIST, condition);
    }

    public static Rule assignRole(String role, boolean condition) {
        return DcnBuilder.grant0(DcnBuilder.asSingletonList(role), SCOPES_AS_LIST, condition);
    }

    public static Rule assignRole(List<String> roles, boolean condition) {
        return DcnBuilder.grant0(roles, SCOPES_AS_LIST, condition);
    }

    public static Rule assignRole(String role, AttributeName condition) {
        return DcnBuilder.grant0(DcnBuilder.asSingletonList(role), SCOPES_AS_LIST, condition);
    }

    public static Rule assignRole(List<String> roles, AttributeName condition) {
        return DcnBuilder.grant0(roles, SCOPES_AS_LIST, condition);
    }

    private static Rule grant0(List<String> actions, List<String> resources, Object condition) {
        DcnBuilder.expectNoEmptyStringOrNull(actions, "Action names must not be ");
        DcnBuilder.expectNoEmptyStringOrNull(resources, "Resource names must not be ");
        Rule result = new Rule();
        result.actions(actions);
        result.resources(resources);
        result.condition(condition);
        result.effect(Effect.GRANT);
        return result;
    }

    public static Policy policy(QualifiedName qualifiedName) {
        return DcnBuilder.policy(qualifiedName, EMPTY_POLICY_MEMBER_ARRAY);
    }

    public static Policy policy(QualifiedName qualifiedName, PolicyMember ... members) {
        DcnBuilder.expectPackageQualifiedName(qualifiedName);
        Policy result = new Policy();
        result.qualifiedName(qualifiedName);
        ArrayList<Use> uses = null;
        ArrayList<Rule> rules = null;
        for (PolicyMember member : members) {
            Annotated<Rule> m;
            if (member instanceof Rule) {
                m = (Rule)member;
                if (rules == null) {
                    rules = new ArrayList<Rule>();
                    result.rules(rules);
                }
                rules.add((Rule)m);
                continue;
            }
            if (member instanceof Use) {
                m = (Use)member;
                if (uses == null) {
                    uses = new ArrayList<Use>();
                    result.uses(uses);
                }
                uses.add((Use)m);
                continue;
            }
            throw new IllegalArgumentException("The following element cannot be added to a policy: " + member);
        }
        return result;
    }

    public static Policy policy(String qualifiedName) {
        return DcnBuilder.policy(DcnBuilder.q(qualifiedName));
    }

    public static Policy policy(String qualifiedName, PolicyMember ... members) {
        return DcnBuilder.policy(DcnBuilder.q(qualifiedName), members);
    }

    public static Use use(Policy policy) {
        return DcnBuilder.use(policy.qualifiedName(), (List<List<Call>>)null);
    }

    public static Use use(Policy policy, List<List<Call>> restrictionsList) {
        return DcnBuilder.use(policy.qualifiedName(), restrictionsList);
    }

    public static Use use(QualifiedName qualifiedName) {
        return DcnBuilder.use(qualifiedName, (List<List<Call>>)null);
    }

    public static Use use(QualifiedName qualifiedName, List<List<Call>> restrictionsList) {
        DcnBuilder.expectPackageQualifiedName(qualifiedName);
        Use result = new Use();
        result.qualifiedPolicyName(qualifiedName);
        result.restrictions(restrictionsList);
        return result;
    }

    public static Use use(String qualifiedName) {
        return DcnBuilder.use(DcnBuilder.q(qualifiedName), (List<List<Call>>)null);
    }

    public static Use use(String qualifiedName, List<List<Call>> restrictionsList) {
        return DcnBuilder.use(DcnBuilder.q(qualifiedName), restrictionsList);
    }

    public static Function function(QualifiedName qualifiedName, DataType returnType, Object coputation) {
        DcnBuilder.expectPackageQualifiedName(qualifiedName);
        Function result = new Function();
        result.qualifiedName(qualifiedName);
        result.result(coputation);
        result.returnType(returnType);
        return result;
    }

    public static Function function(String qualifiedName, DataType returnType, Object computation) {
        return DcnBuilder.function(DcnBuilder.q(qualifiedName), returnType, computation);
    }

    public static Call eq(Object o1, Object o2) {
        return Call.create(Call.QualifiedNames.EQ, o1, o2);
    }

    public static Call ne(Object o1, Object o2) {
        return Call.create(Call.QualifiedNames.NE, o1, o2);
    }

    public static Call lt(Object o1, Object o2) {
        return Call.create(Call.QualifiedNames.LT, o1, o2);
    }

    public static Call le(Object o1, Object o2) {
        return Call.create(Call.QualifiedNames.LE, o1, o2);
    }

    public static Call ge(Object o1, Object o2) {
        return Call.create(Call.QualifiedNames.GE, o1, o2);
    }

    public static Call gt(Object o1, Object o2) {
        return Call.create(Call.QualifiedNames.GT, o1, o2);
    }

    public static Call and(Object ... members) {
        DcnBuilder.check2(members.length, "AND");
        return Call.create(Call.QualifiedNames.AND, members);
    }

    public static Call and(Object o1, Object o2) {
        return Call.create(Call.QualifiedNames.AND, o1, o2);
    }

    public static Call and(Object o1, Object o2, Object o3) {
        return Call.create(Call.QualifiedNames.AND, o1, o2, o3);
    }

    public static Call andFrom(Collection<?> members) {
        DcnBuilder.check2(members.size(), "AND");
        return Call.createFrom(Call.QualifiedNames.AND, members);
    }

    public static Call or(Object ... members) {
        DcnBuilder.check2(members.length, "OR");
        return Call.create(Call.QualifiedNames.OR, members);
    }

    public static Call or(Object o1, Object o2) {
        return Call.create(Call.QualifiedNames.OR, o1, o2);
    }

    public static Call or(Object o1, Object o2, Object o3) {
        return Call.create(Call.QualifiedNames.OR, o1, o2, o3);
    }

    public static Call orFrom(Collection<?> members) {
        DcnBuilder.check2(members.size(), "OR");
        return Call.createFrom(Call.QualifiedNames.OR, members);
    }

    public static Call in(Object o, Collection<?> coll) {
        return Call.create(Call.QualifiedNames.IN, o, coll);
    }

    public static Call notIn(Object o, Collection<Object> coll) {
        return Call.create(Call.QualifiedNames.NOT_IN, o, coll);
    }

    public static Call isNull(AttributeName att) {
        return Call.create(Call.QualifiedNames.IS_NULL, (Object)att);
    }

    public static Call isNotNull(AttributeName att) {
        return Call.create(Call.QualifiedNames.IS_NOT_NULL, (Object)att);
    }

    public static Call like(Object value, String pattern) {
        return Call.create(Call.QualifiedNames.LIKE, value, (Object)pattern);
    }

    public static Call like(Object value, String pattern, String escape) {
        return Call.create(Call.QualifiedNames.LIKE, value, (Object)pattern, (Object)escape);
    }

    public static Call notLike(Object value, String pattern) {
        return Call.create(Call.QualifiedNames.NOT_LIKE, value, (Object)pattern);
    }

    public static Call notLike(Object value, String pattern, String escape) {
        return Call.create(Call.QualifiedNames.NOT_LIKE, value, (Object)pattern, (Object)escape);
    }

    public static Call between(Object value, Object lower, Object upper) {
        return Call.create(Call.QualifiedNames.BETWEEN, value, lower, upper);
    }

    public static Call notBetween(Object value, Object lower, Object upper) {
        return Call.create(Call.QualifiedNames.NOT_BETWEEN, value, lower, upper);
    }

    public static Call call(QualifiedName function) {
        return Call.create(function);
    }

    public static Call call(Function function) {
        return Call.create(function.qualifiedName());
    }

    public static Call call(String qualifiedName) {
        return DcnBuilder.call(DcnBuilder.q(qualifiedName));
    }

    @SafeVarargs
    public static <T> List<T> list(T ... args) {
        return Arrays.asList(args);
    }

    public static List<String> actions(String ... args) {
        return Arrays.asList(args);
    }

    public static List<String> resources(String ... args) {
        return Arrays.asList(args);
    }

    public static List<Call> restrict(Call ... calls) {
        return DcnBuilder.list(calls);
    }

    private static void check2(int count, String operation) {
        if (count < 2) {
            throw new IllegalArgumentException(operation + " needs at least two arguments. Only " + count + " given.");
        }
    }

    private static <T> List<T> asSingletonList(T data) {
        return data != null ? Collections.singletonList(data) : null;
    }

    private static void expectPackageQualifiedName(QualifiedName qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("QualifiedName must not be null");
        }
        if (qualifiedName.size() < 2) {
            throw new IllegalArgumentException("QualifiedName must have at least two segments.");
        }
    }

    private static void expectNoEmptyStringOrNull(List<String> data, String message) {
        if (data != null && !data.isEmpty()) {
            for (String d : data) {
                if (d == null) {
                    throw new IllegalArgumentException(message + "null.");
                }
                if (!d.isEmpty()) continue;
                throw new IllegalArgumentException(message + "empty.");
            }
        }
    }
}

