/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.dcn;

import com.sap.cloud.security.ams.dcl.client.annotation.Beta;
import com.sap.cloud.security.ams.dcl.client.dcn.DcnContainer;
import com.sap.cloud.security.ams.dcl.client.dcn.Function;
import com.sap.cloud.security.ams.dcl.client.dcn.Policy;
import com.sap.cloud.security.ams.dcl.client.dcn.Schema;
import com.sap.cloud.security.ams.dcl.client.dcn.TestCase;
import com.sap.cloud.security.ams.dcl.client.el.QualifiedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Beta
public class DcnRepository {
    private final Map<QualifiedName, Policy> policies = new HashMap<QualifiedName, Policy>();
    private final Map<QualifiedName, Function> functions = new HashMap<QualifiedName, Function>();
    private final Map<QualifiedName, Schema> schemas = new HashMap<QualifiedName, Schema>();
    private final Map<QualifiedName, TestCase> testCases = new HashMap<QualifiedName, TestCase>();
    private final Map<QualifiedName, Policy> policiesUM = Collections.unmodifiableMap(this.policies);
    private final Map<QualifiedName, Function> functionsUM = Collections.unmodifiableMap(this.functions);
    private final Map<QualifiedName, Schema> schemasUM = Collections.unmodifiableMap(this.schemas);
    private final Map<QualifiedName, TestCase> testCasesUM = Collections.unmodifiableMap(this.testCases);
    private Map<String, Object> data = new HashMap<String, Object>();
    private final Map<String, Object> metadata = new HashMap<String, Object>();

    public DcnRepository copy() {
        DcnRepository result = new DcnRepository();
        result.merge(this);
        return result;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = Objects.requireNonNull(data);
    }

    public Function remove(Function function) {
        return this.functions.remove(DcnRepository.getQualifiedNameChecked(function));
    }

    public Function removeFunction(QualifiedName qualifiedName) {
        return this.functions.remove(qualifiedName);
    }

    public void add(Function function) {
        QualifiedName qualifiedName = DcnRepository.getQualifiedNameChecked(function);
        if (this.functions.putIfAbsent(qualifiedName, function) != null) {
            DcnRepository.throwAlreadyPresent("Function", qualifiedName);
        }
    }

    public void add(Function ... functions) {
        for (Function o : functions) {
            this.add(o);
        }
    }

    public Function getFunction(QualifiedName qualifiedName) {
        return this.functions.get(qualifiedName);
    }

    public Map<QualifiedName, Function> getFunctionsMap() {
        return this.functionsUM;
    }

    public Collection<Function> getFunctions() {
        return this.functionsUM.values();
    }

    public Policy remove(Policy policy) {
        return this.policies.remove(DcnRepository.getQualifiedNameChecked(policy));
    }

    public Policy removePolicy(QualifiedName qualifiedName) {
        return this.policies.remove(qualifiedName);
    }

    public void add(Policy policy) {
        QualifiedName qualifiedName = DcnRepository.getQualifiedNameChecked(policy);
        if (this.policies.putIfAbsent(qualifiedName, policy) != null) {
            DcnRepository.throwAlreadyPresent("Policy", qualifiedName);
        }
    }

    public void add(Policy ... policies) {
        for (Policy o : policies) {
            this.add(o);
        }
    }

    public Policy getPolicy(QualifiedName qualifiedName) {
        return this.policies.get(qualifiedName);
    }

    public Map<QualifiedName, Policy> getPoliciesMap() {
        return this.policiesUM;
    }

    public Collection<Policy> getPolicies() {
        return this.policiesUM.values();
    }

    public Schema remove(Schema schema) {
        return this.schemas.remove(DcnRepository.getQualifiedNameChecked(schema));
    }

    public Schema removeSchema(QualifiedName qualifiedName) {
        return this.schemas.remove(qualifiedName);
    }

    public void add(Schema schema) {
        QualifiedName qualifiedName = DcnRepository.getQualifiedNameChecked(schema);
        if (this.schemas.putIfAbsent(qualifiedName, schema) != null) {
            DcnRepository.throwAlreadyPresent("Schema", qualifiedName);
        }
    }

    public void add(Schema ... schemas) {
        for (Schema o : schemas) {
            this.add(o);
        }
    }

    public Schema getSchemaForPackage(QualifiedName packageName) {
        return this.schemas.get(packageName);
    }

    public Map<QualifiedName, Schema> getSchemasMap() {
        return this.schemasUM;
    }

    public Collection<Schema> getSchemas() {
        return this.schemasUM.values();
    }

    public TestCase remove(TestCase testCase) {
        return this.testCases.remove(DcnRepository.getQualifiedNameChecked(testCase));
    }

    public TestCase removeTestCase(QualifiedName qualifiedName) {
        return this.testCases.remove(qualifiedName);
    }

    public void add(TestCase testCase) {
        QualifiedName qualifiedName = DcnRepository.getQualifiedNameChecked(testCase);
        if (this.testCases.putIfAbsent(qualifiedName, testCase) != null) {
            DcnRepository.throwAlreadyPresent("TestCase", qualifiedName);
        }
    }

    public void add(TestCase ... testCase) {
        for (TestCase o : testCase) {
            this.add(o);
        }
    }

    public TestCase getTestCase(QualifiedName qualifiedName) {
        return this.testCases.get(qualifiedName);
    }

    public Map<QualifiedName, TestCase> getTestCasesMap() {
        return this.testCasesUM;
    }

    public Collection<TestCase> getTestCases() {
        return this.testCasesUM.values();
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void add(DcnContainer container) {
        if (DcnRepository.hasContent(container.policies())) {
            container.policies().forEach(this::add);
        }
        if (DcnRepository.hasContent(container.functions())) {
            container.functions().forEach(this::add);
        }
        if (DcnRepository.hasContent(container.schemas())) {
            container.schemas().forEach(this::add);
        }
        if (DcnRepository.hasContent(container.testCases())) {
            container.testCases().forEach(this::add);
        }
    }

    public DcnContainer createDcnContainer() {
        DcnContainer res = new DcnContainer();
        res.version(1);
        res.functions(new ArrayList<Function>(this.getFunctions()));
        res.policies(new ArrayList<Policy>(this.getPolicies()));
        res.schemas(new ArrayList<Schema>(this.getSchemas()));
        res.testCases(new ArrayList<TestCase>(this.getTestCases()));
        return res;
    }

    public String getTenant(Policy policy) {
        return this.getTenantForParentQualifiedName(policy.qualifiedName());
    }

    public String getTenant(Function function) {
        return this.getTenantForParentQualifiedName(function.qualifiedName());
    }

    public void merge(DcnRepository other) {
        DcnRepository.precheckNestedMerge(this.data, other.data);
        DcnRepository.preckeckFlatMerge(this.policies, other.getPoliciesMap(), "policies");
        DcnRepository.preckeckFlatMerge(this.functions, other.getFunctionsMap(), "functions");
        DcnRepository.preckeckFlatMerge(this.schemas, other.getSchemasMap(), "schemas");
        DcnRepository.preckeckFlatMerge(this.testCases, other.getTestCasesMap(), "testCases");
        DcnRepository.precheckNestedMerge(this.metadata, other.getMetadata());
        DcnRepository.mergeNestedMaps(this.data, other.data);
        this.policies.putAll(other.getPoliciesMap());
        this.functions.putAll(other.getFunctionsMap());
        this.schemas.putAll(other.getSchemasMap());
        this.testCases.putAll(other.getTestCasesMap());
        DcnRepository.mergeNestedMaps(this.metadata, other.metadata);
    }

    public void mergeData(Map<String, Object> additionalData) {
        Objects.requireNonNull(additionalData);
        DcnRepository.precheckNestedMerge(this.data, additionalData);
        DcnRepository.mergeNestedMaps(this.data, additionalData);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.functions, this.policies, this.schemas, this.testCases);
    }

    public String toString() {
        return "DcnRepository [schemas=" + this.schemas + ", policies=" + this.policies + ", functions=" + this.functions + ", testCases=" + this.testCases + ", data=" + this.data + ", metadata=" + this.metadata + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DcnRepository other = (DcnRepository)obj;
        return Objects.equals(this.data, other.data) && Objects.equals(this.functions, other.functions) && Objects.equals(this.policies, other.policies) && Objects.equals(this.schemas, other.schemas) && Objects.equals(this.testCases, other.testCases) && Objects.equals(this.metadata, other.metadata);
    }

    private String getTenantForParentQualifiedName(QualifiedName qualifiedName) {
        QualifiedName parentQualifiedName = (QualifiedName)qualifiedName.setLastSegment("schema");
        Schema schema = this.schemas.get(parentQualifiedName);
        return schema != null && schema.tenant() != null ? schema.tenant() : "";
    }

    static <T> void preckeckFlatMerge(Map<QualifiedName, T> target, Map<QualifiedName, T> source, String name) {
        source.forEach((k, v) -> {
            if (target.containsKey(k)) {
                throw new IllegalStateException("Entity " + v + " already present in " + name);
            }
        });
    }

    static void precheckNestedMerge(Map<?, ?> map1, Map<?, ?> map2) {
        if (map1.isEmpty() || map2.isEmpty()) {
            return;
        }
        for (Map.Entry<?, ?> e2 : map2.entrySet()) {
            Object key = e2.getKey();
            if (!map1.containsKey(key)) continue;
            Object value1 = map1.get(key);
            Object value2 = e2.getValue();
            if (value1 instanceof Map && value2 instanceof Map) {
                DcnRepository.precheckNestedMerge((Map)value1, (Map)value2);
                continue;
            }
            throw new IllegalArgumentException("Values cannot be merged. (" + value1 + " / " + value2 + ")");
        }
    }

    static void mergeNestedMaps(Map<String, Object> map1, Map<String, Object> map2) {
        for (Map.Entry<String, Object> e2 : map2.entrySet()) {
            String key = e2.getKey();
            Object v2 = e2.getValue();
            if (map1.containsKey(key)) {
                Object v1 = map1.get(key);
                if (v1 instanceof Map && v2 instanceof Map) {
                    DcnRepository.mergeNestedMaps((Map)v1, (Map)v2);
                    continue;
                }
                throw new IllegalArgumentException("Values cannot be merged. (" + v1 + " / " + v2 + ")");
            }
            if (v2 instanceof Map) {
                HashMap<String, Object> newMap = new HashMap<String, Object>();
                map1.put(key, newMap);
                DcnRepository.mergeNestedMaps(newMap, (Map)v2);
                continue;
            }
            map1.put(key, v2);
        }
    }

    private static void throwAlreadyPresent(String type, QualifiedName qualifiedName) {
        throw new IllegalArgumentException(type + " with qualifiedName (" + qualifiedName + ") already present in repository.");
    }

    private static QualifiedName getQualifiedNameChecked(Function function) {
        QualifiedName qualifiedName = function.qualifiedName();
        if (qualifiedName == null) {
            throw new NullPointerException("QualifiedName of Function must not be null.");
        }
        if (qualifiedName.isEmpty()) {
            throw new IllegalArgumentException("QualifiedName of Function must not be EMPTY.");
        }
        return qualifiedName;
    }

    private static QualifiedName getQualifiedNameChecked(Policy policy) {
        QualifiedName qualifiedName = policy.qualifiedName();
        if (qualifiedName == null) {
            throw new NullPointerException(" QualifiedName of Policy must not be null.");
        }
        if (qualifiedName.isEmpty()) {
            throw new IllegalArgumentException("QualifiedName of Policy must not be EMPTY.");
        }
        return qualifiedName;
    }

    private static QualifiedName getQualifiedNameChecked(TestCase testCase) {
        QualifiedName qualifiedName = testCase.qualifiedName();
        if (qualifiedName == null) {
            throw new NullPointerException(" QualifiedName of TestCase must not be null.");
        }
        if (qualifiedName.isEmpty()) {
            throw new IllegalArgumentException("QualifiedName of TestCase must not be EMPTY.");
        }
        return qualifiedName;
    }

    private static QualifiedName getQualifiedNameChecked(Schema schema) {
        QualifiedName qualifiedName = schema.qualifiedName();
        if (qualifiedName == null) {
            throw new NullPointerException("QualifiedName of Schema must not be null.");
        }
        return qualifiedName;
    }

    static boolean hasContent(Collection<?> col) {
        return col != null && !col.isEmpty();
    }

    public boolean isEmpty() {
        return this.policies.isEmpty() && this.functions.isEmpty() && this.schemas.isEmpty() && this.testCases.isEmpty() && this.metadata.isEmpty();
    }
}

