/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.dcn;

import com.sap.cloud.security.ams.dcl.client.annotation.Beta;
import com.sap.cloud.security.ams.dcl.client.dcn.DcnContainer;
import com.sap.cloud.security.ams.dcl.client.dcn.DcnRepository;
import com.sap.cloud.security.ams.dcl.client.dcn.DcnTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Beta
public class DcnRepositoryTools {
    private DcnRepositoryTools() {
    }

    public static DcnRepository load(List<File> sources) throws IOException {
        final DcnRepository repository = new DcnRepository();
        boolean dataLoaded = false;
        for (File source : sources) {
            Files.walkFileTree(source.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toString().endsWith(".dcn")) {
                        DcnContainer dcn = DcnTools.getInstance().deserialize(file.toFile());
                        repository.add(dcn);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            if (dataLoaded) continue;
            File data = new File(source, "data.json");
            if (data.isFile()) {
                try (InputStream is = Files.newInputStream(data.toPath(), new OpenOption[0]);){
                    Map d = DcnTools.getInstance().deserialize(Map.class, is, null);
                    repository.setData(d);
                }
            }
            dataLoaded = true;
        }
        return repository;
    }

    public static DcnRepository load(File sources) throws IOException {
        return DcnRepositoryTools.load(Collections.singletonList(sources));
    }
}

