/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.dcn;

import com.sap.cloud.security.ams.dcl.client.dcn.DataType;
import com.sap.cloud.security.ams.dcl.client.dcn.DcnSchemaBuilder;
import com.sap.cloud.security.ams.dcl.client.dcn.Schema;
import com.sap.cloud.security.ams.dcl.client.dcn.SchemaAttribute;
import com.sap.cloud.security.ams.dcl.client.el.AttributeName;
import com.sap.cloud.security.ams.dcl.client.el.QualifiedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

class DcnSchemaBuilderImpl
implements DcnSchemaBuilder {
    static final String DCN_SCHEMA_NAME = "schema";
    private static final QualifiedName ROOT_SCHEMA = QualifiedName.create("schema");
    private final Schema schema;
    private final List<SchemaAttribute> structureNesting = new ArrayList<SchemaAttribute>();
    private final DcnSchemaBuilder.Structure structure = new StructureImpl();

    DcnSchemaBuilderImpl() {
        this(true);
    }

    DcnSchemaBuilderImpl(QualifiedName dclPackage, String tenant) {
        this(false);
        Objects.requireNonNull(dclPackage, "dclPackage must not be null");
        if (dclPackage.isEmpty()) {
            throw new IllegalArgumentException("dclPackage must not be EMPTY.");
        }
        Objects.requireNonNull(tenant, "tenant must not be null");
        if (tenant.isEmpty()) {
            throw new IllegalArgumentException("tenant must not be EMPTY.");
        }
        this.schema.qualifiedName((QualifiedName)dclPackage.append(DCN_SCHEMA_NAME));
        this.schema.tenant(tenant);
    }

    private DcnSchemaBuilderImpl(boolean withDCL) {
        this.schema = new Schema();
        this.schema.qualifiedName(ROOT_SCHEMA);
        this.schema.tenant("");
        SchemaAttribute definition = new SchemaAttribute();
        definition.attributeName(AttributeName.EMPTY);
        definition.type(DataType.Structure);
        this.schema.definition(definition);
        this.structureNesting.add(definition);
        if (withDCL) {
            this.addDCLDefault();
        }
    }

    @Override
    public DcnSchemaBuilder attribute(AttributeName attName, DataType type) {
        this.createSchemaAttribute(attName, type, null);
        return this;
    }

    @Override
    public DcnSchemaBuilder attribute(AttributeName attName, DataType type, Consumer<SchemaAttribute> c) {
        this.createSchemaAttribute(attName, type, c);
        return this;
    }

    @Override
    public DcnSchemaBuilder.Structure app() {
        return this.resetNavigation("$app");
    }

    @Override
    public DcnSchemaBuilder.Structure env() {
        return this.resetNavigation("$env");
    }

    @Override
    public Schema build() {
        return this.schema;
    }

    public SchemaAttribute current() {
        return this.structureNesting.get(this.structureNesting.size() - 1);
    }

    private DcnSchemaBuilder.Structure resetNavigation(String key) {
        for (int i = this.structureNesting.size() - 1; i > 0; --i) {
            this.structureNesting.remove(i);
        }
        return this.structure.structure(key);
    }

    private void createSchemaAttribute(AttributeName attName, DataType type, Consumer<SchemaAttribute> c) {
        SchemaAttribute current = this.schema.definition();
        if (attName == null || attName.isEmpty()) {
            throw new IllegalArgumentException("Attribute name must not be null or empty");
        }
        int end = attName.size() - 1;
        for (int i = 0; i <= end; ++i) {
            DataType expectedType;
            String segment = attName.getSegment(i);
            Map<String, SchemaAttribute> nested = current.nested();
            DataType dataType = expectedType = i == end ? type : DataType.Structure;
            if (nested == null) {
                nested = new HashMap<String, SchemaAttribute>();
                current.nested(nested);
            } else {
                current = nested.get(segment);
                if (current != null) {
                    if (expectedType.equals((Object)current.type())) continue;
                    throw new IllegalStateException("Structure mismatch");
                }
            }
            current = new SchemaAttribute();
            current.attributeName((AttributeName)attName.subName(0, i + 1));
            current.type(expectedType);
            nested.put(segment, current);
        }
        if (c != null) {
            c.accept(current);
        }
    }

    private DcnSchemaBuilder.Structure dcl() {
        return this.resetNavigation("$dcl");
    }

    private void addDCLDefault() {
        this.dcl().attribute("action", DataType.String).attribute("resource", DataType.String).attribute("tenant", DataType.String).attribute("policies", DataType.StringArray).attribute("scopeFilter", DataType.String).attribute("principal2policies", DataType.StringArray);
    }

    private class StructureImpl
    implements DcnSchemaBuilder.Structure {
        private StructureImpl() {
        }

        @Override
        public DcnSchemaBuilder.Structure structure(String name) {
            return this.grantSchemaAttribute(name, DataType.Structure, null);
        }

        @Override
        public DcnSchemaBuilder.Structure attribute(String name, DataType type) {
            if (DataType.Structure.equals((Object)type)) {
                throw new IllegalArgumentException("Structures need to be added by structure(...).");
            }
            return this.grantSchemaAttribute(name, type, null);
        }

        @Override
        public DcnSchemaBuilder.Structure attribute(String name, DataType type, Consumer<SchemaAttribute> c) {
            if (DataType.Structure.equals((Object)type)) {
                throw new IllegalArgumentException("Structures need to be added by structure(...).");
            }
            return this.grantSchemaAttribute(name, type, c);
        }

        @Override
        public DcnSchemaBuilder.Structure end() {
            if (DcnSchemaBuilderImpl.this.structureNesting.size() == 1) {
                throw new IllegalStateException("Cannot close root");
            }
            DcnSchemaBuilderImpl.this.structureNesting.remove(DcnSchemaBuilderImpl.this.structureNesting.size() - 1);
            return this;
        }

        @Override
        public DcnSchemaBuilder builder() {
            return DcnSchemaBuilderImpl.this;
        }

        private DcnSchemaBuilder.Structure grantSchemaAttribute(String name, DataType type, Consumer<SchemaAttribute> c) {
            SchemaAttribute result;
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException("Name must not be null or empty");
            }
            SchemaAttribute parent = DcnSchemaBuilderImpl.this.current();
            Map<String, SchemaAttribute> nested = parent.nested();
            if (nested == null) {
                nested = new HashMap<String, SchemaAttribute>();
                parent.nested(nested);
            }
            if ((result = nested.get(name)) != null) {
                if (!type.equals((Object)result.type())) {
                    throw new IllegalStateException("Structure mismatch");
                }
            } else {
                result = new SchemaAttribute();
                result.attributeName((AttributeName)parent.attributeName().append(name));
                result.type(type);
                nested.put(name, result);
            }
            if (c != null) {
                c.accept(result);
            }
            if (DataType.Structure.equals((Object)type)) {
                DcnSchemaBuilderImpl.this.structureNesting.add(result);
            }
            return this;
        }
    }
}

