/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.dcn;

import com.sap.cloud.security.ams.dcl.client.annotation.Beta;
import com.sap.cloud.security.ams.dcl.client.dcn.Annotated;
import com.sap.cloud.security.ams.dcl.client.dcn.SchemaAttribute;
import com.sap.cloud.security.ams.dcl.client.el.QualifiedName;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

@Beta
public class Schema
implements Annotated<Schema> {
    private QualifiedName qualifiedName;
    private String tenant;
    private SchemaAttribute definition;
    private Map<String, Object> annotations;
    private transient Object userData;

    public QualifiedName qualifiedName() {
        return this.qualifiedName;
    }

    public Schema qualifiedName(QualifiedName qualifiedName) {
        if (qualifiedName != null && (qualifiedName.isEmpty() || !"schema".equals(qualifiedName.getLastSegment()))) {
            throw new IllegalArgumentException("The qualified name must end with schema.");
        }
        this.qualifiedName = qualifiedName;
        return this;
    }

    public String tenant() {
        return this.tenant;
    }

    public Schema tenant(String tenant) {
        this.tenant = tenant;
        return this;
    }

    public SchemaAttribute definition() {
        return this.definition;
    }

    public Schema definition(SchemaAttribute definition) {
        this.definition = definition;
        return this;
    }

    @Override
    public Map<String, Object> annotations() {
        return this.annotations;
    }

    @Override
    public Schema annotations(Map<String, Object> annotations) {
        this.annotations = annotations;
        return this;
    }

    public Object userData() {
        return this.userData;
    }

    public Schema userData(Object userData) {
        this.userData = userData;
        return this;
    }

    public Schema apply(Consumer<Schema> consumer) {
        consumer.accept(this);
        return this;
    }

    public String toString() {
        return "Schema [qualifiedName=" + this.qualifiedName + ", tenant=" + this.tenant + ", definition=" + this.definition + ", annotations=" + this.annotations + "]";
    }

    public int hashCode() {
        return Objects.hash(this.qualifiedName, this.tenant, this.definition, this.annotations);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Schema other = (Schema)obj;
        return Objects.equals(this.qualifiedName, other.qualifiedName) && Objects.equals(this.tenant, other.tenant) && Objects.equals(this.definition, other.definition) && Objects.equals(this.annotations, other.annotations);
    }
}

