/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.dcn.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnBase;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnSerializerHelper;
import com.sap.cloud.security.ams.dcl.client.el.Call;
import com.sap.cloud.security.ams.dcl.client.el.QualifiedName;
import java.lang.reflect.Type;

class CallSerializer
extends DcnBase<Call> {
    public CallSerializer(DcnSerializerHelper helper) {
        super(helper);
    }

    @Override
    public Call deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject p = json.getAsJsonObject();
        JsonElement element = p.get("call");
        if (element != null) {
            QualifiedName qualifiedName = this.helper.deserializeReferenceAsQualifiedName(element);
            JsonElement args = p.get("args");
            if (args == null) {
                return Call.create(qualifiedName);
            }
            if (args.isJsonArray()) {
                return Call.createFrom(qualifiedName, this.helper.deserializeExpression((JsonArray)args, context));
            }
        }
        throw new IllegalStateException("Cannot handle element " + json);
    }

    @Override
    public JsonElement serialize(Call call, Type type, JsonSerializationContext context) {
        JsonObject callJson = new JsonObject();
        callJson.add("call", this.helper.serializeAsReference(call.getQualifiedName()));
        if (call.getArgumentCount() > 0) {
            int length = call.getArgumentCount();
            JsonArray arr = new JsonArray(length);
            for (int i = 0; i < length; ++i) {
                arr.add(context.serialize(call.getArgument(i)));
            }
            callJson.add("args", arr);
        }
        return callJson;
    }
}

