/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.dcn.gson;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.sap.cloud.security.ams.dcl.client.dcn.DataType;
import com.sap.cloud.security.ams.dcl.client.dcn.DcnTools;
import com.sap.cloud.security.ams.dcl.client.dcn.Effect;
import com.sap.cloud.security.ams.dcl.client.dcn.Function;
import com.sap.cloud.security.ams.dcl.client.dcn.Policy;
import com.sap.cloud.security.ams.dcl.client.dcn.Rule;
import com.sap.cloud.security.ams.dcl.client.dcn.Schema;
import com.sap.cloud.security.ams.dcl.client.dcn.SchemaAttribute;
import com.sap.cloud.security.ams.dcl.client.dcn.TestAssertion;
import com.sap.cloud.security.ams.dcl.client.dcn.TestCase;
import com.sap.cloud.security.ams.dcl.client.dcn.TestInput;
import com.sap.cloud.security.ams.dcl.client.dcn.Use;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.AttributeNameSerializer;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.CallSerializer;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DataTypeSerializer;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnSerializerHelper;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.EffectSerializer;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.ExpressionMarker;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.FunctionSerializer;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.NumberSerializer;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.PolicySerializer;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.QualifiedNameSerializer;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.RuleSerializer;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.SchemaAttributeSerializer;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.SchemaSerializer;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.TestAssertionSerializer;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.TestCaseSerializer;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.TestInputSerializer;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.UseSerializer;
import com.sap.cloud.security.ams.dcl.client.el.AttributeName;
import com.sap.cloud.security.ams.dcl.client.el.Call;
import com.sap.cloud.security.ams.dcl.client.el.QualifiedName;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class DcnGsonTools {
    public static final String POLICIES = "policies";
    public static final String POLICY = "policy";
    public static final String NAME = "name";
    public static final String USES = "uses";
    public static final String USE = "use";
    public static final String RULES = "rules";
    public static final String RULE = "rule";
    public static final String ACTIONS = "actions";
    public static final String RESOURCES = "resources";
    public static final String CONDITION = "condition";
    public static final String RESTRICTIONS = "restrictions";
    public static final String CALL = "call";
    public static final String ARGS = "args";
    public static final String REF = "ref";
    public static final String VAL = "val";
    public static final String LITERAL = "literal";
    @Deprecated
    public static final String ELEMENT = "element";
    public static final String ATTRIBUTE = "attribute";
    public static final String FUNCTION = "function";
    public static final String RESULT = "result";
    public static final String RETURN_TYPE = "returnType";
    public static final String SCHEMA = "schema";
    public static final String DEFINITION = "definition";
    public static final String NESTED = "nested";
    public static final String DESCRIPTION = "description";
    public static final String DEFAULT = "default";
    public static final String INTERNAL = "internal";
    public static final String ROLE = "role";
    public static final String ANNOTATIONS = "annotations";
    public static final String ANNOTATION = "annotation";
    public static final String VALUE = "value";
    public static final String TENANT = "tenant";
    public static final String TEST = "test";
    public static final String INPUT = "input";
    public static final String ASSERTIONS = "assertions";
    public static final String EXPECT = "expect";
    public static final String SCOPE_FILTER = "scopeFilter";
    public static final String INPUTS = "inputs";
    public static final String IGNORES = "ignores";
    public static final String UNKNOWNS = "unknowns";
    public static final String LITERAL_TIMESTAMP = "timestamp";
    public static final String LITERAL_DATE = "date";
    public static final String LITERAL_TIME = "time";
    public static final Type TT_LIST_STRING = new TypeToken<List<String>>(){}.getType();
    public static final Type TT_LIST_USE = new TypeToken<List<Use>>(){}.getType();
    public static final Type TT_LIST_RULE = new TypeToken<List<Rule>>(){}.getType();
    public static final Type TT_LIST_ATTRIBUTE_NAME = new TypeToken<List<AttributeName>>(){}.getType();
    public static final Type TT_LIST_QUALIFIED_NAME = new TypeToken<List<QualifiedName>>(){}.getType();
    public static final Type TT_LIST_TEST_ASSERTIONS = new TypeToken<List<TestAssertion>>(){}.getType();
    public static final Type TT_LIST_TEST_INPUT = new TypeToken<List<TestInput>>(){}.getType();
    public static final Type TT_JSON_OBJECT = new TypeToken<Map<String, Object>>(){}.getType();
    private static final JsonElement EMPTY_JSON_ARRAY = new JsonArray();
    private static final JsonElement EMPTY_JSON_MAP = new JsonObject();
    private static final JsonSerializer<Object> EMPTY_ARRAY_SERIALIZER = (src, typeOfSrc, context) -> EMPTY_JSON_ARRAY;
    private static final JsonSerializer<Object> EMPTY_MAP_SERIALIZER = (src, typeOfSrc, context) -> EMPTY_JSON_MAP;

    private DcnGsonTools() {
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return Objects.nonNull(collection) && !collection.isEmpty();
    }

    public static void registerTypeAdapters(GsonBuilder builder, boolean withJavaTypes) {
        DcnGsonTools.registerTypeAdapters(builder, withJavaTypes, null);
    }

    public static void registerTypeAdapters(GsonBuilder builder, boolean withJavaTypes, DcnSerializerHelper helper) {
        final DcnSerializerHelper h = helper != null ? helper : new DcnSerializerHelper(null);
        builder.registerTypeAdapter(Collections.emptySet().getClass(), EMPTY_ARRAY_SERIALIZER);
        builder.registerTypeAdapter(Collections.emptyList().getClass(), EMPTY_ARRAY_SERIALIZER);
        builder.registerTypeAdapter(Collections.emptyMap().getClass(), EMPTY_MAP_SERIALIZER);
        builder.registerTypeHierarchyAdapter(AttributeName.class, new AttributeNameSerializer(h));
        builder.registerTypeAdapter((Type)((Object)Effect.class), new EffectSerializer(h));
        builder.registerTypeAdapter((Type)((Object)DataType.class), new DataTypeSerializer(h));
        builder.registerTypeAdapter((Type)((Object)Policy.class), new PolicySerializer(h));
        builder.registerTypeAdapter((Type)((Object)Function.class), new FunctionSerializer(h));
        builder.registerTypeAdapter((Type)((Object)Rule.class), new RuleSerializer(h));
        builder.registerTypeAdapter((Type)((Object)Schema.class), new SchemaSerializer(h));
        builder.registerTypeAdapter((Type)((Object)SchemaAttribute.class), new SchemaAttributeSerializer(h));
        builder.registerTypeAdapter((Type)((Object)Use.class), new UseSerializer(h));
        builder.registerTypeAdapter((Type)((Object)TestCase.class), new TestCaseSerializer(h));
        builder.registerTypeAdapter((Type)((Object)TestAssertion.class), new TestAssertionSerializer(h));
        builder.registerTypeAdapter((Type)((Object)TestInput.class), new TestInputSerializer(h));
        builder.registerTypeHierarchyAdapter(Call.class, new CallSerializer(h));
        builder.registerTypeHierarchyAdapter(QualifiedName.class, new QualifiedNameSerializer(h));
        builder.registerTypeAdapter((Type)((Object)ExpressionMarker.class), new JsonDeserializer<Object>(){

            @Override
            public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return h.deserializeExpression(json, context);
            }
        });
        if (withJavaTypes) {
            builder.registerTypeHierarchyAdapter(Number.class, new NumberSerializer(h));
        }
    }

    public static GsonBuilder createGsonBuilder(boolean pretty) {
        DcnTools.SerializationConfiguration config = new DcnTools.SerializationConfiguration();
        config.setPretty(pretty);
        return DcnGsonTools.createGsonBuilder(config);
    }

    public static GsonBuilder createGsonBuilder(DcnTools.SerializationConfiguration config) {
        DcnSerializerHelper helper = new DcnSerializerHelper(config);
        GsonBuilder builder = new GsonBuilder();
        if (helper.isPretty()) {
            builder.setPrettyPrinting();
        }
        DcnGsonTools.registerTypeAdapters(builder, true, helper);
        return builder;
    }
}

