/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.dcn.gson;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.sap.cloud.security.ams.dcl.client.dcn.DcnContainer;
import com.sap.cloud.security.ams.dcl.client.dcn.DcnTools;
import com.sap.cloud.security.ams.dcl.client.dcn.DcnToolsFactory;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnGsonTools;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.ExpressionMarker;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DcnSerializationToolsGson
implements DcnTools {
    DcnSerializationToolsGson() {
    }

    private static Reader createUtf8Reader(InputStream is) {
        return new InputStreamReader(is, StandardCharsets.UTF_8);
    }

    @Override
    public void serialize(Object dcn, File file, DcnTools.SerializationConfiguration config) throws IOException {
        try (OutputStream fos = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            this.serialize(dcn, fos, config);
        }
    }

    @Override
    public DcnContainer deserialize(InputStream is) throws IOException {
        return this.deserialize(DcnContainer.class, is, null);
    }

    @Override
    public Object deserializeExpression(InputStream is, DcnTools.SerializationConfiguration configuration) throws IOException {
        return this.deserialize(ExpressionMarker.class, is, configuration);
    }

    @Override
    public Object deserializeExpression(InputStream is) throws IOException {
        return this.deserializeExpression(is, null);
    }

    @Override
    public DcnContainer deserialize(File file) throws IOException {
        try (InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            DcnContainer dcnContainer = this.deserialize(DcnContainer.class, is, null);
            return dcnContainer;
        }
    }

    @Override
    public <T> T deserialize(Class<T> clazz, InputStream is, DcnTools.SerializationConfiguration configuration) throws IOException {
        try {
            return DcnSerializationToolsGson.getDcnGson(configuration).fromJson(new JsonReader(DcnSerializationToolsGson.createUtf8Reader(is)), clazz);
        }
        catch (RuntimeException e) {
            throw new IOException("Failed to deserialize Json", e);
        }
    }

    @Override
    public void serialize(DcnContainer dcn, File file) throws IOException {
        this.serialize((Object)dcn, file, null);
    }

    @Override
    public void serialize(DcnContainer dcn, OutputStream os) throws IOException {
        this.serialize((Object)dcn, os, null);
    }

    @Override
    public void serialize(Object document, OutputStream os, DcnTools.SerializationConfiguration config) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(os, StandardCharsets.UTF_8);
        Writer wr = os instanceof ByteArrayOutputStream ? osw : new BufferedWriter(osw);
        try {
            DcnSerializationToolsGson.getDcnGson(config).toJson(document, (Appendable)wr);
            wr.flush();
        }
        catch (RuntimeException e) {
            throw new IOException("Failed to serialize Json", e);
        }
    }

    public static Gson getDcnGson() {
        return DcnSerializationToolsGson.getDcnGson(null);
    }

    public static Gson getDcnGson(DcnTools.SerializationConfiguration config) {
        return DcnGsonTools.createGsonBuilder(config).create();
    }

    public static class Factory
    extends DcnToolsFactory {
        private static final Logger LOG = LoggerFactory.getLogger(Factory.class);

        @Override
        protected DcnTools tryCreate(String kind, Object[] arguments) {
            if ("default".equals(kind)) {
                try {
                    return new DcnSerializationToolsGson();
                }
                catch (NoClassDefFoundError e) {
                    LOG.warn("Cannot load Gson classes. Continue searching for an alternative DclJson implementation.");
                }
            }
            return null;
        }

        @Override
        protected int getPriority() {
            return 1000;
        }
    }
}

