/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.dcn.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.sap.cloud.security.ams.dcl.client.dcn.DcnTools;
import com.sap.cloud.security.ams.dcl.client.el.AttributeName;
import com.sap.cloud.security.ams.dcl.client.el.Call;
import com.sap.cloud.security.ams.dcl.client.el.IQualifiedName;
import com.sap.cloud.security.ams.dcl.client.el.QualifiedName;
import com.sap.cloud.security.ams.dcl.client.el.QualifiedNamesBuilder;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class DcnSerializerHelper {
    private static final String CANNOT_CONVERT = "Cannot convert ";
    private static final String CANNOT_CONVERT_NULL_REFERENCE = "Cannot convert null reference.";
    private static final String CANNOT_CONVERT_EMPTY_REFERENCE = "Cannot convert empty reference.";
    private static final String CANNOT_CONVERT_ARRAY_WITH_NULL = "Cannot convert array with null.";
    private static final JsonPrimitive JP_TRUE = new JsonPrimitive(true);
    private static final JsonPrimitive JP_FALSE = new JsonPrimitive(false);
    private final StringBuilder sb = new StringBuilder();
    private final List<String> tempStringList = new ArrayList<String>();
    private ZoneId sytemDefaultZoneId;
    private DcnTools.SerializationConfiguration config;
    private final QualifiedNamesBuilder qnb = QualifiedNamesBuilder.create();

    public DcnSerializerHelper() {
        this(null);
    }

    public DcnSerializerHelper(DcnTools.SerializationConfiguration config) {
        this.config = config != null ? config : new DcnTools.SerializationConfiguration();
    }

    public boolean isPretty() {
        return this.config.isPretty();
    }

    public StringBuilder getStringBuilder() {
        this.sb.setLength(0);
        return this.sb;
    }

    public List<Object> deserializeExpression(JsonArray ja, JsonDeserializationContext context) {
        if (ja == null) {
            return null;
        }
        ArrayList<Object> res = new ArrayList<Object>();
        for (JsonElement el : ja) {
            if (el == null || el.isJsonNull()) {
                throw new IllegalStateException(CANNOT_CONVERT_ARRAY_WITH_NULL + ja);
            }
            res.add(this.deserializeExpression(el, context));
        }
        return res;
    }

    public Object getValue(JsonPrimitive jp) {
        if (jp.isBoolean()) {
            return jp.getAsBoolean();
        }
        if (jp.isNumber()) {
            return DcnSerializerHelper.toNumber(jp.getAsNumber());
        }
        return jp.getAsString();
    }

    private static Number toNumber(Number source) {
        return source instanceof Comparable ? (Number)source : (Number)source.doubleValue();
    }

    public Object deserializeExpression(JsonElement je, JsonDeserializationContext context) {
        if (je == null) {
            return null;
        }
        if (je instanceof JsonPrimitive) {
            return this.getValue((JsonPrimitive)je);
        }
        if (je instanceof JsonNull) {
            return null;
        }
        if (je instanceof JsonArray) {
            return this.deserializeExpression((JsonArray)je, context);
        }
        JsonObject jo = (JsonObject)je;
        if (jo.get("call") != null) {
            return context.deserialize(je, (Type)((Object)Call.class));
        }
        if (jo.get("ref") != null) {
            return context.deserialize(je, (Type)((Object)AttributeName.class));
        }
        if (jo.get("val") != null) {
            return this.deserializeValue(jo);
        }
        throw new IllegalStateException(CANNOT_CONVERT + je);
    }

    public QualifiedName deserializeReferenceAsQualifiedName(JsonElement je) {
        JsonArray ja = DcnSerializerHelper.expectJsonArray(je);
        if (ja.isEmpty()) {
            return QualifiedName.create();
        }
        return this.qnb.createQualifiedName(this.toStringList(ja));
    }

    public AttributeName deserializeReferenceAsAttributeName(JsonElement je) {
        JsonArray ja = DcnSerializerHelper.expectJsonArray(je);
        if (ja.isEmpty()) {
            return AttributeName.create();
        }
        return this.qnb.createAttributeName(this.toStringList(ja));
    }

    private static JsonArray expectJsonArray(JsonElement je) {
        if (je instanceof JsonArray) {
            return (JsonArray)je;
        }
        throw new IllegalStateException(CANNOT_CONVERT + je + " to array.");
    }

    public <T extends IQualifiedName<T>> JsonElement serializeAsReference(T name) {
        DcnSerializerHelper.checkReference(name);
        int size = name.size();
        JsonArray arr = new JsonArray(size);
        for (int i = 0; i < size; ++i) {
            arr.add(name.getSegment(i));
        }
        return arr;
    }

    public Instant convertToInstant(LocalDateTime src) {
        if (this.sytemDefaultZoneId == null) {
            this.sytemDefaultZoneId = ZoneId.systemDefault();
        }
        return src.atZone(this.sytemDefaultZoneId).toInstant();
    }

    private List<String> toStringList(JsonArray ja) {
        this.tempStringList.clear();
        for (JsonElement jae : ja) {
            this.tempStringList.add(DcnSerializerHelper.expectString(jae));
        }
        return this.tempStringList;
    }

    private Object deserializeValue(JsonObject jo) {
        JsonPrimitive jplit;
        JsonElement jlit;
        JsonPrimitive jp;
        JsonElement val = jo.get("val");
        if (val instanceof JsonPrimitive && (jp = (JsonPrimitive)val).isString() && (jlit = jo.get("literal")) instanceof JsonPrimitive && (jplit = (JsonPrimitive)jlit).isString()) {
            String lit;
            String value = jp.getAsString();
            switch (lit = jlit.getAsString()) {
                case "timestamp": {
                    return Instant.parse(value);
                }
                case "date": {
                    return LocalDate.parse(value);
                }
                case "time": {
                    return LocalTime.parse(value);
                }
            }
        }
        throw new IllegalStateException(CANNOT_CONVERT + jo);
    }

    private static String expectString(JsonElement el) {
        JsonPrimitive jp;
        if (el instanceof JsonPrimitive && (jp = (JsonPrimitive)el).isString()) {
            return jp.getAsString();
        }
        throw new IllegalStateException(CANNOT_CONVERT + el + " to string.");
    }

    private static <T extends IQualifiedName<T>> T checkReference(T reference) {
        if (reference == null) {
            throw new NullPointerException(CANNOT_CONVERT_NULL_REFERENCE);
        }
        if (reference.isEmpty()) {
            throw new IllegalStateException(CANNOT_CONVERT_EMPTY_REFERENCE);
        }
        return reference;
    }

    public void add(JsonObject jo, String key, boolean value) {
        jo.add(key, value ? JP_TRUE : JP_FALSE);
    }

    public void addIfTrueVal(JsonObject jo, String key, boolean flag) {
        if (flag) {
            jo.add(key, JP_TRUE);
        }
    }

    public void addIfContent(JsonObject jo, String key, JsonSerializationContext context, String data) {
        if (data != null && !data.isEmpty()) {
            jo.addProperty(key, data);
        }
    }

    public void addIfContent(JsonObject jo, String key, JsonSerializationContext context, Collection<?> data) {
        if (data != null && !data.isEmpty()) {
            jo.add(key, context.serialize(data));
        }
    }

    public void addIfContent(JsonObject jo, String key, JsonSerializationContext context, Map<?, ?> data) {
        if (data != null && !data.isEmpty()) {
            jo.add(key, context.serialize(data));
        }
    }

    public boolean getBoolean(JsonObject jo, String key, boolean defaultValue) {
        JsonPrimitive jp;
        JsonElement el = jo.get(key);
        if (el instanceof JsonPrimitive && (jp = (JsonPrimitive)el).isBoolean()) {
            return jp.getAsBoolean();
        }
        return defaultValue;
    }
}

