/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.dcn.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.sap.cloud.security.ams.dcl.client.dcn.DataType;
import com.sap.cloud.security.ams.dcl.client.dcn.Function;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnBase;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnSerializerHelper;
import java.lang.reflect.Type;
import java.util.Map;

class FunctionSerializer
extends DcnBase<Function> {
    public FunctionSerializer(DcnSerializerHelper helper) {
        super(helper);
    }

    @Override
    public Function deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject functionObject = json.getAsJsonObject();
        Function function = new Function();
        function.qualifiedName(this.helper.deserializeReferenceAsQualifiedName(functionObject.get("function")));
        JsonElement res = functionObject.get("result");
        if (res == null) {
            throw new IllegalStateException("Cannot handle element (result missing)" + json);
        }
        function.result(this.helper.deserializeExpression(res, context));
        JsonElement rt = functionObject.get("returnType");
        function.returnType(rt == null ? DataType.Boolean : (DataType)((Object)context.deserialize(rt, (Type)((Object)DataType.class))));
        function.internal(this.helper.getBoolean(functionObject, "internal", function.internal()));
        function.annotations((Map)context.deserialize(functionObject.get("annotations"), (Type)((Object)Map.class)));
        return function;
    }

    @Override
    public JsonElement serialize(Function function, Type type, JsonSerializationContext context) {
        JsonObject functionObject = new JsonObject();
        functionObject.add("function", this.helper.serializeAsReference(function.qualifiedName()));
        functionObject.add("result", context.serialize(function.result()));
        functionObject.add("returnType", context.serialize((Object)function.returnType()));
        this.helper.addIfTrueVal(functionObject, "internal", function.internal());
        functionObject.add("annotations", context.serialize(function.annotations()));
        return functionObject;
    }
}

