/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.dcn.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.sap.cloud.security.ams.dcl.client.dcn.Policy;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnBase;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnGsonTools;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnSerializerHelper;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

class PolicySerializer
extends DcnBase<Policy> {
    public PolicySerializer(DcnSerializerHelper helper) {
        super(helper);
    }

    @Override
    public Policy deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject policyObject = jsonElement.getAsJsonObject();
        Policy policy = new Policy();
        policy.qualifiedName(this.helper.deserializeReferenceAsQualifiedName(policyObject.get("policy")));
        policy.rules((List)context.deserialize(policyObject.get("rules"), DcnGsonTools.TT_LIST_RULE));
        policy.uses((List)context.deserialize(policyObject.get("uses"), DcnGsonTools.TT_LIST_USE));
        policy.description((String)context.deserialize(policyObject.get("description"), (Type)((Object)String.class)));
        policy.defaultPolicy(this.helper.getBoolean(policyObject, "default", policy.defaultPolicy()));
        policy.internal(this.helper.getBoolean(policyObject, "internal", policy.internal()));
        policy.annotations((Map)context.deserialize(policyObject.get("annotations"), (Type)((Object)Map.class)));
        return policy;
    }

    @Override
    public JsonElement serialize(Policy policy, Type type, JsonSerializationContext context) {
        JsonObject policyObject = new JsonObject();
        policyObject.add("policy", this.helper.serializeAsReference(policy.qualifiedName()));
        this.helper.addIfContent(policyObject, "rules", context, policy.rules());
        this.helper.addIfContent(policyObject, "uses", context, policy.uses());
        this.helper.addIfContent(policyObject, "description", context, policy.description());
        this.helper.addIfTrueVal(policyObject, "default", policy.defaultPolicy());
        this.helper.addIfTrueVal(policyObject, "internal", policy.internal());
        this.helper.addIfContent(policyObject, "annotations", context, policy.annotations());
        return policyObject;
    }
}

