/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.dcn.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.sap.cloud.security.ams.dcl.client.dcn.Effect;
import com.sap.cloud.security.ams.dcl.client.dcn.Rule;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnBase;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnGsonTools;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnSerializerHelper;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

class RuleSerializer
extends DcnBase<Rule> {
    public RuleSerializer(DcnSerializerHelper helper) {
        super(helper);
    }

    @Override
    public Rule deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject ruleObject = jsonElement.getAsJsonObject();
        Rule rule = new Rule();
        rule.effect((Effect)((Object)context.deserialize(ruleObject.get("rule"), (Type)((Object)Effect.class))));
        rule.actions((List)context.deserialize(ruleObject.get("actions"), DcnGsonTools.TT_LIST_STRING));
        rule.resources((List)context.deserialize(ruleObject.get("resources"), DcnGsonTools.TT_LIST_STRING));
        rule.condition(this.helper.deserializeExpression(ruleObject.get("condition"), context));
        rule.role(this.helper.getBoolean(ruleObject, "role", false));
        rule.annotations((Map)context.deserialize(ruleObject.get("annotations"), (Type)((Object)Map.class)));
        return rule;
    }

    @Override
    public JsonElement serialize(Rule rule, Type type, JsonSerializationContext context) {
        JsonObject ruleObject = new JsonObject();
        ruleObject.add("rule", context.serialize((Object)rule.effect()));
        this.helper.addIfContent(ruleObject, "actions", context, rule.actions());
        this.helper.addIfContent(ruleObject, "resources", context, rule.resources());
        ruleObject.add("condition", context.serialize(rule.condition()));
        this.helper.addIfTrueVal(ruleObject, "role", rule.role());
        this.helper.addIfContent(ruleObject, "annotations", context, rule.annotations());
        return ruleObject;
    }
}

