/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.dcn.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.sap.cloud.security.ams.dcl.client.dcn.DataType;
import com.sap.cloud.security.ams.dcl.client.dcn.SchemaAttribute;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnBase;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnSerializerHelper;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;

class SchemaAttributeSerializer
extends DcnBase<SchemaAttribute> {
    public SchemaAttributeSerializer(DcnSerializerHelper helper) {
        super(helper);
    }

    @Override
    public SchemaAttribute deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject schemaAttributeObject = (JsonObject)json;
        SchemaAttribute schemaAttribute = new SchemaAttribute();
        JsonElement typeEl = schemaAttributeObject.get("attribute");
        if (typeEl == null) {
            typeEl = schemaAttributeObject.get("element");
        }
        schemaAttribute.type((DataType)((Object)context.deserialize(typeEl, (Type)((Object)DataType.class))));
        JsonObject jDef = schemaAttributeObject.getAsJsonObject("nested");
        if (jDef != null) {
            LinkedHashMap<String, SchemaAttribute> def = new LinkedHashMap<String, SchemaAttribute>();
            schemaAttribute.nested(def);
            for (Map.Entry<String, JsonElement> el : jDef.entrySet()) {
                def.put(el.getKey(), (SchemaAttribute)context.deserialize(el.getValue(), (Type)((Object)SchemaAttribute.class)));
            }
        }
        schemaAttribute.annotations((Map)context.deserialize(schemaAttributeObject.get("annotations"), (Type)((Object)Map.class)));
        return schemaAttribute;
    }

    @Override
    public JsonElement serialize(SchemaAttribute se, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject schemaAttributeObject = new JsonObject();
        schemaAttributeObject.add("attribute", context.serialize((Object)se.type()));
        this.helper.addIfContent(schemaAttributeObject, "nested", context, se.nested());
        this.helper.addIfContent(schemaAttributeObject, "annotations", context, se.annotations());
        return schemaAttributeObject;
    }
}

