/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.dcn.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.sap.cloud.security.ams.dcl.client.dcn.Schema;
import com.sap.cloud.security.ams.dcl.client.dcn.SchemaAttribute;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnBase;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnSerializerHelper;
import com.sap.cloud.security.ams.dcl.client.el.AttributeName;
import com.sap.cloud.security.ams.dcl.client.el.QualifiedName;
import java.lang.reflect.Type;
import java.util.Map;

class SchemaSerializer
extends DcnBase<Schema> {
    private static final JsonArray EMPTY_REFERENCE = new JsonArray();

    public SchemaSerializer(DcnSerializerHelper helper) {
        super(helper);
    }

    @Override
    public Schema deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject schemaObject = json.getAsJsonObject();
        Schema schema = new Schema();
        schema.qualifiedName(this.helper.deserializeReferenceAsQualifiedName(schemaObject.get("schema")));
        schema.tenant((String)context.deserialize(schemaObject.get("tenant"), (Type)((Object)String.class)));
        schema.definition((SchemaAttribute)context.deserialize(schemaObject.get("definition"), (Type)((Object)SchemaAttribute.class)));
        schema.annotations((Map)context.deserialize(schemaObject.get("annotations"), (Type)((Object)Map.class)));
        this.fillTransientFields(schema.definition(), AttributeName.EMPTY);
        return schema;
    }

    private void fillTransientFields(SchemaAttribute se, AttributeName attributeName) {
        se.attributeName(attributeName);
        if (se.nested() != null) {
            for (Map.Entry<String, SchemaAttribute> entry : se.nested().entrySet()) {
                this.fillTransientFields(entry.getValue(), (AttributeName)attributeName.append(entry.getKey()));
            }
        }
    }

    @Override
    public JsonElement serialize(Schema schema, Type type, JsonSerializationContext context) {
        JsonObject schemaObject = new JsonObject();
        QualifiedName qn = schema.qualifiedName();
        schemaObject.add("schema", qn == null || qn.isEmpty() ? EMPTY_REFERENCE : this.helper.serializeAsReference(qn));
        schemaObject.add("definition", context.serialize(schema.definition()));
        this.helper.addIfContent(schemaObject, "tenant", context, schema.tenant());
        this.helper.addIfContent(schemaObject, "annotations", context, schema.annotations());
        return schemaObject;
    }
}

