/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.dcn.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.sap.cloud.security.ams.dcl.client.dcn.TestAssertion;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnBase;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnGsonTools;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnSerializerHelper;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

class TestAssertionSerializer
extends DcnBase<TestAssertion> {
    public TestAssertionSerializer(DcnSerializerHelper helper) {
        super(helper);
    }

    @Override
    public TestAssertion deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject testAssertionObject = jsonElement.getAsJsonObject();
        TestAssertion testCase = new TestAssertion();
        testCase.expect(this.helper.deserializeExpression(testAssertionObject.get("expect"), context));
        testCase.actions((List)context.deserialize(testAssertionObject.get("actions"), DcnGsonTools.TT_LIST_STRING));
        testCase.resources((List)context.deserialize(testAssertionObject.get("resources"), DcnGsonTools.TT_LIST_STRING));
        testCase.policies((List)context.deserialize(testAssertionObject.get("policies"), DcnGsonTools.TT_LIST_QUALIFIED_NAME));
        testCase.scopeFilter((List)context.deserialize(testAssertionObject.get("scopeFilter"), DcnGsonTools.TT_LIST_QUALIFIED_NAME));
        testCase.testInputs((List)context.deserialize(testAssertionObject.get("inputs"), DcnGsonTools.TT_LIST_TEST_INPUT));
        testCase.annotations((Map)context.deserialize(testAssertionObject.get("annotations"), (Type)((Object)Map.class)));
        return testCase;
    }

    @Override
    public JsonElement serialize(TestAssertion testAssertion, Type type, JsonSerializationContext context) {
        JsonObject testAssertionObject = new JsonObject();
        testAssertionObject.add("expect", context.serialize(testAssertion.expect()));
        this.helper.addIfContent(testAssertionObject, "actions", context, testAssertion.actions());
        this.helper.addIfContent(testAssertionObject, "resources", context, testAssertion.resources());
        this.helper.addIfContent(testAssertionObject, "policies", context, testAssertion.policies());
        this.helper.addIfContent(testAssertionObject, "scopeFilter", context, testAssertion.scopeFilter());
        this.helper.addIfContent(testAssertionObject, "inputs", context, testAssertion.testInputs());
        this.helper.addIfContent(testAssertionObject, "annotations", context, testAssertion.annotations());
        return testAssertionObject;
    }
}

