/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.ams.dcl.client.dcn.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.sap.cloud.security.ams.dcl.client.dcn.TestCase;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnBase;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnGsonTools;
import com.sap.cloud.security.ams.dcl.client.dcn.gson.DcnSerializerHelper;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

class TestCaseSerializer
extends DcnBase<TestCase> {
    public TestCaseSerializer(DcnSerializerHelper helper) {
        super(helper);
    }

    @Override
    public TestCase deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject testCaseObject = jsonElement.getAsJsonObject();
        TestCase testCase = new TestCase();
        testCase.qualifiedName(this.helper.deserializeReferenceAsQualifiedName(testCaseObject.get("test")));
        testCase.testAssertions((List)context.deserialize(testCaseObject.get("assertions"), DcnGsonTools.TT_LIST_TEST_ASSERTIONS));
        testCase.annotations((Map)context.deserialize(testCaseObject.get("annotations"), (Type)((Object)Map.class)));
        return testCase;
    }

    @Override
    public JsonElement serialize(TestCase testCase, Type type, JsonSerializationContext context) {
        JsonObject testCaseObject = new JsonObject();
        testCaseObject.add("test", this.helper.serializeAsReference(testCase.qualifiedName()));
        this.helper.addIfContent(testCaseObject, "assertions", context, testCase.testAssertions());
        this.helper.addIfContent(testCaseObject, "annotations", context, testCase.annotations());
        return testCaseObject;
    }
}

